/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.statement.metadata;

import com.google.common.util.concurrent.SettableFuture;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseInfo;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.queryengine.plan.statement.IConfigStatement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.ShowStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class ShowDatabaseStatement
extends ShowStatement
implements IConfigStatement {
    private final PartialPath pathPattern;
    private boolean isDetailed;

    public ShowDatabaseStatement(PartialPath pathPattern) {
        this.pathPattern = pathPattern;
        this.isDetailed = false;
    }

    public PartialPath getPathPattern() {
        return this.pathPattern;
    }

    public boolean isDetailed() {
        return this.isDetailed;
    }

    public void setDetailed(boolean detailed) {
        this.isDetailed = detailed;
    }

    public void buildTSBlock(Map<String, TDatabaseInfo> storageGroupInfoMap, SettableFuture<ConfigTaskResult> future) throws IllegalPathException {
        List outputDataTypes = this.isDetailed ? ColumnHeaderConstant.showStorageGroupsDetailColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList()) : ColumnHeaderConstant.showStorageGroupsColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        for (Map.Entry<String, TDatabaseInfo> entry : storageGroupInfoMap.entrySet()) {
            String storageGroup = entry.getKey();
            TDatabaseInfo storageGroupInfo = entry.getValue();
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(storageGroup, TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(1).writeInt(storageGroupInfo.getSchemaReplicationFactor());
            builder.getColumnBuilder(2).writeInt(storageGroupInfo.getDataReplicationFactor());
            builder.getColumnBuilder(3).writeLong(storageGroupInfo.getTimePartitionOrigin());
            builder.getColumnBuilder(4).writeLong(storageGroupInfo.getTimePartitionInterval());
            if (this.isDetailed) {
                builder.getColumnBuilder(5).writeInt(storageGroupInfo.getSchemaRegionNum());
                builder.getColumnBuilder(6).writeInt(storageGroupInfo.getMinSchemaRegionNum());
                builder.getColumnBuilder(7).writeInt(storageGroupInfo.getMaxSchemaRegionNum());
                builder.getColumnBuilder(8).writeInt(storageGroupInfo.getDataRegionNum());
                builder.getColumnBuilder(9).writeInt(storageGroupInfo.getMinDataRegionNum());
                builder.getColumnBuilder(10).writeInt(storageGroupInfo.getMaxDataRegionNum());
            }
            builder.declarePosition();
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowStorageGroupHeader(this.isDetailed);
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitShowStorageGroup(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.READ;
    }

    @Override
    public List<PartialPath> getPaths() {
        return Collections.singletonList(this.pathPattern);
    }
}

