/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.ToLongFunction;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.commons.path.NonAlignedFullPath;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.execution.operator.source.FileLoaderUtils;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeTTLCache;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.SeriesScanOptions;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemAlignedPageReader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemPageReader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.DescPriorityMergeReader;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.MergeReaderPriority;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.common.PriorityMergeReader;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IChunkMetadata;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.IMetadata;
import org.apache.tsfile.file.metadata.ITimeSeriesMetadata;
import org.apache.tsfile.file.metadata.StringArrayDeviceID;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.TsBlockUtil;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.reader.IPageReader;
import org.apache.tsfile.read.reader.IPointReader;
import org.apache.tsfile.read.reader.page.AlignedPageReader;
import org.apache.tsfile.read.reader.page.TablePageReader;
import org.apache.tsfile.read.reader.series.PaginationController;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class SeriesScanUtil
implements Accountable {
    public static final StringArrayDeviceID EMPTY_DEVICE_ID = new StringArrayDeviceID("");
    protected final FragmentInstanceContext context;
    protected final IFullPath seriesPath;
    private final IDeviceID deviceID;
    protected boolean isAligned = false;
    private final TSDataType dataType;
    private final TimeOrderUtils orderUtils;
    private QueryDataSource dataSource;
    private int curSeqFileIndex;
    private int curUnseqFileIndex;
    private ITimeSeriesMetadata firstTimeSeriesMetadata;
    private final List<ITimeSeriesMetadata> seqTimeSeriesMetadata;
    private final PriorityQueue<ITimeSeriesMetadata> unSeqTimeSeriesMetadata;
    private IChunkMetadata firstChunkMetadata;
    private final PriorityQueue<IChunkMetadata> cachedChunkMetadata;
    private VersionPageReader firstPageReader;
    private final List<VersionPageReader> seqPageReaders;
    private final PriorityQueue<VersionPageReader> unSeqPageReaders;
    private final PriorityMergeReader mergeReader;
    private boolean hasCachedNextOverlappedPage;
    private TsBlock cachedTsBlock;
    protected SeriesScanOptions scanOptions;
    private final PaginationController paginationController;
    private static final SeriesScanCostMetricSet SERIES_SCAN_COST_METRIC_SET = SeriesScanCostMetricSet.getInstance();
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(SeriesScanUtil.class) + RamUsageEstimator.shallowSizeOfInstance(IDeviceID.class) + RamUsageEstimator.shallowSizeOfInstance(TimeOrderUtils.class) + RamUsageEstimator.shallowSizeOfInstance(PaginationController.class) + RamUsageEstimator.shallowSizeOfInstance(SeriesScanOptions.class);

    public SeriesScanUtil(IFullPath seriesPath, Ordering scanOrder, SeriesScanOptions scanOptions, FragmentInstanceContext context) {
        this.seriesPath = seriesPath;
        this.deviceID = seriesPath.getDeviceId();
        this.dataType = seriesPath.getSeriesType();
        this.scanOptions = scanOptions;
        this.paginationController = scanOptions.getPaginationController();
        this.context = context;
        if (scanOrder.isAscending()) {
            this.orderUtils = new AscTimeOrderUtils();
            this.mergeReader = this.getPriorityMergeReader();
        } else {
            this.orderUtils = new DescTimeOrderUtils();
            this.mergeReader = this.getDescPriorityMergeReader();
        }
        this.mergeReader.setMemoryReservationManager(context.getMemoryReservationContext());
        this.seqTimeSeriesMetadata = new LinkedList<ITimeSeriesMetadata>();
        this.unSeqTimeSeriesMetadata = new PriorityQueue<ITimeSeriesMetadata>(this.orderUtils.comparingLong(timeSeriesMetadata -> this.orderUtils.getOrderTime((Statistics<? extends Object>)timeSeriesMetadata.getStatistics())));
        this.cachedChunkMetadata = new PriorityQueue<IChunkMetadata>(this.orderUtils.comparingLong(chunkMetadata -> this.orderUtils.getOrderTime((Statistics<? extends Object>)chunkMetadata.getStatistics())));
        this.seqPageReaders = new LinkedList<VersionPageReader>();
        this.unSeqPageReaders = new PriorityQueue<VersionPageReader>(this.orderUtils.comparingLong(versionPageReader -> this.orderUtils.getOrderTime((Statistics<? extends Object>)versionPageReader.getStatistics())));
    }

    public void initQueryDataSource(QueryDataSource dataSource) {
        dataSource.fillOrderIndexes(this.deviceID, this.orderUtils.getAscending());
        this.dataSource = dataSource;
        if (this.context.isIgnoreAllNullRows() || this.scanOptions.isTableViewForTreeModel()) {
            if (this.deviceID != EMPTY_DEVICE_ID) {
                long ttl = DataNodeTTLCache.getInstance().getTTLForTree(this.deviceID);
                this.scanOptions.setTTLForTreeDevice(ttl);
            }
        } else if (this.scanOptions.timeFilterNeedUpdatedByTtl()) {
            String databaseName = dataSource.getDatabaseName();
            long ttl = databaseName == null ? Long.MAX_VALUE : DataNodeTTLCache.getInstance().getTTLForTable(databaseName, this.deviceID.getTableName());
            this.scanOptions.setTTLForTableDevice(ttl);
        }
        this.orderUtils.setCurSeqFileIndex(dataSource);
        this.curUnseqFileIndex = 0;
    }

    protected PriorityMergeReader getPriorityMergeReader() {
        return new PriorityMergeReader();
    }

    protected DescPriorityMergeReader getDescPriorityMergeReader() {
        return new DescPriorityMergeReader();
    }

    public Optional<Boolean> hasNextFile() throws IOException {
        if (!this.paginationController.hasCurLimit()) {
            return Optional.of(false);
        }
        if (!this.unSeqPageReaders.isEmpty() || this.firstPageReader != null || this.mergeReader.hasNextTimeValuePair()) {
            throw new IllegalStateException("all cached pages should be consumed first unSeqPageReaders.isEmpty() is " + this.unSeqPageReaders.isEmpty() + " firstPageReader != null is " + (this.firstPageReader != null) + " mergeReader.hasNextTimeValuePair() = " + this.mergeReader.hasNextTimeValuePair());
        }
        if (this.firstChunkMetadata != null || !this.cachedChunkMetadata.isEmpty()) {
            throw new IllegalStateException("all cached chunks should be consumed first");
        }
        if (this.firstTimeSeriesMetadata != null) {
            return Optional.of(true);
        }
        boolean checked = false;
        if (this.orderUtils.hasNextSeqResource() || this.orderUtils.hasNextUnseqResource() || !this.seqTimeSeriesMetadata.isEmpty() || !this.unSeqTimeSeriesMetadata.isEmpty()) {
            this.tryToUnpackAllOverlappedFilesToTimeSeriesMetadata();
            this.filterFirstTimeSeriesMetadata();
            checked = true;
        }
        if (checked && this.firstTimeSeriesMetadata == null) {
            return Optional.empty();
        }
        return Optional.of(this.firstTimeSeriesMetadata != null);
    }

    private boolean currentFileOverlapped() {
        Statistics fileStatistics = this.firstTimeSeriesMetadata.getStatistics();
        return !this.seqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)fileStatistics, (Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics()) || !this.unSeqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)fileStatistics, (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics());
    }

    public boolean canUseCurrentFileStatistics() {
        Preconditions.checkState((this.firstTimeSeriesMetadata != null ? 1 : 0) != 0, (Object)"no first file");
        if (this.currentFileOverlapped() || this.firstTimeSeriesMetadata.isModified()) {
            return false;
        }
        return this.filterAllSatisfy(this.scanOptions.getGlobalTimeFilter(), (IMetadata)this.firstTimeSeriesMetadata) && this.filterAllSatisfy(this.scanOptions.getPushDownFilter(), (IMetadata)this.firstTimeSeriesMetadata);
    }

    public Statistics currentFileTimeStatistics() {
        return this.firstTimeSeriesMetadata.getTimeStatistics();
    }

    public Statistics currentFileStatistics(int index) {
        return this.firstTimeSeriesMetadata.getMeasurementStatistics(index).orElse(null);
    }

    public void skipCurrentFile() {
        this.firstTimeSeriesMetadata = null;
    }

    public Optional<Boolean> hasNextChunk() throws IOException {
        if (!this.paginationController.hasCurLimit()) {
            return Optional.of(false);
        }
        if (!this.unSeqPageReaders.isEmpty() || this.firstPageReader != null || this.mergeReader.hasNextTimeValuePair()) {
            throw new IllegalStateException("all cached pages should be consumed first unSeqPageReaders.isEmpty() is " + this.unSeqPageReaders.isEmpty() + " firstPageReader != null is " + (this.firstPageReader != null) + " mergeReader.hasNextTimeValuePair() = " + this.mergeReader.hasNextTimeValuePair());
        }
        if (this.firstChunkMetadata != null) {
            return Optional.of(true);
        }
        if (this.firstTimeSeriesMetadata == null && this.cachedChunkMetadata.isEmpty()) {
            return Optional.of(false);
        }
        Optional<Boolean> hasNextFileReturnValue = null;
        while (this.firstChunkMetadata == null) {
            if (this.cachedChunkMetadata.isEmpty()) {
                if (hasNextFileReturnValue != null) {
                    return Optional.empty();
                }
                hasNextFileReturnValue = this.hasNextFile();
                if (!hasNextFileReturnValue.isPresent() || !hasNextFileReturnValue.get().booleanValue()) {
                    return hasNextFileReturnValue;
                }
            }
            this.initFirstChunkMetadata();
            this.filterFirstChunkMetadata();
        }
        return Optional.of(this.firstChunkMetadata != null);
    }

    private void filterFirstChunkMetadata() {
        long rowCount;
        if (this.firstChunkMetadata == null) {
            return;
        }
        if (this.currentChunkOverlapped() || this.firstChunkMetadata.isModified()) {
            return;
        }
        Filter pushDownFilter = this.scanOptions.getPushDownFilter();
        if (pushDownFilter != null && pushDownFilter.canSkip((IMetadata)this.firstChunkMetadata)) {
            this.skipCurrentChunk();
            return;
        }
        Filter globalTimeFilter = this.scanOptions.getGlobalTimeFilter();
        if (this.filterAllSatisfy(globalTimeFilter, (IMetadata)this.firstChunkMetadata) && this.filterAllSatisfy(pushDownFilter, (IMetadata)this.firstChunkMetadata) && this.timeAllSelected((IMetadata)this.firstChunkMetadata) && this.paginationController.hasCurOffset(rowCount = (long)this.firstChunkMetadata.getStatistics().getCount())) {
            this.skipCurrentChunk();
            this.paginationController.consumeOffset(rowCount);
        }
    }

    private void initFirstChunkMetadata() throws IOException {
        if (this.firstTimeSeriesMetadata != null) {
            this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstTimeSeriesMetadata.getStatistics()));
            this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstTimeSeriesMetadata.getStatistics()), true);
        } else {
            while (!this.cachedChunkMetadata.isEmpty()) {
                this.firstChunkMetadata = this.cachedChunkMetadata.peek();
                this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstChunkMetadata.getStatistics()));
                this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstChunkMetadata.getStatistics()), false);
                if (!this.firstChunkMetadata.equals(this.cachedChunkMetadata.peek())) continue;
                this.firstChunkMetadata = this.cachedChunkMetadata.poll();
                break;
            }
        }
    }

    private void unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(long endpointTime, boolean init) {
        while (!this.seqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics())) {
            this.unpackOneTimeSeriesMetadata(this.seqTimeSeriesMetadata.remove(0));
        }
        while (!this.unSeqTimeSeriesMetadata.isEmpty() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics())) {
            this.unpackOneTimeSeriesMetadata(this.unSeqTimeSeriesMetadata.poll());
        }
        if (this.firstTimeSeriesMetadata != null && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.firstTimeSeriesMetadata.getStatistics())) {
            this.unpackOneTimeSeriesMetadata(this.firstTimeSeriesMetadata);
            this.firstTimeSeriesMetadata = null;
        }
        if (init && this.firstChunkMetadata == null && !this.cachedChunkMetadata.isEmpty()) {
            this.firstChunkMetadata = this.cachedChunkMetadata.poll();
        }
    }

    protected void unpackOneTimeSeriesMetadata(ITimeSeriesMetadata timeSeriesMetadata) {
        List<IChunkMetadata> chunkMetadataList = FileLoaderUtils.loadChunkMetadataList(timeSeriesMetadata);
        chunkMetadataList.forEach(chunkMetadata -> chunkMetadata.setSeq(timeSeriesMetadata.isSeq()));
        this.cachedChunkMetadata.addAll(chunkMetadataList);
    }

    private boolean currentChunkOverlapped() {
        Statistics chunkStatistics = this.firstChunkMetadata.getStatistics();
        return !this.cachedChunkMetadata.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)chunkStatistics, (Statistics<? extends Object>)this.cachedChunkMetadata.peek().getStatistics());
    }

    public boolean canUseCurrentChunkStatistics() {
        Preconditions.checkState((this.firstChunkMetadata != null ? 1 : 0) != 0, (Object)"no first chunk");
        if (this.currentChunkOverlapped() || this.firstChunkMetadata.isModified()) {
            return false;
        }
        return this.filterAllSatisfy(this.scanOptions.getGlobalTimeFilter(), (IMetadata)this.firstChunkMetadata) && this.filterAllSatisfy(this.scanOptions.getPushDownFilter(), (IMetadata)this.firstChunkMetadata);
    }

    public Statistics currentChunkTimeStatistics() {
        return this.firstChunkMetadata.getTimeStatistics();
    }

    public Statistics currentChunkStatistics(int index) {
        return this.firstChunkMetadata.getMeasurementStatistics(index).orElse(null);
    }

    public void skipCurrentChunk() {
        this.firstChunkMetadata = null;
    }

    public boolean hasNextPage() throws IOException {
        if (!this.paginationController.hasCurLimit()) {
            return false;
        }
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        if ((this.mergeReader.hasNextTimeValuePair() || this.firstPageOverlapped()) && this.hasNextOverlappedPage()) {
            this.cachedTsBlock = this.nextOverlappedPage();
            if (this.cachedTsBlock != null && !this.cachedTsBlock.isEmpty()) {
                this.hasCachedNextOverlappedPage = true;
                return true;
            }
        }
        if (this.firstPageReader != null) {
            return true;
        }
        if (this.firstChunkMetadata != null) {
            this.unpackAllOverlappedChunkMetadataToPageReaders(this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstChunkMetadata.getStatistics()), true);
        } else {
            this.initFirstPageReader();
        }
        if (this.isExistOverlappedPage()) {
            return true;
        }
        while (!(this.firstPageReader != null || this.seqPageReaders.isEmpty() && this.unSeqPageReaders.isEmpty())) {
            this.initFirstPageReader();
            if (!this.isExistOverlappedPage()) continue;
            return true;
        }
        return this.firstPageReader != null;
    }

    private boolean isExistOverlappedPage() throws IOException {
        if (this.firstPageOverlapped() && this.hasNextOverlappedPage()) {
            this.cachedTsBlock = this.nextOverlappedPage();
            if (this.cachedTsBlock != null && !this.cachedTsBlock.isEmpty()) {
                this.hasCachedNextOverlappedPage = true;
                return true;
            }
        }
        return false;
    }

    private boolean firstPageOverlapped() throws IOException {
        if (this.firstPageReader == null) {
            return false;
        }
        long endpointTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstPageReader.getStatistics());
        this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(endpointTime);
        this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(endpointTime, false);
        this.unpackAllOverlappedChunkMetadataToPageReaders(endpointTime, false);
        return !this.seqPageReaders.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)this.firstPageReader.getStatistics(), (Statistics<? extends Object>)this.seqPageReaders.get(0).getStatistics()) || !this.unSeqPageReaders.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)this.firstPageReader.getStatistics(), (Statistics<? extends Object>)this.unSeqPageReaders.peek().getStatistics()) || this.mergeReader.hasNextTimeValuePair() && this.orderUtils.isOverlapped(this.mergeReader.currentTimeValuePair().getTimestamp(), (Statistics<? extends Object>)this.firstPageReader.getStatistics());
    }

    private void unpackAllOverlappedChunkMetadataToPageReaders(long endpointTime, boolean init) throws IOException {
        if (this.firstChunkMetadata != null && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.firstChunkMetadata.getStatistics())) {
            this.unpackOneChunkMetaData(this.firstChunkMetadata);
            this.firstChunkMetadata = null;
        }
        boolean hasMeetSeq = false;
        while (!(this.cachedChunkMetadata.isEmpty() || !this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.cachedChunkMetadata.peek().getStatistics()) || this.cachedChunkMetadata.peek().isSeq() && hasMeetSeq)) {
            if (this.cachedChunkMetadata.peek().isSeq()) {
                hasMeetSeq = true;
            }
            this.unpackOneChunkMetaData(this.cachedChunkMetadata.poll());
        }
        if (!(!init || this.firstPageReader != null || this.seqPageReaders.isEmpty() && this.unSeqPageReaders.isEmpty())) {
            this.initFirstPageReader();
        }
    }

    private void unpackOneChunkMetaData(IChunkMetadata chunkMetaData) throws IOException {
        List<IPageReader> pageReaderList = FileLoaderUtils.loadPageReaderList(chunkMetaData, this.scanOptions.getGlobalTimeFilter());
        long timestampInFileName = FileLoaderUtils.getTimestampInFileName(chunkMetaData);
        pageReaderList.forEach(p -> p.initTsBlockBuilder(this.getTsDataTypeList()));
        if (chunkMetaData.isSeq()) {
            if (this.orderUtils.getAscending()) {
                for (IPageReader iPageReader : pageReaderList) {
                    this.seqPageReaders.add(new VersionPageReader(this.context, timestampInFileName, chunkMetaData.getVersion(), chunkMetaData.getOffsetOfChunkHeader(), iPageReader, true));
                }
            } else {
                for (int i = pageReaderList.size() - 1; i >= 0; --i) {
                    this.seqPageReaders.add(new VersionPageReader(this.context, timestampInFileName, chunkMetaData.getVersion(), chunkMetaData.getOffsetOfChunkHeader(), pageReaderList.get(i), true));
                }
            }
        } else {
            pageReaderList.forEach(pageReader -> this.unSeqPageReaders.add(new VersionPageReader(this.context, timestampInFileName, chunkMetaData.getVersion(), chunkMetaData.getOffsetOfChunkHeader(), (IPageReader)pageReader, false)));
        }
    }

    private boolean currentPageOverlapped() throws IOException {
        if (this.hasCachedNextOverlappedPage) {
            return true;
        }
        if (this.mergeReader.hasNextTimeValuePair()) {
            long mergeReaderTime = this.mergeReader.currentTimeValuePair().getTimestamp();
            if (this.orderUtils.getAscending() && mergeReaderTime <= this.firstPageReader.getStatistics().getEndTime() || !this.orderUtils.getAscending() && mergeReaderTime >= this.firstPageReader.getStatistics().getStartTime()) {
                throw new IllegalStateException("overlapped data should be consumed first");
            }
        }
        Statistics firstPageStatistics = this.firstPageReader.getStatistics();
        return !this.unSeqPageReaders.isEmpty() && this.orderUtils.isOverlapped((Statistics<? extends Object>)firstPageStatistics, (Statistics<? extends Object>)this.unSeqPageReaders.peek().getStatistics());
    }

    public boolean canUseCurrentPageStatistics() throws IOException {
        Statistics currentPageStatistics = this.currentPageTimeStatistics();
        if (currentPageStatistics == null) {
            return false;
        }
        if (this.currentPageOverlapped() || this.firstPageReader.isModified()) {
            return false;
        }
        return this.filterAllSatisfy(this.scanOptions.getGlobalTimeFilter(), (IMetadata)this.firstPageReader.data) && this.filterAllSatisfy(this.scanOptions.getPushDownFilter(), (IMetadata)this.firstPageReader.data);
    }

    public Statistics currentPageTimeStatistics() {
        if (this.firstPageReader == null) {
            return null;
        }
        return this.firstPageReader.getTimeStatistics();
    }

    public Statistics currentPageStatistics(int index) {
        if (this.firstPageReader == null) {
            return null;
        }
        return this.firstPageReader.getMeasurementStatistics(index);
    }

    public void skipCurrentPage() {
        this.firstPageReader = null;
    }

    public TsBlock nextPage() throws IOException {
        TsBlock tsBlock;
        if (this.hasCachedNextOverlappedPage) {
            this.hasCachedNextOverlappedPage = false;
            TsBlock res = this.applyPushDownFilterAndLimitOffset(this.cachedTsBlock, this.scanOptions.getPushDownFilter(), this.paginationController);
            this.cachedTsBlock = null;
            return res;
        }
        this.filterFirstPageReader();
        if (this.firstPageReader == null) {
            return null;
        }
        this.firstPageReader.addPushDownFilter(this.scanOptions.getPushDownFilter());
        if (this.orderUtils.getAscending()) {
            this.firstPageReader.setLimitOffset(this.paginationController);
            tsBlock = this.firstPageReader.getAllSatisfiedPageData(this.orderUtils.getAscending());
        } else {
            tsBlock = this.paginationController.applyTsBlock(this.firstPageReader.getAllSatisfiedPageData(this.orderUtils.getAscending()));
        }
        this.firstPageReader = null;
        return tsBlock;
    }

    private TsBlock applyPushDownFilterAndLimitOffset(TsBlock tsBlock, Filter pushDownFilter, PaginationController paginationController) {
        if (pushDownFilter == null) {
            return paginationController.applyTsBlock(tsBlock);
        }
        return TsBlockUtil.applyFilterAndLimitOffsetToTsBlock((TsBlock)tsBlock, (TsBlockBuilder)new TsBlockBuilder(this.getTsDataTypeList()), (Filter)pushDownFilter, (PaginationController)paginationController);
    }

    private void filterFirstPageReader() {
        long rowCount;
        if (this.firstPageReader == null) {
            return;
        }
        IPageReader pageReader = this.firstPageReader.data;
        if (pageReader.isModified()) {
            return;
        }
        Filter pushDownFilter = this.scanOptions.getPushDownFilter();
        if (pushDownFilter != null && pushDownFilter.canSkip((IMetadata)pageReader)) {
            this.skipCurrentPage();
            return;
        }
        Filter globalTimeFilter = this.scanOptions.getGlobalTimeFilter();
        if (this.filterAllSatisfy(globalTimeFilter, (IMetadata)pageReader) && this.filterAllSatisfy(pushDownFilter, (IMetadata)pageReader) && this.timeAllSelected((IMetadata)pageReader) && this.paginationController.hasCurOffset(rowCount = (long)pageReader.getStatistics().getCount())) {
            this.skipCurrentPage();
            this.paginationController.consumeOffset(rowCount);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean hasNextOverlappedPage() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long updateEndPointTime(long currentPageEndPointTime, VersionPageReader pageReader) {
        if (this.orderUtils.getAscending()) {
            return Math.min(currentPageEndPointTime, pageReader.getStatistics().getEndTime());
        }
        return Math.max(currentPageEndPointTime, pageReader.getStatistics().getStartTime());
    }

    private void tryToPutAllDirectlyOverlappedUnseqPageReadersIntoMergeReader() throws IOException {
        if (this.firstPageReader == null && this.unSeqPageReaders.isEmpty() && this.seqPageReaders.isEmpty()) {
            return;
        }
        if (this.firstPageReader == null) {
            this.initFirstPageReader();
        }
        long currentPageEndpointTime = this.mergeReader.hasNextTimeValuePair() ? this.mergeReader.getCurrentReadStopTime() : this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.firstPageReader.getStatistics());
        this.unpackAllOverlappedUnseqPageReadersToMergeReader(currentPageEndpointTime);
    }

    private void addTimeValuePairToResult(TimeValuePair timeValuePair, TsBlockBuilder builder) {
        builder.getTimeColumnBuilder().writeLong(timeValuePair.getTimestamp());
        switch (this.dataType) {
            case BOOLEAN: {
                builder.getColumnBuilder(0).writeBoolean(timeValuePair.getValue().getBoolean());
                break;
            }
            case INT32: 
            case DATE: {
                builder.getColumnBuilder(0).writeInt(timeValuePair.getValue().getInt());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                builder.getColumnBuilder(0).writeLong(timeValuePair.getValue().getLong());
                break;
            }
            case FLOAT: {
                builder.getColumnBuilder(0).writeFloat(timeValuePair.getValue().getFloat());
                break;
            }
            case DOUBLE: {
                builder.getColumnBuilder(0).writeDouble(timeValuePair.getValue().getDouble());
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                builder.getColumnBuilder(0).writeBinary(timeValuePair.getValue().getBinary());
                break;
            }
            case VECTOR: {
                TsPrimitiveType[] values = timeValuePair.getValue().getVector();
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null) {
                        builder.getColumnBuilder(i).appendNull();
                        continue;
                    }
                    builder.getColumnBuilder(i).writeTsPrimitiveType(values[i]);
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf(this.dataType));
            }
        }
        builder.declarePosition();
    }

    private void initFirstPageReader() throws IOException {
        while (this.firstPageReader == null) {
            VersionPageReader firstPageReader = this.getFirstPageReaderFromCachedReaders();
            if (firstPageReader != null) {
                long overlapCheckTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)firstPageReader.getStatistics());
                this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(overlapCheckTime);
                this.unpackAllOverlappedTimeSeriesMetadataToCachedChunkMetadata(overlapCheckTime, false);
                this.unpackAllOverlappedChunkMetadataToPageReaders(overlapCheckTime, false);
                if (!firstPageReader.equals(this.getFirstPageReaderFromCachedReaders())) continue;
                this.firstPageReader = firstPageReader;
                if (!this.seqPageReaders.isEmpty() && firstPageReader.equals(this.seqPageReaders.get(0))) {
                    this.seqPageReaders.remove(0);
                    break;
                }
                if (this.unSeqPageReaders.isEmpty() || !firstPageReader.equals(this.unSeqPageReaders.peek())) continue;
                this.unSeqPageReaders.poll();
                break;
            }
            return;
        }
    }

    private VersionPageReader getFirstPageReaderFromCachedReaders() {
        VersionPageReader firstPageReader = null;
        if (!this.seqPageReaders.isEmpty() && !this.unSeqPageReaders.isEmpty()) {
            firstPageReader = this.orderUtils.isTakeSeqAsFirst((Statistics<? extends Object>)this.seqPageReaders.get(0).getStatistics(), (Statistics<? extends Object>)this.unSeqPageReaders.peek().getStatistics()) ? this.seqPageReaders.get(0) : this.unSeqPageReaders.peek();
        } else if (!this.seqPageReaders.isEmpty()) {
            firstPageReader = this.seqPageReaders.get(0);
        } else if (!this.unSeqPageReaders.isEmpty()) {
            firstPageReader = this.unSeqPageReaders.peek();
        }
        return firstPageReader;
    }

    private void unpackAllOverlappedUnseqPageReadersToMergeReader(long endpointTime) throws IOException {
        while (!this.unSeqPageReaders.isEmpty() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.unSeqPageReaders.peek().data.getStatistics())) {
            this.putPageReaderToMergeReader(this.unSeqPageReaders.poll());
        }
        if (this.firstPageReader != null && !this.firstPageReader.isSeq() && this.orderUtils.isOverlapped(endpointTime, (Statistics<? extends Object>)this.firstPageReader.getStatistics())) {
            this.putPageReaderToMergeReader(this.firstPageReader);
            this.firstPageReader = null;
        }
    }

    private void putPageReaderToMergeReader(VersionPageReader pageReader) throws IOException {
        this.mergeReader.addReader(this.getPointReader(pageReader.getAllSatisfiedPageData(this.orderUtils.getAscending())), pageReader.version, this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)pageReader.getStatistics()));
        this.context.getQueryStatistics().getPageReaderMaxUsedMemorySize().updateAndGet(v -> Math.max(v, this.mergeReader.getUsedMemorySize()));
    }

    private TsBlock nextOverlappedPage() throws IOException {
        if (this.hasCachedNextOverlappedPage || this.hasNextOverlappedPage()) {
            this.hasCachedNextOverlappedPage = false;
            return this.cachedTsBlock;
        }
        throw new IOException("No more batch data");
    }

    private void tryToUnpackAllOverlappedFilesToTimeSeriesMetadata() throws IOException {
        if (this.seqTimeSeriesMetadata.isEmpty() && this.orderUtils.hasNextSeqResource() && !this.unpackSeqTsFileResource().isPresent()) {
            return;
        }
        if (this.unSeqTimeSeriesMetadata.isEmpty() && this.orderUtils.hasNextUnseqResource() && !this.unpackUnseqTsFileResource().isPresent()) {
            return;
        }
        long endTime = -1L;
        if (!this.seqTimeSeriesMetadata.isEmpty() && this.unSeqTimeSeriesMetadata.isEmpty()) {
            endTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics());
        } else if (this.seqTimeSeriesMetadata.isEmpty() && !this.unSeqTimeSeriesMetadata.isEmpty()) {
            endTime = this.orderUtils.getOverlapCheckTime((Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics());
        } else if (!this.seqTimeSeriesMetadata.isEmpty()) {
            endTime = this.orderUtils.getCurrentEndPoint((Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics(), (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics());
        }
        if (endTime != -1L) {
            this.unpackAllOverlappedTsFilesToTimeSeriesMetadata(endTime);
        }
        if (!this.seqTimeSeriesMetadata.isEmpty() && this.unSeqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.seqTimeSeriesMetadata.remove(0);
        } else if (this.seqTimeSeriesMetadata.isEmpty() && !this.unSeqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.unSeqTimeSeriesMetadata.poll();
        } else if (!this.seqTimeSeriesMetadata.isEmpty()) {
            this.firstTimeSeriesMetadata = this.orderUtils.isTakeSeqAsFirst((Statistics<? extends Object>)this.seqTimeSeriesMetadata.get(0).getStatistics(), (Statistics<? extends Object>)this.unSeqTimeSeriesMetadata.peek().getStatistics()) ? this.seqTimeSeriesMetadata.remove(0) : this.unSeqTimeSeriesMetadata.poll();
        }
    }

    private void filterFirstTimeSeriesMetadata() {
        long rowCount;
        if (this.firstTimeSeriesMetadata == null) {
            return;
        }
        if (this.currentFileOverlapped() || this.firstTimeSeriesMetadata.isModified()) {
            return;
        }
        Filter pushDownFilter = this.scanOptions.getPushDownFilter();
        if (pushDownFilter != null && pushDownFilter.canSkip((IMetadata)this.firstTimeSeriesMetadata)) {
            this.skipCurrentFile();
            return;
        }
        Filter globalTimeFilter = this.scanOptions.getGlobalTimeFilter();
        if (this.filterAllSatisfy(globalTimeFilter, (IMetadata)this.firstTimeSeriesMetadata) && this.filterAllSatisfy(pushDownFilter, (IMetadata)this.firstTimeSeriesMetadata) && this.timeAllSelected((IMetadata)this.firstTimeSeriesMetadata) && this.paginationController.hasCurOffset(rowCount = (long)this.firstTimeSeriesMetadata.getStatistics().getCount())) {
            this.skipCurrentFile();
            this.paginationController.consumeOffset(rowCount);
        }
    }

    private void unpackAllOverlappedTsFilesToTimeSeriesMetadata(long endpointTime) throws IOException {
        Optional<ITimeSeriesMetadata> timeSeriesMetadata;
        while (this.orderUtils.hasNextUnseqResource() && this.orderUtils.isCurUnSeqOverlappedWith(endpointTime)) {
            this.unpackUnseqTsFileResource();
        }
        while (this.orderUtils.hasNextSeqResource() && this.orderUtils.isCurSeqOverlappedWith(endpointTime) && (!(timeSeriesMetadata = this.unpackSeqTsFileResource()).isPresent() || !this.orderUtils.overlappedSeqResourceSearchingNeedStop(endpointTime, (Statistics<? extends Object>)timeSeriesMetadata.get().getStatistics()))) {
        }
    }

    private Optional<ITimeSeriesMetadata> unpackSeqTsFileResource() throws IOException {
        ITimeSeriesMetadata timeseriesMetadata = this.loadTimeSeriesMetadata(this.orderUtils.getNextSeqFileResource(true), true);
        if (timeseriesMetadata != null && timeseriesMetadata.typeMatch(this.getTsDataTypeList())) {
            timeseriesMetadata.setSeq(true);
            this.seqTimeSeriesMetadata.add(timeseriesMetadata);
            return Optional.of(timeseriesMetadata);
        }
        return Optional.empty();
    }

    private Optional<ITimeSeriesMetadata> unpackUnseqTsFileResource() throws IOException {
        ITimeSeriesMetadata timeseriesMetadata = this.loadTimeSeriesMetadata(this.orderUtils.getNextUnseqFileResource(true), false);
        if (timeseriesMetadata != null && timeseriesMetadata.typeMatch(this.getTsDataTypeList())) {
            timeseriesMetadata.setSeq(false);
            this.unSeqTimeSeriesMetadata.add(timeseriesMetadata);
            return Optional.of(timeseriesMetadata);
        }
        return Optional.empty();
    }

    protected ITimeSeriesMetadata loadTimeSeriesMetadata(TsFileResource resource, boolean isSeq) throws IOException {
        return FileLoaderUtils.loadTimeSeriesMetadata(resource, (NonAlignedFullPath)this.seriesPath, this.context, this.scanOptions.getGlobalTimeFilter(), this.scanOptions.getAllSensors(), isSeq);
    }

    public List<TSDataType> getTsDataTypeList() {
        return Collections.singletonList(this.dataType);
    }

    protected IPointReader getPointReader(TsBlock tsBlock) {
        return tsBlock.getTsBlockSingleColumnIterator();
    }

    protected boolean timeAllSelected(IMetadata metadata) {
        return true;
    }

    private boolean filterAllSatisfy(Filter filter, IMetadata metadata) {
        return filter == null || filter.allSatisfy(metadata);
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.deviceID.ramBytesUsed() + this.seriesPath.ramBytesUsed();
    }

    private /* synthetic */ long lambda$hasNextOverlappedPage$7(long v) {
        return Math.max(v, this.mergeReader.getUsedMemorySize());
    }

    private /* synthetic */ long lambda$hasNextOverlappedPage$6(long v) {
        return Math.max(v, this.mergeReader.getUsedMemorySize());
    }

    class AscTimeOrderUtils
    implements TimeOrderUtils {
        AscTimeOrderUtils() {
        }

        public long getOrderTime(Statistics statistics) {
            return statistics.getStartTime();
        }

        public long getOverlapCheckTime(Statistics range) {
            return range.getEndTime();
        }

        public boolean isOverlapped(Statistics left, Statistics right) {
            return left.getEndTime() >= right.getStartTime();
        }

        public boolean isOverlapped(long time, Statistics right) {
            return time >= right.getStartTime();
        }

        @Override
        public boolean isCurSeqOverlappedWith(long time) {
            return time >= SeriesScanUtil.this.dataSource.getCurrentSeqOrderTime(SeriesScanUtil.this.curSeqFileIndex);
        }

        @Override
        public boolean isCurUnSeqOverlappedWith(long time) {
            return time >= SeriesScanUtil.this.dataSource.getCurrentUnSeqOrderTime(SeriesScanUtil.this.curUnseqFileIndex);
        }

        @Override
        public <T> Comparator<T> comparingLong(ToLongFunction<? super T> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            return (Comparator & Serializable)(c1, c2) -> Long.compare(keyExtractor.applyAsLong(c1), keyExtractor.applyAsLong(c2));
        }

        @Override
        public long getCurrentEndPoint(long time, Statistics<? extends Object> statistics) {
            return Math.min(time, statistics.getEndTime());
        }

        @Override
        public long getCurrentEndPoint(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return Math.min(seqStatistics.getEndTime(), unseqStatistics.getEndTime());
        }

        @Override
        public boolean isExcessEndpoint(long time, long endpointTime) {
            return time > endpointTime;
        }

        @Override
        public boolean isTakeSeqAsFirst(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return seqStatistics.getStartTime() < unseqStatistics.getStartTime();
        }

        @Override
        public boolean getAscending() {
            return true;
        }

        @Override
        public boolean hasNextSeqResource() {
            while (SeriesScanUtil.this.dataSource.hasNextSeqResource(SeriesScanUtil.this.curSeqFileIndex, true, SeriesScanUtil.this.deviceID) && !SeriesScanUtil.this.dataSource.isSeqSatisfied(SeriesScanUtil.this.deviceID, SeriesScanUtil.this.curSeqFileIndex, SeriesScanUtil.this.scanOptions.getGlobalTimeFilter(), false)) {
                SeriesScanUtil.this.curSeqFileIndex++;
            }
            return SeriesScanUtil.this.dataSource.hasNextSeqResource(SeriesScanUtil.this.curSeqFileIndex, true, SeriesScanUtil.this.deviceID);
        }

        @Override
        public boolean hasNextUnseqResource() {
            while (SeriesScanUtil.this.dataSource.hasNextUnseqResource(SeriesScanUtil.this.curUnseqFileIndex, true, SeriesScanUtil.this.deviceID) && !SeriesScanUtil.this.dataSource.isUnSeqSatisfied(SeriesScanUtil.this.deviceID, SeriesScanUtil.this.curUnseqFileIndex, SeriesScanUtil.this.scanOptions.getGlobalTimeFilter(), false)) {
                SeriesScanUtil.this.curUnseqFileIndex++;
            }
            return SeriesScanUtil.this.dataSource.hasNextUnseqResource(SeriesScanUtil.this.curUnseqFileIndex, true, SeriesScanUtil.this.deviceID);
        }

        @Override
        public TsFileResource getNextSeqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesScanUtil.this.dataSource.getSeqResourceByIndex(SeriesScanUtil.this.curSeqFileIndex);
            if (isDelete) {
                SeriesScanUtil.this.curSeqFileIndex++;
            }
            return tsFileResource;
        }

        @Override
        public TsFileResource getNextUnseqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesScanUtil.this.dataSource.getUnseqResourceByIndex(SeriesScanUtil.this.curUnseqFileIndex);
            if (isDelete) {
                SeriesScanUtil.this.curUnseqFileIndex++;
            }
            return tsFileResource;
        }

        @Override
        public void setCurSeqFileIndex(QueryDataSource dataSource) {
            SeriesScanUtil.this.curSeqFileIndex = 0;
        }

        public boolean overlappedSeqResourceSearchingNeedStop(long endPointTime, Statistics<?> currentStatistics) {
            return currentStatistics.getEndTime() >= endPointTime;
        }
    }

    public static interface TimeOrderUtils {
        public long getOrderTime(Statistics<? extends Object> var1);

        public long getOverlapCheckTime(Statistics<? extends Object> var1);

        public boolean isOverlapped(Statistics<? extends Object> var1, Statistics<? extends Object> var2);

        public boolean isOverlapped(long var1, Statistics<? extends Object> var3);

        public boolean isCurSeqOverlappedWith(long var1);

        public boolean isCurUnSeqOverlappedWith(long var1);

        public <T> Comparator<T> comparingLong(ToLongFunction<? super T> var1);

        public long getCurrentEndPoint(long var1, Statistics<? extends Object> var3);

        public long getCurrentEndPoint(Statistics<? extends Object> var1, Statistics<? extends Object> var2);

        public boolean isExcessEndpoint(long var1, long var3);

        public boolean isTakeSeqAsFirst(Statistics<? extends Object> var1, Statistics<? extends Object> var2);

        public boolean getAscending();

        public boolean hasNextSeqResource();

        public boolean hasNextUnseqResource();

        public TsFileResource getNextSeqFileResource(boolean var1);

        public TsFileResource getNextUnseqFileResource(boolean var1);

        public void setCurSeqFileIndex(QueryDataSource var1);

        public boolean overlappedSeqResourceSearchingNeedStop(long var1, Statistics<? extends Object> var3);
    }

    class DescTimeOrderUtils
    implements TimeOrderUtils {
        DescTimeOrderUtils() {
        }

        public long getOrderTime(Statistics statistics) {
            return statistics.getEndTime();
        }

        public long getOverlapCheckTime(Statistics range) {
            return range.getStartTime();
        }

        public boolean isOverlapped(Statistics left, Statistics right) {
            return left.getStartTime() <= right.getEndTime();
        }

        public boolean isOverlapped(long time, Statistics right) {
            return time <= right.getEndTime();
        }

        @Override
        public boolean isCurSeqOverlappedWith(long time) {
            return time <= SeriesScanUtil.this.dataSource.getCurrentSeqOrderTime(SeriesScanUtil.this.curSeqFileIndex);
        }

        @Override
        public boolean isCurUnSeqOverlappedWith(long time) {
            return time <= SeriesScanUtil.this.dataSource.getCurrentUnSeqOrderTime(SeriesScanUtil.this.curUnseqFileIndex);
        }

        @Override
        public <T> Comparator<T> comparingLong(ToLongFunction<? super T> keyExtractor) {
            Objects.requireNonNull(keyExtractor);
            return (Comparator & Serializable)(c1, c2) -> Long.compare(keyExtractor.applyAsLong(c2), keyExtractor.applyAsLong(c1));
        }

        @Override
        public long getCurrentEndPoint(long time, Statistics<? extends Object> statistics) {
            return Math.max(time, statistics.getStartTime());
        }

        @Override
        public long getCurrentEndPoint(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return Math.max(seqStatistics.getStartTime(), unseqStatistics.getStartTime());
        }

        @Override
        public boolean isExcessEndpoint(long time, long endpointTime) {
            return time < endpointTime;
        }

        @Override
        public boolean isTakeSeqAsFirst(Statistics<? extends Object> seqStatistics, Statistics<? extends Object> unseqStatistics) {
            return seqStatistics.getEndTime() > unseqStatistics.getEndTime();
        }

        @Override
        public boolean getAscending() {
            return false;
        }

        @Override
        public boolean hasNextSeqResource() {
            while (SeriesScanUtil.this.dataSource.hasNextSeqResource(SeriesScanUtil.this.curSeqFileIndex, false, SeriesScanUtil.this.deviceID) && !SeriesScanUtil.this.dataSource.isSeqSatisfied(SeriesScanUtil.this.deviceID, SeriesScanUtil.this.curSeqFileIndex, SeriesScanUtil.this.scanOptions.getGlobalTimeFilter(), false)) {
                SeriesScanUtil.this.curSeqFileIndex--;
            }
            return SeriesScanUtil.this.dataSource.hasNextSeqResource(SeriesScanUtil.this.curSeqFileIndex, false, SeriesScanUtil.this.deviceID);
        }

        @Override
        public boolean hasNextUnseqResource() {
            while (SeriesScanUtil.this.dataSource.hasNextUnseqResource(SeriesScanUtil.this.curUnseqFileIndex, false, SeriesScanUtil.this.deviceID) && !SeriesScanUtil.this.dataSource.isUnSeqSatisfied(SeriesScanUtil.this.deviceID, SeriesScanUtil.this.curUnseqFileIndex, SeriesScanUtil.this.scanOptions.getGlobalTimeFilter(), false)) {
                SeriesScanUtil.this.curUnseqFileIndex++;
            }
            return SeriesScanUtil.this.dataSource.hasNextUnseqResource(SeriesScanUtil.this.curUnseqFileIndex, false, SeriesScanUtil.this.deviceID);
        }

        @Override
        public TsFileResource getNextSeqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesScanUtil.this.dataSource.getSeqResourceByIndex(SeriesScanUtil.this.curSeqFileIndex);
            if (isDelete) {
                SeriesScanUtil.this.curSeqFileIndex--;
            }
            return tsFileResource;
        }

        @Override
        public TsFileResource getNextUnseqFileResource(boolean isDelete) {
            TsFileResource tsFileResource = SeriesScanUtil.this.dataSource.getUnseqResourceByIndex(SeriesScanUtil.this.curUnseqFileIndex);
            if (isDelete) {
                SeriesScanUtil.this.curUnseqFileIndex++;
            }
            return tsFileResource;
        }

        @Override
        public void setCurSeqFileIndex(QueryDataSource dataSource) {
            SeriesScanUtil.this.curSeqFileIndex = dataSource.getSeqResourcesSize() - 1;
        }

        public boolean overlappedSeqResourceSearchingNeedStop(long endPointTime, Statistics<?> currentStatistics) {
            return currentStatistics.getStartTime() <= endPointTime;
        }
    }

    protected static class VersionPageReader {
        private final QueryContext context;
        private final MergeReaderPriority version;
        private final IPageReader data;
        private final boolean isSeq;
        private final boolean isAligned;
        private final boolean isMem;

        VersionPageReader(QueryContext context, long fileTimestamp, long version, long offset, IPageReader data, boolean isSeq) {
            this.context = context;
            this.version = new MergeReaderPriority(fileTimestamp, version, offset, isSeq);
            this.data = data;
            this.isSeq = isSeq;
            this.isAligned = data instanceof AlignedPageReader || data instanceof MemAlignedPageReader || data instanceof TablePageReader;
            this.isMem = data instanceof MemPageReader || data instanceof MemAlignedPageReader;
        }

        Statistics getStatistics() {
            return this.data.getStatistics();
        }

        Statistics getMeasurementStatistics(int index) {
            return this.data.getMeasurementStatistics(index).orElse(null);
        }

        Statistics getTimeStatistics() {
            return this.data.getTimeStatistics();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TsBlock getAllSatisfiedPageData(boolean ascending) throws IOException {
            long startTime = System.nanoTime();
            try {
                TsBlock tsBlock = this.data.getAllSatisfiedData();
                if (!ascending) {
                    tsBlock.reverse();
                }
                TsBlock tsBlock2 = tsBlock;
                return tsBlock2;
            }
            finally {
                long time = System.nanoTime() - startTime;
                if (this.isAligned) {
                    if (this.isMem) {
                        this.context.getQueryStatistics().getPageReadersDecodeAlignedMemCount().getAndAdd(1L);
                        this.context.getQueryStatistics().getPageReadersDecodeAlignedMemTime().getAndAdd(time);
                    } else {
                        this.context.getQueryStatistics().getPageReadersDecodeAlignedDiskCount().getAndAdd(1L);
                        this.context.getQueryStatistics().getPageReadersDecodeAlignedDiskTime().getAndAdd(time);
                    }
                } else if (this.isMem) {
                    this.context.getQueryStatistics().getPageReadersDecodeNonAlignedMemCount().getAndAdd(1L);
                    this.context.getQueryStatistics().getPageReadersDecodeNonAlignedMemTime().getAndAdd(time);
                } else {
                    this.context.getQueryStatistics().getPageReadersDecodeNonAlignedDiskCount().getAndAdd(1L);
                    this.context.getQueryStatistics().getPageReadersDecodeNonAlignedDiskTime().getAndAdd(time);
                }
            }
        }

        void addPushDownFilter(Filter pushDownFilter) {
            this.data.addRecordFilter(pushDownFilter);
        }

        boolean isModified() {
            return this.data.isModified();
        }

        public boolean isSeq() {
            return this.isSeq;
        }

        public void setLimitOffset(PaginationController paginationController) {
            this.data.setLimitOffset(paginationController);
        }
    }
}

