/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.analyzer;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.execution.warnings.WarningCollector;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Analysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.CorrelationSupport;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ExpressionAnalysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ExpressionTreeUtils;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Field;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.FieldId;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.NodeRef;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.PatternRecognitionAnalysis;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.RelationId;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.RelationType;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.ResolvedField;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.Scope;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.StatementAnalyzer;
import org.apache.iotdb.db.queryengine.plan.relational.analyzer.StatementAnalyzerFactory;
import org.apache.iotdb.db.queryengine.plan.relational.function.BoundSignature;
import org.apache.iotdb.db.queryengine.plan.relational.function.FunctionId;
import org.apache.iotdb.db.queryengine.plan.relational.function.FunctionKind;
import org.apache.iotdb.db.queryengine.plan.relational.function.OperatorType;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.FunctionNullability;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.Metadata;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.OperatorNotFoundException;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.QualifiedObjectName;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ResolvedFunction;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.TableMetadataImpl;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.security.AccessControl;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticBinaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ArithmeticUnaryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BetweenPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BinaryLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Cast;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CoalesceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Columns;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CurrentDatabase;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CurrentTime;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.CurrentUser;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DecimalLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DereferenceExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DoubleLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ExistsPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Extract;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FieldReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FrameBound;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.FunctionCall;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InListExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.InPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNotNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.IsNullPredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LikePredicate;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LogicalExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NotExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullIfExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.OrderBy;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Parameter;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ProcessingMode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QuantifiedComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RangeQuantifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Row;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.RowPattern;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SearchedCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SimpleCaseExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SortItem;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StackableAstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StringLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubqueryExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SubsetDefinition;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Trim;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WhenClause;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.WindowFrame;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeNotFoundException;
import org.apache.iotdb.db.queryengine.plan.relational.type.TypeSignatureTranslator;
import org.apache.iotdb.db.queryengine.plan.relational.utils.NodeUtils;
import org.apache.tsfile.read.common.type.BlobType;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.DoubleType;
import org.apache.tsfile.read.common.type.IntType;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.RowType;
import org.apache.tsfile.read.common.type.StringType;
import org.apache.tsfile.read.common.type.TimestampType;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.read.common.type.UnknownType;

public class ExpressionAnalyzer {
    private final Metadata metadata;
    private final AccessControl accessControl;
    private final BiFunction<Node, CorrelationSupport, StatementAnalyzer> statementAnalyzerFactory;
    private final TypeProvider symbolTypes;
    private final Map<NodeRef<Node>, ResolvedFunction> resolvedFunctions = new LinkedHashMap<NodeRef<Node>, ResolvedFunction>();
    private final Set<NodeRef<SubqueryExpression>> subqueries = new LinkedHashSet<NodeRef<SubqueryExpression>>();
    private final Set<NodeRef<ExistsPredicate>> existsSubqueries = new LinkedHashSet<NodeRef<ExistsPredicate>>();
    private final Set<NodeRef<InPredicate>> subqueryInPredicates = new LinkedHashSet<NodeRef<InPredicate>>();
    private final Map<NodeRef<Expression>, Analysis.PredicateCoercions> predicateCoercions = new LinkedHashMap<NodeRef<Expression>, Analysis.PredicateCoercions>();
    private final Map<NodeRef<Expression>, ResolvedField> columnReferences = new LinkedHashMap<NodeRef<Expression>, ResolvedField>();
    private final Map<NodeRef<Expression>, Type> expressionTypes = new LinkedHashMap<NodeRef<Expression>, Type>();
    private final Set<NodeRef<QuantifiedComparisonExpression>> quantifiedComparisons = new LinkedHashSet<NodeRef<QuantifiedComparisonExpression>>();
    private final Set<NodeRef<FunctionCall>> windowFunctions = new LinkedHashSet<NodeRef<FunctionCall>>();
    private final Multimap<QualifiedObjectName, String> tableColumnReferences = HashMultimap.create();
    private final Multimap<NodeRef<Node>, Field> referencedFields = HashMultimap.create();
    private final Map<NodeRef<Expression>, Optional<String>> labels = new HashMap<NodeRef<Expression>, Optional<String>>();
    private final Map<NodeRef<RangeQuantifier>, Analysis.Range> ranges = new LinkedHashMap<NodeRef<RangeQuantifier>, Analysis.Range>();
    private final Map<NodeRef<RowPattern>, Set<String>> undefinedLabels = new LinkedHashMap<NodeRef<RowPattern>, Set<String>>();
    private final Map<NodeRef<Identifier>, String> resolvedLabels = new LinkedHashMap<NodeRef<Identifier>, String>();
    private final Map<NodeRef<SubsetDefinition>, Set<String>> subsets = new LinkedHashMap<NodeRef<SubsetDefinition>, Set<String>>();
    private final Map<NodeRef<Expression>, List<PatternRecognitionAnalysis.PatternFunctionAnalysis>> patternRecognitionInputs = new LinkedHashMap<NodeRef<Expression>, List<PatternRecognitionAnalysis.PatternFunctionAnalysis>>();
    private final Set<NodeRef<FunctionCall>> patternNavigationFunctions = new LinkedHashSet<NodeRef<FunctionCall>>();
    private final MPPQueryContext context;
    private final SessionInfo session;
    private final Map<NodeRef<Parameter>, Expression> parameters;
    private final WarningCollector warningCollector;
    private final Function<Expression, Type> getPreanalyzedType;
    private final List<Field> sourceFields = new ArrayList<Field>();
    private final Map<NodeRef<DereferenceExpression>, LabelPrefixedReference> labelDereferences = new LinkedHashMap<NodeRef<DereferenceExpression>, LabelPrefixedReference>();
    private final Function<Node, Analysis.ResolvedWindow> getResolvedWindow;
    private static final String SUBQUERY_COLUMN_NUM_CHECK = "Subquery must return only one column for now. Row Type is not supported for now.";

    private ExpressionAnalyzer(Metadata metadata, MPPQueryContext context, AccessControl accessControl, StatementAnalyzerFactory statementAnalyzerFactory, Analysis analysis, SessionInfo session, TypeProvider types, WarningCollector warningCollector) {
        this(metadata, context, accessControl, (node, correlationSupport) -> statementAnalyzerFactory.createStatementAnalyzer(analysis, context, session, warningCollector, (CorrelationSupport)((Object)correlationSupport)), session, types, analysis.getParameters(), warningCollector, analysis::getType, analysis::getWindow);
    }

    ExpressionAnalyzer(Metadata metadata, MPPQueryContext context, AccessControl accessControl, BiFunction<Node, CorrelationSupport, StatementAnalyzer> statementAnalyzerFactory, SessionInfo session, TypeProvider symbolTypes, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector, Function<Expression, Type> getPreanalyzedType, Function<Node, Analysis.ResolvedWindow> getResolvedWindow) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.context = Objects.requireNonNull(context, "context is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.statementAnalyzerFactory = Objects.requireNonNull(statementAnalyzerFactory, "statementAnalyzerFactory is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.symbolTypes = Objects.requireNonNull(symbolTypes, "symbolTypes is null");
        this.parameters = Objects.requireNonNull(parameters, "parameters is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.getResolvedWindow = Objects.requireNonNull(getResolvedWindow, "getResolvedWindow is null");
        this.getPreanalyzedType = Objects.requireNonNull(getPreanalyzedType, "getPreanalyzedType is null");
    }

    public static ExpressionAnalysis analyzeWindow(Metadata metadata, SessionInfo session, MPPQueryContext queryContext, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, Scope scope, Analysis analysis, WarningCollector noop, CorrelationSupport correlationSupport, Analysis.ResolvedWindow window, Node originalNode) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(metadata, queryContext, accessControl, statementAnalyzerFactory, analysis, session, TypeProvider.empty(), noop);
        analyzer.analyzeWindow(window, scope, originalNode, correlationSupport);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions());
    }

    private void analyzeWindow(Analysis.ResolvedWindow window, Scope scope, Node originalNode, CorrelationSupport correlationSupport) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        visitor.analyzeWindow(window, new StackableAstVisitor.StackableAstVisitorContext<Context>(Context.notInLambda(scope, correlationSupport)), originalNode);
    }

    public Map<NodeRef<Node>, ResolvedFunction> getResolvedFunctions() {
        return Collections.unmodifiableMap(this.resolvedFunctions);
    }

    public Map<NodeRef<Expression>, Type> getExpressionTypes() {
        return Collections.unmodifiableMap(this.expressionTypes);
    }

    public Type setExpressionType(Expression expression, Type type) {
        Objects.requireNonNull(expression, "expression cannot be null");
        Objects.requireNonNull(type, "type cannot be null");
        this.expressionTypes.put(NodeRef.of(expression), type);
        return type;
    }

    public Set<NodeRef<FunctionCall>> getWindowFunctions() {
        return Collections.unmodifiableSet(this.windowFunctions);
    }

    private Type getExpressionType(Expression expression) {
        Objects.requireNonNull(expression, "expression cannot be null");
        Type type = this.expressionTypes.get(NodeRef.of(expression));
        Preconditions.checkState((type != null ? 1 : 0) != 0, (String)"Expression not yet analyzed: %s", (Object)expression);
        return type;
    }

    public Set<NodeRef<InPredicate>> getSubqueryInPredicates() {
        return Collections.unmodifiableSet(this.subqueryInPredicates);
    }

    public Map<NodeRef<Expression>, Analysis.PredicateCoercions> getPredicateCoercions() {
        return Collections.unmodifiableMap(this.predicateCoercions);
    }

    public Map<NodeRef<Expression>, ResolvedField> getColumnReferences() {
        return Collections.unmodifiableMap(this.columnReferences);
    }

    public Type analyze(Expression expression, Scope scope) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        return visitor.process((Node)expression, new StackableAstVisitor.StackableAstVisitorContext<Context>(Context.notInLambda(scope, CorrelationSupport.ALLOWED)));
    }

    public Type analyze(Expression expression, Scope scope, CorrelationSupport correlationSupport) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        return visitor.process((Node)expression, new StackableAstVisitor.StackableAstVisitorContext<Context>(Context.notInLambda(scope, correlationSupport)));
    }

    private Type analyze(Expression expression, Scope scope, Set<String> labels) {
        Visitor visitor = new Visitor(scope, this.warningCollector);
        this.patternRecognitionInputs.put(NodeRef.of(expression), visitor.getPatternRecognitionInputs());
        return visitor.process((Node)expression, new StackableAstVisitor.StackableAstVisitorContext<Context>(Context.patternRecognition(scope, labels)));
    }

    private Type analyze(Expression expression, Scope baseScope, Context context) {
        Visitor visitor = new Visitor(baseScope, this.warningCollector);
        return visitor.process((Node)expression, new StackableAstVisitor.StackableAstVisitorContext<Context>(context));
    }

    public Set<NodeRef<SubqueryExpression>> getSubqueries() {
        return Collections.unmodifiableSet(this.subqueries);
    }

    public Set<NodeRef<ExistsPredicate>> getExistsSubqueries() {
        return Collections.unmodifiableSet(this.existsSubqueries);
    }

    public Set<NodeRef<QuantifiedComparisonExpression>> getQuantifiedComparisons() {
        return Collections.unmodifiableSet(this.quantifiedComparisons);
    }

    public Multimap<QualifiedObjectName, String> getTableColumnReferences() {
        return this.tableColumnReferences;
    }

    public List<Field> getSourceFields() {
        return this.sourceFields;
    }

    public Map<NodeRef<Expression>, Optional<String>> getLabels() {
        return this.labels;
    }

    public Map<NodeRef<RangeQuantifier>, Analysis.Range> getRanges() {
        return this.ranges;
    }

    public Map<NodeRef<RowPattern>, Set<String>> getUndefinedLabels() {
        return this.undefinedLabels;
    }

    public Map<NodeRef<Identifier>, String> getResolvedLabels() {
        return this.resolvedLabels;
    }

    public Map<NodeRef<SubsetDefinition>, Set<String>> getSubsetLabels() {
        return this.subsets;
    }

    public Map<NodeRef<Expression>, List<PatternRecognitionAnalysis.PatternFunctionAnalysis>> getPatternRecognitionInputs() {
        return this.patternRecognitionInputs;
    }

    public Set<NodeRef<FunctionCall>> getPatternNavigationFunctions() {
        return this.patternNavigationFunctions;
    }

    public static boolean isPatternRecognitionFunction(FunctionCall node) {
        QualifiedName qualifiedName = node.getName();
        if (qualifiedName.getParts().size() > 1) {
            throw new SemanticException("Pattern recognition function name must not be qualified: " + qualifiedName);
        }
        Identifier identifier = qualifiedName.getOriginalParts().get(0);
        if (identifier.isDelimited()) {
            throw new SemanticException("Pattern recognition function name must not be delimited: " + identifier.getValue());
        }
        String name = identifier.getValue().toUpperCase(Locale.ENGLISH);
        if (name.equals("LAST") || name.equals("FIRST")) {
            throw new SemanticException("Pattern recognition function names cannot be LAST or FIRST, use RPR_LAST or RPR_FIRST instead.");
        }
        if (!(name.equals("RPR_FIRST") || name.equals("RPR_LAST") || name.equals("PREV") || name.equals("NEXT") || name.equals("CLASSIFIER") || name.equals("MATCH_NUMBER"))) {
            throw new SemanticException("Unknown pattern recognition function: " + name);
        }
        return true;
    }

    public static ExpressionAnalysis analyzePatternRecognitionExpression(Metadata metadata, MPPQueryContext context, SessionInfo session, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, Scope scope, Analysis analysis, Expression expression, WarningCollector warningCollector, Set<String> labels) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(metadata, context, accessControl, statementAnalyzerFactory, analysis, session, TypeProvider.empty(), warningCollector);
        analyzer.analyze(expression, scope, labels);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions());
    }

    public static ExpressionAnalysis analyzeExpressions(Metadata metadata, MPPQueryContext context, SessionInfo session, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, TypeProvider types, Iterable<Expression> expressions, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector) {
        Analysis analysis = new Analysis(null, parameters);
        analysis.setDatabaseName(session.getDatabaseName().get());
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(metadata, context, accessControl, statementAnalyzerFactory, analysis, session, types, warningCollector);
        for (Expression expression : expressions) {
            analyzer.analyze(expression, Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(new Field[0])).build());
        }
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions());
    }

    public static ExpressionAnalysis analyzeExpression(Metadata metadata, MPPQueryContext context, SessionInfo session, StatementAnalyzerFactory statementAnalyzerFactory, AccessControl accessControl, Scope scope, Analysis analysis, Expression expression, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(metadata, context, accessControl, statementAnalyzerFactory, analysis, session, TypeProvider.empty(), warningCollector);
        analyzer.analyze(expression, scope, correlationSupport);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        analysis.addExpressionFields(expression, analyzer.getSourceFields());
        return new ExpressionAnalysis(analyzer.getExpressionTypes(), analyzer.getSubqueryInPredicates(), analyzer.getSubqueries(), analyzer.getExistsSubqueries(), analyzer.getColumnReferences(), analyzer.getQuantifiedComparisons(), analyzer.getWindowFunctions());
    }

    public static void analyzeExpressionWithoutSubqueries(Metadata metadata, MPPQueryContext context, SessionInfo session, AccessControl accessControl, Scope scope, Analysis analysis, Expression expression, String message, WarningCollector warningCollector, CorrelationSupport correlationSupport) {
        ExpressionAnalyzer analyzer = new ExpressionAnalyzer(metadata, context, accessControl, (node, ignored) -> {
            throw new SemanticException(message);
        }, session, TypeProvider.empty(), analysis.getParameters(), warningCollector, analysis::getType, analysis::getWindow);
        analyzer.analyze(expression, scope, correlationSupport);
        ExpressionAnalyzer.updateAnalysis(analysis, analyzer, session, accessControl);
        analysis.addExpressionFields(expression, analyzer.getSourceFields());
    }

    private static void updateAnalysis(Analysis analysis, ExpressionAnalyzer analyzer, SessionInfo session, AccessControl accessControl) {
        analysis.addTypes(analyzer.getExpressionTypes());
        analyzer.getResolvedFunctions().forEach((key, value) -> analysis.addResolvedFunction((Node)key.getNode(), (ResolvedFunction)value, session.getUserName()));
        analysis.addColumnReferences(analyzer.getColumnReferences());
        analysis.addTableColumnReferences(accessControl, session.getIdentity(), analyzer.getTableColumnReferences());
        analysis.addPredicateCoercions(analyzer.getPredicateCoercions());
        analysis.addLabels(analyzer.getLabels());
        analysis.setRanges(analyzer.getRanges());
        analysis.setUndefinedLabels(analyzer.getUndefinedLabels());
        analysis.addResolvedLabels(analyzer.getResolvedLabels());
        analysis.addSubsetLabels(analyzer.getSubsetLabels());
        analysis.addPatternRecognitionInputs(analyzer.getPatternRecognitionInputs());
        analysis.addPatternNavigationFunctions(analyzer.getPatternNavigationFunctions());
    }

    public static ExpressionAnalyzer createConstantAnalyzer(Metadata metadata, MPPQueryContext context, AccessControl accessControl, SessionInfo session, Map<NodeRef<Parameter>, Expression> parameters, WarningCollector warningCollector) {
        return ExpressionAnalyzer.createWithoutSubqueries(metadata, context, accessControl, session, parameters, "Constant expression cannot contain a subquery", warningCollector);
    }

    public static ExpressionAnalyzer createWithoutSubqueries(Metadata metadata, MPPQueryContext context, AccessControl accessControl, SessionInfo session, Map<NodeRef<Parameter>, Expression> parameters, String message, WarningCollector warningCollector) {
        return ExpressionAnalyzer.createWithoutSubqueries(metadata, context, accessControl, session, TypeProvider.empty(), parameters, node -> new SemanticException(message), warningCollector);
    }

    public static ExpressionAnalyzer createWithoutSubqueries(Metadata metadata, MPPQueryContext context, AccessControl accessControl, SessionInfo session, TypeProvider symbolTypes, Map<NodeRef<Parameter>, Expression> parameters, Function<Node, ? extends RuntimeException> statementAnalyzerRejection, WarningCollector warningCollector) {
        return new ExpressionAnalyzer(metadata, context, accessControl, (node, correlationSupport) -> {
            throw (RuntimeException)statementAnalyzerRejection.apply((Node)node);
        }, session, symbolTypes, parameters, warningCollector, expression -> {
            throw new IllegalStateException("Cannot access preanalyzed types");
        }, functionCall -> {
            throw new IllegalStateException("Cannot access resolved windows");
        });
    }

    private static boolean isExactNumericWithScaleZero(Type type) {
        return type.equals(IntType.INT32) || type.equals(LongType.INT64);
    }

    private class Visitor
    extends StackableAstVisitor<Type, Context> {
        private final Scope baseScope;
        private final WarningCollector warningCollector;
        private final List<PatternRecognitionAnalysis.PatternFunctionAnalysis> patternRecognitionInputs = new ArrayList<PatternRecognitionAnalysis.PatternFunctionAnalysis>();

        public Visitor(Scope baseScope, WarningCollector warningCollector) {
            this.baseScope = Objects.requireNonNull(baseScope, "baseScope is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        public List<PatternRecognitionAnalysis.PatternFunctionAnalysis> getPatternRecognitionInputs() {
            return this.patternRecognitionInputs;
        }

        @Override
        public Type process(Node node, @Nullable StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type;
            if (node instanceof Expression && (type = (Type)ExpressionAnalyzer.this.expressionTypes.get(NodeRef.of((Expression)node))) != null) {
                return type;
            }
            return (Type)super.process(node, context);
        }

        @Override
        protected Type visitRow(Row node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            List types = (List)node.getItems().stream().map(child -> this.process((Node)child, context)).collect(ImmutableList.toImmutableList());
            RowType type = RowType.anonymous((List)types);
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)type);
        }

        @Override
        protected Type visitCurrentTime(CurrentTime node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (Objects.requireNonNull(node.getFunction()) == CurrentTime.Function.TIMESTAMP) {
                return ExpressionAnalyzer.this.setExpressionType(node, (Type)LongType.INT64);
            }
            throw new UnsupportedOperationException(node.toString());
        }

        @Override
        protected Type visitSymbolReference(SymbolReference node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = ExpressionAnalyzer.this.symbolTypes.getTableModelType(Symbol.from(node));
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        @Override
        protected Type visitIdentifier(Identifier node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ResolvedField resolvedField = context.getContext().getScope().resolveField(node, QualifiedName.of(node.getValue()));
            if (context.getContext().isPatternRecognition()) {
                ExpressionAnalyzer.this.labels.put(NodeRef.of(node), Optional.empty());
                this.patternRecognitionInputs.add(new PatternRecognitionAnalysis.PatternFunctionAnalysis(node, new PatternRecognitionAnalysis.ScalarInputDescriptor(Optional.empty(), context.getContext().getPatternRecognitionContext().getNavigation())));
            }
            return this.handleResolvedField(node, resolvedField, context);
        }

        private Type handleResolvedField(Expression node, ResolvedField resolvedField, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (!resolvedField.isLocal() && context.getContext().getCorrelationSupport() != CorrelationSupport.ALLOWED) {
                throw new SemanticException(String.format("Reference to column '%s' from outer scope not allowed in this context", node));
            }
            FieldId fieldId = FieldId.from(resolvedField);
            Field field = resolvedField.getField();
            if (field.getOriginTable().isPresent() && field.getOriginColumnName().isPresent()) {
                ExpressionAnalyzer.this.tableColumnReferences.put((Object)field.getOriginTable().get(), (Object)field.getOriginColumnName().get());
            }
            ExpressionAnalyzer.this.sourceFields.add(field);
            fieldId.getRelationId().getSourceNode().ifPresent(source -> ExpressionAnalyzer.this.referencedFields.put(NodeRef.of(source), (Object)field));
            ResolvedField previous = ExpressionAnalyzer.this.columnReferences.put(NodeRef.of(node), resolvedField);
            Preconditions.checkState((previous == null ? 1 : 0) != 0, (String)"%s already known to refer to %s", (Object)node, (Object)previous);
            return ExpressionAnalyzer.this.setExpressionType(node, field.getType());
        }

        @Override
        protected Type visitDereferenceExpression(DereferenceExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type baseType;
            if (DereferenceExpression.isQualifiedAllFieldsReference(node)) {
                throw new SemanticException("<identifier>.* not allowed in this context");
            }
            QualifiedName qualifiedName = DereferenceExpression.getQualifiedName(node);
            if (qualifiedName != null) {
                if (context.getContext().isPatternRecognition()) {
                    String label = this.label(qualifiedName.getOriginalParts().get(0));
                    if (context.getContext().getPatternRecognitionContext().getLabels().contains(label)) {
                        QualifiedName unlabeledName = QualifiedName.of(qualifiedName.getOriginalParts().subList(1, qualifiedName.getOriginalParts().size()));
                        if (qualifiedName.getOriginalParts().size() > 2) {
                            throw new SemanticException(String.format("Column %s prefixed with label %s cannot be resolved", unlabeledName, label));
                        }
                        Optional<ResolvedField> resolvedField = context.getContext().getScope().tryResolveField(node, unlabeledName);
                        if (!resolvedField.isPresent()) {
                            throw new SemanticException(String.format("Column %s prefixed with label %s cannot be resolved", unlabeledName, label));
                        }
                        ExpressionAnalyzer.this.labels.put(NodeRef.of(node), Optional.of(label));
                        this.patternRecognitionInputs.add(new PatternRecognitionAnalysis.PatternFunctionAnalysis(node, new PatternRecognitionAnalysis.ScalarInputDescriptor(Optional.of(label), context.getContext().getPatternRecognitionContext().getNavigation())));
                        return this.handleResolvedField(node, resolvedField.get(), context);
                    }
                    throw new SemanticException(String.format("Column '%s' cannot be resolved", qualifiedName));
                }
                Scope scope = context.getContext().getScope();
                Optional<ResolvedField> resolvedField = scope.tryResolveField(node, qualifiedName);
                if (resolvedField.isPresent()) {
                    return this.handleResolvedField(node, resolvedField.get(), context);
                }
                if (!scope.isColumnReference(qualifiedName)) {
                    TableMetadataImpl.throwColumnNotExistsException(qualifiedName);
                }
            }
            if (!((baseType = this.process((Node)node.getBase(), context)) instanceof RowType)) {
                throw new SemanticException(String.format("Expression %s is not of type ROW", node.getBase()));
            }
            RowType rowType = (RowType)baseType;
            Identifier field = node.getField().orElseThrow(() -> new NoSuchElementException("No value present"));
            String fieldName = field.getValue();
            boolean foundFieldName = false;
            Type rowFieldType = null;
            for (RowType.Field rowField : rowType.getFields()) {
                if (!fieldName.equalsIgnoreCase(rowField.getName().orElse(null))) continue;
                if (foundFieldName) {
                    throw new SemanticException(String.format("Ambiguous row field reference: %s", fieldName));
                }
                foundFieldName = true;
                rowFieldType = rowField.getType();
            }
            if (rowFieldType == null) {
                TableMetadataImpl.throwColumnNotExistsException(qualifiedName);
            }
            return ExpressionAnalyzer.this.setExpressionType(node, rowFieldType);
        }

        @Override
        protected Type visitNotExpression(NotExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceType(context, node.getValue(), (Type)BooleanType.BOOLEAN, "Value of logical NOT expression");
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitLogicalExpression(LogicalExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            for (Expression term : node.getTerms()) {
                this.coerceType(context, term, (Type)BooleanType.BOOLEAN, "Logical expression term");
            }
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitComparisonExpression(ComparisonExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            OperatorType operatorType = null;
            switch (node.getOperator()) {
                case EQUAL: 
                case NOT_EQUAL: {
                    operatorType = OperatorType.EQUAL;
                    break;
                }
                case LESS_THAN: 
                case GREATER_THAN: {
                    operatorType = OperatorType.LESS_THAN;
                    break;
                }
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN_OR_EQUAL: {
                    operatorType = OperatorType.LESS_THAN_OR_EQUAL;
                    break;
                }
                case IS_DISTINCT_FROM: {
                    operatorType = OperatorType.IS_DISTINCT_FROM;
                }
            }
            return this.getOperator(context, node, operatorType, node.getLeft(), node.getRight());
        }

        @Override
        protected Type visitIsNullPredicate(IsNullPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.process((Node)node.getValue(), context);
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitIsNotNullPredicate(IsNotNullPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.process((Node)node.getValue(), context);
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitNullIfExpression(NullIfExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type secondType;
            Type firstType = this.process((Node)node.getFirst(), context);
            if (!firstType.equals(secondType = this.process((Node)node.getSecond(), context))) {
                throw new SemanticException(String.format("Types are not comparable with NULLIF: %s vs %s", firstType, secondType));
            }
            return ExpressionAnalyzer.this.setExpressionType(node, firstType);
        }

        @Override
        protected Type visitIfExpression(IfExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceType(context, node.getCondition(), (Type)BooleanType.BOOLEAN, "IF condition");
            Type type = node.getFalseValue().isPresent() ? this.coerceToSingleType(context, node, "Result types for IF must be the same", node.getTrueValue(), node.getFalseValue().get()) : this.process((Node)node.getTrueValue(), context);
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        @Override
        protected Type visitSearchedCaseExpression(SearchedCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            for (WhenClause whenClause : node.getWhenClauses()) {
                this.coerceType(context, whenClause.getOperand(), (Type)BooleanType.BOOLEAN, "CASE WHEN clause");
            }
            Type type = this.coerceToSingleType(context, "All CASE results", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.setExpressionType(node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                ExpressionAnalyzer.this.setExpressionType(whenClause, whenClauseType);
            }
            return type;
        }

        @Override
        protected Type visitSimpleCaseExpression(SimpleCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            this.coerceCaseOperandToToSingleType(node, context);
            Type type = this.coerceToSingleType(context, "All CASE results", this.getCaseResultExpressions(node.getWhenClauses(), node.getDefaultValue()));
            ExpressionAnalyzer.this.setExpressionType(node, type);
            for (WhenClause whenClause : node.getWhenClauses()) {
                Type whenClauseType = this.process((Node)whenClause.getResult(), context);
                ExpressionAnalyzer.this.setExpressionType(whenClause, whenClauseType);
            }
            return type;
        }

        private void coerceCaseOperandToToSingleType(SimpleCaseExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type operandType = this.process((Node)node.getOperand(), context);
            List<WhenClause> whenClauses = node.getWhenClauses();
            ArrayList<Type> whenOperandTypes = new ArrayList<Type>(whenClauses.size());
            for (WhenClause whenClause : whenClauses) {
                Expression whenOperand = whenClause.getOperand();
                Type whenOperandType = this.process((Node)whenOperand, context);
                whenOperandTypes.add(whenOperandType);
                if (operandType.equals(whenOperandType)) continue;
                throw new SemanticException(String.format("CASE operand type does not match WHEN clause operand type: %s vs %s", operandType, whenOperandType));
            }
            for (int i = 0; i < whenOperandTypes.size(); ++i) {
                Type whenOperandType = (Type)whenOperandTypes.get(i);
                if (whenOperandType.equals(operandType)) continue;
                throw new SemanticException(String.format("CASE operand type does not match WHEN clause operand type: %s vs %s", operandType, whenOperandType));
            }
        }

        private List<Expression> getCaseResultExpressions(List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
            ArrayList<Expression> resultExpressions = new ArrayList<Expression>();
            for (WhenClause whenClause : whenClauses) {
                resultExpressions.add(whenClause.getResult());
            }
            defaultValue.ifPresent(resultExpressions::add);
            return resultExpressions;
        }

        @Override
        protected Type visitCoalesceExpression(CoalesceExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.coerceToSingleType(context, "All COALESCE operands", node.getOperands());
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        @Override
        protected Type visitArithmeticUnary(ArithmeticUnaryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            switch (node.getSign()) {
                case PLUS: {
                    Type type = this.process((Node)node.getValue(), context);
                    if (!TableMetadataImpl.isNumericType(type)) {
                        throw new SemanticException(String.format("Unary '+' operator cannot by applied to %s type", type));
                    }
                    return ExpressionAnalyzer.this.setExpressionType(node, type);
                }
                case MINUS: {
                    return this.getOperator(context, node, OperatorType.NEGATION, node.getValue());
                }
            }
            throw new IllegalArgumentException("Unknown sign: " + (Object)((Object)node.getSign()));
        }

        @Override
        protected Type visitArithmeticBinary(ArithmeticBinaryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return this.getOperator(context, node, OperatorType.valueOf(node.getOperator().name()), node.getLeft(), node.getRight());
        }

        @Override
        protected Type visitLikePredicate(LikePredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Expression escape;
            Type escapeType;
            Type valueType = this.process((Node)node.getValue(), context);
            if (!TableMetadataImpl.isCharType(valueType)) {
                throw new SemanticException(String.format("Left side of LIKE expression must evaluate to TEXT or STRING Type (actual: %s)", valueType));
            }
            Type patternType = this.process((Node)node.getPattern(), context);
            if (!TableMetadataImpl.isCharType(patternType)) {
                throw new SemanticException(String.format("Pattern for LIKE expression must evaluate to TEXT or STRING Type (actual: %s)", patternType));
            }
            if (node.getEscape().isPresent() && !TableMetadataImpl.isCharType(escapeType = this.process((Node)(escape = node.getEscape().get()), context))) {
                throw new SemanticException(String.format("Escape for LIKE expression must evaluate to TEXT or STRING Type (actual: %s)", escapeType));
            }
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitStringLiteral(StringLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)StringType.STRING);
        }

        @Override
        protected Type visitBinaryLiteral(BinaryLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BlobType.BLOB);
        }

        @Override
        protected Type visitLongLiteral(LongLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (node.getParsedValue() >= Integer.MIN_VALUE && node.getParsedValue() <= Integer.MAX_VALUE) {
                return ExpressionAnalyzer.this.setExpressionType(node, (Type)IntType.INT32);
            }
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)LongType.INT64);
        }

        @Override
        protected Type visitDoubleLiteral(DoubleLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)DoubleType.DOUBLE);
        }

        @Override
        protected Type visitDecimalLiteral(DecimalLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            throw new SemanticException("DecimalLiteral is not supported yet.");
        }

        @Override
        protected Type visitBooleanLiteral(BooleanLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitGenericLiteral(GenericLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            throw new SemanticException("GenericLiteral is not supported yet.");
        }

        @Override
        protected Type visitNullLiteral(NullLiteral node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)UnknownType.UNKNOWN);
        }

        @Override
        protected Type visitFunctionCall(FunctionCall node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            String functionName = node.getName().getSuffix();
            boolean isAggregation = ExpressionAnalyzer.this.metadata.isAggregationFunction(ExpressionAnalyzer.this.session, functionName, ExpressionAnalyzer.this.accessControl);
            boolean isRowPatternCount = context.getContext().isPatternRecognition() && isAggregation && node.getName().getSuffix().equalsIgnoreCase("count");
            node.getArguments().stream().filter(DereferenceExpression::isQualifiedAllFieldsReference).findAny().ifPresent(allRowsReference -> {
                if (!isRowPatternCount || node.getArguments().size() > 1) {
                    throw new SemanticException("label.* syntax is only supported as the only argument of row pattern count function");
                }
            });
            if (node.getWindow().isPresent()) {
                Analysis.ResolvedWindow window = (Analysis.ResolvedWindow)ExpressionAnalyzer.this.getResolvedWindow.apply(node);
                Preconditions.checkState((window != null ? 1 : 0) != 0, (Object)("no resolved window for: " + node));
                this.analyzeWindow(window, context, (Node)((Object)node.getWindow().get()));
                ExpressionAnalyzer.this.windowFunctions.add(NodeRef.of(node));
            } else if (node.isDistinct() && !isAggregation) {
                throw new SemanticException("DISTINCT is not supported for non-aggregation functions");
            }
            if (context.getContext().isPatternRecognition()) {
                if (isAggregation) {
                    if (node.isDistinct()) {
                        throw new SemanticException("Cannot use DISTINCT with aggregate function in pattern recognition context");
                    }
                } else if (ExpressionAnalyzer.isPatternRecognitionFunction(node)) {
                    String name;
                    this.validatePatternRecognitionFunction(node);
                    switch (name = node.getName().getSuffix().toUpperCase(Locale.ENGLISH)) {
                        case "MATCH_NUMBER": {
                            return ExpressionAnalyzer.this.setExpressionType(node, this.analyzeMatchNumber(node, context));
                        }
                        case "CLASSIFIER": {
                            return ExpressionAnalyzer.this.setExpressionType(node, this.analyzeClassifier(node, context));
                        }
                        case "RPR_FIRST": 
                        case "RPR_LAST": {
                            return ExpressionAnalyzer.this.setExpressionType(node, this.analyzeLogicalNavigation(node, context, name));
                        }
                        case "PREV": 
                        case "NEXT": {
                            return ExpressionAnalyzer.this.setExpressionType(node, this.analyzePhysicalNavigation(node, context, name));
                        }
                    }
                    throw new SemanticException("unexpected pattern recognition function " + name);
                }
            }
            if (node.getProcessingMode().isPresent()) {
                ProcessingMode processingMode = node.getProcessingMode().get();
                if (!context.getContext().isPatternRecognition()) {
                    throw new SemanticException(String.format("%s semantics is not supported out of pattern recognition context", new Object[]{processingMode.getMode()}));
                }
                if (!isAggregation) {
                    throw new SemanticException(String.format("%s semantics is supported only for FIRST(), LAST() and aggregation functions. Actual: %s", new Object[]{processingMode.getMode(), node.getName()}));
                }
            }
            if (node.isDistinct() && !isAggregation) {
                throw new SemanticException("DISTINCT is not supported for non-aggregation functions");
            }
            List<Type> argumentTypes = this.getCallArgumentTypes(node.getArguments(), context);
            if (node.getArguments().size() > 127) {
                throw new SemanticException(String.format("Too many arguments for function call %s()", functionName));
            }
            for (Type argumentType : argumentTypes) {
                if (!node.isDistinct() || argumentType.isComparable()) continue;
                throw new SemanticException(String.format("DISTINCT can only be applied to comparable types (actual: %s)", argumentType));
            }
            Type type = ExpressionAnalyzer.this.metadata.getFunctionReturnType(functionName, argumentTypes);
            FunctionKind functionKind = FunctionKind.SCALAR;
            if (isAggregation) {
                functionKind = FunctionKind.AGGREGATE;
            } else {
                boolean isWindow = ExpressionAnalyzer.this.metadata.isWindowFunction(ExpressionAnalyzer.this.session, functionName, ExpressionAnalyzer.this.accessControl);
                if (isWindow) {
                    functionKind = FunctionKind.WINDOW;
                }
            }
            FunctionNullability functionNullability = null;
            switch (functionKind) {
                case AGGREGATE: {
                    functionNullability = FunctionNullability.getAggregationFunctionNullability(argumentTypes.size());
                    break;
                }
                case SCALAR: {
                    functionNullability = FunctionNullability.getScalarFunctionNullability(argumentTypes.size());
                    break;
                }
                case WINDOW: {
                    functionNullability = FunctionNullability.getWindowFunctionNullability(argumentTypes.size());
                }
            }
            ResolvedFunction resolvedFunction = new ResolvedFunction(new BoundSignature(functionName.toLowerCase(Locale.ENGLISH), type, argumentTypes), FunctionId.NOOP_FUNCTION_ID, functionKind, true, functionNullability);
            ExpressionAnalyzer.this.resolvedFunctions.put(NodeRef.of(node), resolvedFunction);
            if (context.getContext().isPatternRecognition() && isAggregation) {
                this.analyzePatternAggregation(node, resolvedFunction);
            }
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        public List<Type> getCallArgumentTypes(List<Expression> arguments, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ImmutableList.Builder argumentTypesBuilder = ImmutableList.builder();
            for (Expression argument : arguments) {
                if (DereferenceExpression.isQualifiedAllFieldsReference(argument)) {
                    DereferenceExpression allRowsDereference = (DereferenceExpression)argument;
                    String label = this.label((Identifier)allRowsDereference.getBase());
                    if (!context.getContext().getPatternRecognitionContext().getLabels().contains(label)) {
                        throw new SemanticException(String.format("%s is not a primary pattern variable or subset name", label));
                    }
                    ExpressionAnalyzer.this.labelDereferences.put(NodeRef.of(allRowsDereference), new LabelPrefixedReference(label));
                    continue;
                }
                argumentTypesBuilder.add((Object)this.process((Node)argument, context));
            }
            return argumentTypesBuilder.build();
        }

        private Type analyzeMatchNumber(FunctionCall node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (!node.getArguments().isEmpty()) {
                throw new SemanticException("MATCH_NUMBER pattern recognition function takes no arguments");
            }
            this.patternRecognitionInputs.add(new PatternRecognitionAnalysis.PatternFunctionAnalysis(node, new PatternRecognitionAnalysis.MatchNumberDescriptor()));
            return LongType.INT64;
        }

        private Type analyzeClassifier(FunctionCall node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (node.getArguments().size() > 1) {
                throw new SemanticException("CLASSIFIER pattern recognition function takes no arguments or 1 argument");
            }
            Optional<String> label = Optional.empty();
            if (node.getArguments().size() == 1) {
                Node argument = node.getArguments().get(0);
                if (!(argument instanceof Identifier)) {
                    throw new SemanticException(String.format("CLASSIFIER function argument should be primary pattern variable or subset name. Actual: %s", argument.getClass().getSimpleName()));
                }
                Identifier identifier = (Identifier)argument;
                label = Optional.of(this.label(identifier));
                if (!context.getContext().getPatternRecognitionContext().getLabels().contains(label.get())) {
                    throw new SemanticException(String.format("%s is not a primary pattern variable or subset name", identifier.getValue()));
                }
            }
            this.patternRecognitionInputs.add(new PatternRecognitionAnalysis.PatternFunctionAnalysis(node, new PatternRecognitionAnalysis.ClassifierDescriptor(label, context.getContext().getPatternRecognitionContext().getNavigation())));
            return StringType.STRING;
        }

        private Type analyzePhysicalNavigation(FunctionCall node, StackableAstVisitor.StackableAstVisitorContext<Context> context, String name) {
            this.validateNavigationFunctionArguments(node);
            this.checkNoNestedAggregations(node);
            this.validateNavigationNesting(node);
            int offset = this.getNavigationOffset(node, 1);
            if (name.equals("PREV")) {
                offset = -offset;
            }
            PatternRecognitionAnalysis.Navigation navigation = context.getContext().getPatternRecognitionContext().getNavigation();
            Type type = this.process((Node)node.getArguments().get(0), new StackableAstVisitor.StackableAstVisitorContext<Context>(context.getContext().withNavigation(new PatternRecognitionAnalysis.Navigation(navigation.getAnchor(), navigation.getMode(), navigation.getLogicalOffset(), offset))));
            ExpressionAnalyzer.this.patternNavigationFunctions.add(NodeRef.of(node));
            return type;
        }

        private Type analyzeLogicalNavigation(FunctionCall node, StackableAstVisitor.StackableAstVisitorContext<Context> context, String name) {
            PatternRecognitionAnalysis.NavigationAnchor anchor;
            this.validateNavigationFunctionArguments(node);
            this.checkNoNestedAggregations(node);
            this.validateNavigationNesting(node);
            switch (name) {
                case "RPR_FIRST": {
                    anchor = PatternRecognitionAnalysis.NavigationAnchor.FIRST;
                    break;
                }
                case "RPR_LAST": {
                    anchor = PatternRecognitionAnalysis.NavigationAnchor.LAST;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected navigation anchor: " + name);
                }
            }
            Type type = this.process((Node)node.getArguments().get(0), new StackableAstVisitor.StackableAstVisitorContext<Context>(context.getContext().withNavigation(new PatternRecognitionAnalysis.Navigation(anchor, this.mapProcessingMode(node.getProcessingMode()), this.getNavigationOffset(node, 0), context.getContext().getPatternRecognitionContext().getNavigation().getPhysicalOffset()))));
            ExpressionAnalyzer.this.patternNavigationFunctions.add(NodeRef.of(node));
            return type;
        }

        private PatternRecognitionAnalysis.NavigationMode mapProcessingMode(Optional<ProcessingMode> processingMode) {
            if (processingMode.isPresent()) {
                ProcessingMode mode = processingMode.get();
                switch (mode.getMode()) {
                    case FINAL: {
                        return PatternRecognitionAnalysis.NavigationMode.FINAL;
                    }
                    case RUNNING: {
                        return PatternRecognitionAnalysis.NavigationMode.RUNNING;
                    }
                }
                throw new IllegalArgumentException("Unexpected mode: " + (Object)((Object)mode.getMode()));
            }
            return PatternRecognitionAnalysis.NavigationMode.RUNNING;
        }

        private int getNavigationOffset(FunctionCall node, int defaultOffset) {
            int offset = defaultOffset;
            if (node.getArguments().size() == 2) {
                offset = (int)((LongLiteral)node.getArguments().get(1)).getParsedValue();
            }
            return offset;
        }

        private void validatePatternRecognitionFunction(FunctionCall node) {
            if (node.isDistinct()) {
                throw new SemanticException(String.format("Cannot use DISTINCT with %s pattern recognition function", node.getName()));
            }
            String name = node.getName().getSuffix();
            if (node.getProcessingMode().isPresent()) {
                ProcessingMode processingMode = node.getProcessingMode().get();
                if (!name.equalsIgnoreCase("RPR_FIRST") && !name.equalsIgnoreCase("RPR_LAST")) {
                    throw new SemanticException(String.format("%s semantics is not supported with %s pattern recognition function", new Object[]{processingMode.getMode(), node.getName()}));
                }
            }
        }

        private void validateNavigationFunctionArguments(FunctionCall node) {
            if (node.getArguments().size() != 1 && node.getArguments().size() != 2) {
                throw new SemanticException(String.format("%s pattern recognition function requires 1 or 2 arguments", node.getName()));
            }
            if (node.getArguments().size() == 2) {
                if (!(node.getArguments().get(1) instanceof LongLiteral)) {
                    throw new SemanticException(String.format("%s pattern recognition navigation function requires a number as the second argument", node.getName()));
                }
                long offset = ((LongLiteral)node.getArguments().get(1)).getParsedValue();
                if (offset < 0L) {
                    throw new SemanticException(String.format("%s pattern recognition navigation function requires a non-negative number as the second argument (actual: %s)", node.getName(), offset));
                }
                if (offset > Integer.MAX_VALUE) {
                    throw new SemanticException(String.format("The second argument of %s pattern recognition navigation function must not exceed %s (actual: %s)", node.getName(), Integer.MAX_VALUE, offset));
                }
            }
        }

        private void validateNavigationNesting(FunctionCall node) {
            Preconditions.checkArgument((boolean)this.isPatternNavigationFunction(node));
            String name = node.getName().getSuffix();
            List nestedNavigationFunctions = (List)ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)node.getArguments().get(0)), FunctionCall.class).stream().filter(this::isPatternNavigationFunction).collect(ImmutableList.toImmutableList());
            if (!nestedNavigationFunctions.isEmpty()) {
                if (name.equalsIgnoreCase("RPR_FIRST") || name.equalsIgnoreCase("RPR_LAST")) {
                    throw new SemanticException(String.format("Cannot nest %s pattern navigation function inside %s pattern navigation function", ((FunctionCall)nestedNavigationFunctions.get(0)).getName(), name));
                }
                if (nestedNavigationFunctions.size() > 1) {
                    throw new SemanticException(String.format("Cannot nest multiple pattern navigation functions inside %s pattern navigation function", name));
                }
                FunctionCall nested = (FunctionCall)Iterables.getOnlyElement((Iterable)nestedNavigationFunctions);
                String nestedName = nested.getName().getSuffix();
                if (nestedName.equalsIgnoreCase("PREV") || nestedName.equalsIgnoreCase("NEXT")) {
                    throw new SemanticException(String.format("Cannot nest %s pattern navigation function inside %s pattern navigation function", nestedName, name));
                }
                if (nested != node.getArguments().get(0)) {
                    throw new SemanticException("Immediate nesting is required for pattern navigation functions");
                }
            }
        }

        private boolean isPatternNavigationFunction(FunctionCall node) {
            if (!ExpressionAnalyzer.isPatternRecognitionFunction(node)) {
                return false;
            }
            String name = node.getName().getSuffix().toUpperCase(Locale.ENGLISH);
            return name.equals("RPR_FIRST") || name.equals("RPR_LAST") || name.equals("PREV") || name.equals("NEXT");
        }

        private boolean isClassifierFunction(FunctionCall node) {
            if (!ExpressionAnalyzer.isPatternRecognitionFunction(node)) {
                return false;
            }
            return node.getName().getSuffix().toUpperCase(Locale.ENGLISH).equals("CLASSIFIER");
        }

        private boolean isMatchNumberFunction(FunctionCall node) {
            if (!ExpressionAnalyzer.isPatternRecognitionFunction(node)) {
                return false;
            }
            return node.getName().getSuffix().toUpperCase(Locale.ENGLISH).equals("MATCH_NUMBER");
        }

        private String label(Identifier identifier) {
            return identifier.getCanonicalValue();
        }

        private ArgumentLabel validateLabelConsistency(FunctionCall node, int argumentIndex) {
            Set referenceLabels = (Set)ExpressionTreeUtils.extractExpressions(node.getArguments(), Expression.class).stream().map(child -> (Optional)ExpressionAnalyzer.this.labels.get(NodeRef.of(child))).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            Set classifierLabels = (Set)ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)node.getArguments().get(argumentIndex)), FunctionCall.class).stream().filter(this::isClassifierFunction).map(functionCall -> functionCall.getArguments().stream().findFirst().map(argument -> this.label((Identifier)argument))).collect(ImmutableSet.toImmutableSet());
            ImmutableSet allLabels = ImmutableSet.builder().addAll((Iterable)referenceLabels).addAll((Iterable)classifierLabels).build();
            if (allLabels.isEmpty()) {
                return ArgumentLabel.noLabel();
            }
            if (allLabels.size() > 1) {
                String name = node.getName().getSuffix();
                throw new SemanticException(String.format("All labels and classifiers inside the call to '%s' must match", name));
            }
            Optional label = (Optional)Iterables.getOnlyElement((Iterable)allLabels);
            return label.map(ArgumentLabel::explicitLabel).orElseGet(ArgumentLabel::universalLabel);
        }

        private Set<String> analyzeAggregationLabels(FunctionCall node) {
            if (node.getArguments().isEmpty()) {
                return ImmutableSet.of();
            }
            HashSet<Optional<String>> argumentLabels = new HashSet<Optional<String>>();
            for (int i = 0; i < node.getArguments().size(); ++i) {
                ArgumentLabel argumentLabel = this.validateLabelConsistency(node, i);
                if (!argumentLabel.hasLabel()) continue;
                argumentLabels.add(argumentLabel.getLabel());
            }
            if (argumentLabels.size() > 1) {
                throw new SemanticException("All aggregate function arguments must apply to rows matched with the same label");
            }
            return argumentLabels.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        }

        private void analyzePatternAggregation(FunctionCall node, ResolvedFunction function) {
            this.checkNoNestedAggregations(node);
            this.checkNoNestedNavigations(node);
            Set<String> labels = this.analyzeAggregationLabels(node);
            List matchNumberCalls = (List)ExpressionTreeUtils.extractExpressions(node.getArguments(), FunctionCall.class).stream().filter(this::isMatchNumberFunction).collect(ImmutableList.toImmutableList());
            List classifierCalls = (List)ExpressionTreeUtils.extractExpressions(node.getArguments(), FunctionCall.class).stream().filter(this::isClassifierFunction).collect(ImmutableList.toImmutableList());
            this.patternRecognitionInputs.add(new PatternRecognitionAnalysis.PatternFunctionAnalysis(node, new PatternRecognitionAnalysis.AggregationDescriptor(function, node.getArguments(), this.mapProcessingMode(node.getProcessingMode()), labels, matchNumberCalls, classifierCalls)));
        }

        private void checkNoNestedAggregations(FunctionCall node) {
            ExpressionTreeUtils.extractExpressions(node.getArguments(), FunctionCall.class).stream().filter(function -> ExpressionAnalyzer.this.metadata.isAggregationFunction(ExpressionAnalyzer.this.session, function.getName().getSuffix(), ExpressionAnalyzer.this.accessControl)).findFirst().ifPresent(aggregation -> {
                throw new SemanticException(String.format("Cannot nest %s aggregate function inside %s function", aggregation.getName(), node.getName()));
            });
        }

        private void checkNoNestedNavigations(FunctionCall node) {
            ExpressionTreeUtils.extractExpressions(node.getArguments(), FunctionCall.class).stream().filter(this::isPatternNavigationFunction).findFirst().ifPresent(navigation -> {
                throw new SemanticException(String.format("Cannot nest %s pattern navigation function inside %s function", navigation.getName().getSuffix(), node.getName()));
            });
        }

        @Override
        protected Type visitCurrentDatabase(CurrentDatabase node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)StringType.STRING);
        }

        @Override
        protected Type visitCurrentUser(CurrentUser node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)StringType.STRING);
        }

        @Override
        protected Type visitTrim(Trim node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            argumentTypes.add((Object)this.process((Node)node.getTrimSource(), context));
            node.getTrimCharacter().ifPresent(trimChar -> argumentTypes.add((Object)this.process((Node)trimChar, context)));
            ImmutableList actualTypes = argumentTypes.build();
            String functionName = node.getSpecification().getFunctionName();
            Type returnType = ExpressionAnalyzer.this.metadata.getFunctionReturnType(functionName, (List<? extends Type>)actualTypes);
            return ExpressionAnalyzer.this.setExpressionType(node, returnType);
        }

        @Override
        protected Type visitParameter(Parameter node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (ExpressionAnalyzer.this.parameters.isEmpty()) {
                throw new SemanticException("Query takes no parameters");
            }
            if (node.getId() >= ExpressionAnalyzer.this.parameters.size()) {
                throw new SemanticException(String.format("Invalid parameter index %s, max value is %s", node.getId(), ExpressionAnalyzer.this.parameters.size() - 1));
            }
            Expression providedValue = (Expression)ExpressionAnalyzer.this.parameters.get(NodeRef.of(node));
            if (providedValue == null) {
                throw new SemanticException("No value provided for parameter");
            }
            Type resultType = this.process((Node)providedValue, context);
            return ExpressionAnalyzer.this.setExpressionType(node, resultType);
        }

        @Override
        protected Type visitExtract(Extract node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            if (node.getExpression() instanceof LongLiteral) {
                ExpressionAnalyzer.this.setExpressionType(node.getExpression(), (Type)LongType.INT64);
            } else {
                Type type = this.process((Node)node.getExpression(), context);
                if (!(type instanceof TimestampType)) {
                    throw new SemanticException(String.format("Cannot extract from %s", type));
                }
            }
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)LongType.INT64);
        }

        @Override
        protected Type visitBetweenPredicate(BetweenPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type valueType = this.process((Node)node.getValue(), context);
            Type minType = this.process((Node)node.getMin(), context);
            Type maxType = this.process((Node)node.getMax(), context);
            if (!TableMetadataImpl.isTwoTypeComparable(Arrays.asList(valueType, minType)) || !TableMetadataImpl.isTwoTypeComparable(Arrays.asList(valueType, maxType))) {
                throw new SemanticException(String.format("Cannot check if %s is BETWEEN %s and %s", valueType, minType, maxType));
            }
            if (!valueType.isOrderable()) {
                throw new SemanticException(String.format("Cannot check if %s is BETWEEN %s and %s", valueType, minType, maxType));
            }
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        public Type visitCast(Cast node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type;
            try {
                type = ExpressionAnalyzer.this.metadata.getType(TypeSignatureTranslator.toTypeSignature(node.getType()));
            }
            catch (TypeNotFoundException e) {
                throw new SemanticException(String.format("Unknown type: %s", node.getType()));
            }
            if (type.equals(UnknownType.UNKNOWN)) {
                throw new SemanticException("UNKNOWN is not a valid type");
            }
            Type value = this.process((Node)node.getExpression(), context);
            if (!(value.equals(UnknownType.UNKNOWN) || node.isTypeOnly() || ExpressionAnalyzer.this.metadata.canCoerce(value, type))) {
                throw new SemanticException(String.format("Cannot cast %s to %s", value, type));
            }
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        @Override
        protected Type visitInPredicate(InPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Expression value = node.getValue();
            if (value instanceof Row) {
                throw new SemanticException(ExpressionAnalyzer.SUBQUERY_COLUMN_NUM_CHECK);
            }
            Expression valueList = node.getValueList();
            if (valueList instanceof InListExpression) {
                InListExpression inListExpression = (InListExpression)valueList;
                Type type = this.coerceToSingleType(context, "IN value and list items", (List<Expression>)ImmutableList.builder().add((Object)value).addAll(inListExpression.getValues()).build());
                ExpressionAnalyzer.this.setExpressionType(inListExpression, type);
            } else if (valueList instanceof SubqueryExpression) {
                ExpressionAnalyzer.this.subqueryInPredicates.add(NodeRef.of(node));
                this.analyzePredicateWithSubquery(node, this.process((Node)value, context), (SubqueryExpression)valueList, context);
            } else {
                throw new IllegalArgumentException("Unexpected value list type for InPredicate: " + node.getValueList().getClass().getName());
            }
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitSubqueryExpression(SubqueryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type type = this.analyzeSubquery(node, context);
            if (type instanceof RowType && ((RowType)type).getFields().size() == 1) {
                type = (Type)type.getTypeParameters().get(0);
            }
            ExpressionAnalyzer.this.setExpressionType(node, type);
            ExpressionAnalyzer.this.subqueries.add(NodeRef.of(node));
            return type;
        }

        private Type analyzePredicateWithSubquery(Expression node, Type declaredValueType, SubqueryExpression subquery, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            Type valueRowType = declaredValueType;
            Type subqueryType = this.analyzeSubquery(subquery, context);
            ExpressionAnalyzer.this.setExpressionType(subquery, subqueryType);
            Optional<Type> valueCoercion = Optional.empty();
            Optional<Type> subQueryCoercion = Optional.empty();
            ExpressionAnalyzer.this.predicateCoercions.put(NodeRef.of(node), new Analysis.PredicateCoercions(valueRowType, valueCoercion, subQueryCoercion));
            return subqueryType;
        }

        private Type analyzeSubquery(SubqueryExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            StatementAnalyzer analyzer = (StatementAnalyzer)ExpressionAnalyzer.this.statementAnalyzerFactory.apply(node, context.getContext().getCorrelationSupport());
            Scope subqueryScope = Scope.builder().withParent(context.getContext().getScope()).build();
            Scope queryScope = analyzer.analyze(node.getQuery(), subqueryScope);
            ImmutableList.Builder fields = ImmutableList.builder();
            for (int i = 0; i < queryScope.getRelationType().getAllFieldCount(); ++i) {
                Field field = queryScope.getRelationType().getFieldByIndex(i);
                if (field.isHidden()) continue;
                if (field.getName().isPresent()) {
                    fields.add((Object)RowType.field((String)field.getName().get(), (Type)field.getType()));
                    continue;
                }
                fields.add((Object)RowType.field((Type)field.getType()));
            }
            ImmutableList fieldList = fields.build();
            if (fieldList.size() != 1 || ((RowType.Field)fieldList.get(0)).getType() instanceof RowType) {
                throw new SemanticException(ExpressionAnalyzer.SUBQUERY_COLUMN_NUM_CHECK);
            }
            ExpressionAnalyzer.this.sourceFields.addAll(queryScope.getRelationType().getVisibleFields());
            return ((RowType.Field)Iterators.getOnlyElement(fields.build().stream().iterator())).getType();
        }

        private void analyzeWindow(Analysis.ResolvedWindow window, StackableAstVisitor.StackableAstVisitorContext<Context> context, Node originalNode) {
            Type type;
            ImmutableList.Builder childNodes = ImmutableList.builder();
            if (!window.isPartitionByInherited()) {
                childNodes.addAll(window.getPartitionBy());
            }
            if (!window.isOrderByInherited()) {
                window.getOrderBy().ifPresent(orderBy -> childNodes.addAll(orderBy.getSortItems()));
            }
            if (!window.isFrameInherited()) {
                window.getFrame().ifPresent(arg_0 -> ((ImmutableList.Builder)childNodes).add(arg_0));
            }
            if (!window.isPartitionByInherited()) {
                for (Expression expression : window.getPartitionBy()) {
                    this.process((Node)expression, context);
                    type = ExpressionAnalyzer.this.getExpressionType(expression);
                    if (type.isComparable()) continue;
                    throw new SemanticException(String.format("%s is not comparable, and therefore cannot be used in window function PARTITION BY", type));
                }
            }
            if (!window.isOrderByInherited()) {
                for (SortItem sortItem : NodeUtils.getSortItemsFromOrderBy(window.getOrderBy())) {
                    this.process((Node)sortItem.getSortKey(), context);
                    type = ExpressionAnalyzer.this.getExpressionType(sortItem.getSortKey());
                    if (type.isOrderable()) continue;
                    throw new SemanticException(String.format("%s is not orderable, and therefore cannot be used in window function ORDER BY", type));
                }
            }
            if (window.getFrame().isPresent() && !window.isFrameInherited()) {
                WindowFrame frame = window.getFrame().get();
                FrameBound.Type startType = frame.getStart().getType();
                FrameBound.Type endType = frame.getEnd().orElse(new FrameBound(null, FrameBound.Type.CURRENT_ROW)).getType();
                if (startType == FrameBound.Type.UNBOUNDED_FOLLOWING) {
                    throw new SemanticException("Window frame start cannot be UNBOUNDED FOLLOWING");
                }
                if (endType == FrameBound.Type.UNBOUNDED_PRECEDING) {
                    throw new SemanticException("Window frame end cannot be UNBOUNDED PRECEDING");
                }
                if (startType == FrameBound.Type.CURRENT_ROW && endType == FrameBound.Type.PRECEDING) {
                    throw new SemanticException("Window frame starting from CURRENT ROW cannot end with PRECEDING");
                }
                if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.PRECEDING) {
                    throw new SemanticException("Window frame starting from FOLLOWING cannot end with PRECEDING");
                }
                if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.CURRENT_ROW) {
                    throw new SemanticException("Window frame starting from FOLLOWING cannot end with CURRENT ROW");
                }
                if (frame.getType() == WindowFrame.Type.ROWS) {
                    Expression endValue;
                    Expression startValue;
                    Type type2;
                    if (frame.getStart().getValue().isPresent() && !ExpressionAnalyzer.isExactNumericWithScaleZero(type2 = this.process((Node)(startValue = frame.getStart().getValue().get()), context))) {
                        throw new SemanticException(String.format("Window frame ROWS start value type must be exact numeric type with scale 0 (actual %s)", type2));
                    }
                    if (frame.getEnd().isPresent() && frame.getEnd().get().getValue().isPresent() && !ExpressionAnalyzer.isExactNumericWithScaleZero(type2 = this.process((Node)(endValue = frame.getEnd().get().getValue().get()), context))) {
                        throw new SemanticException(String.format("Window frame ROWS end value type must be exact numeric type with scale 0 (actual %s)", type2));
                    }
                } else if (frame.getType() == WindowFrame.Type.RANGE) {
                    if (frame.getStart().getValue().isPresent()) {
                        Expression startValue = frame.getStart().getValue().get();
                        this.analyzeFrameRangeOffset(startValue, frame.getStart().getType(), context, window, originalNode);
                    }
                    if (frame.getEnd().isPresent() && frame.getEnd().get().getValue().isPresent()) {
                        Expression endValue = frame.getEnd().get().getValue().get();
                        this.analyzeFrameRangeOffset(endValue, frame.getEnd().get().getType(), context, window, originalNode);
                    }
                } else if (frame.getType() == WindowFrame.Type.GROUPS) {
                    Type type3;
                    if (frame.getStart().getValue().isPresent()) {
                        if (!window.getOrderBy().isPresent()) {
                            throw new SemanticException("Window frame of type GROUPS PRECEDING or FOLLOWING requires ORDER BY");
                        }
                        Expression startValue = frame.getStart().getValue().get();
                        type3 = this.process((Node)startValue, context);
                        if (!ExpressionAnalyzer.isExactNumericWithScaleZero(type3)) {
                            throw new SemanticException(String.format("Window frame GROUPS start value type must be exact numeric type with scale 0 (actual %s)", type3));
                        }
                    }
                    if (frame.getEnd().isPresent() && frame.getEnd().get().getValue().isPresent()) {
                        if (!window.getOrderBy().isPresent()) {
                            throw new SemanticException("Window frame of type GROUPS PRECEDING or FOLLOWING requires ORDER BY");
                        }
                        Expression endValue = frame.getEnd().get().getValue().get();
                        type3 = this.process((Node)endValue, context);
                        if (!ExpressionAnalyzer.isExactNumericWithScaleZero(type3)) {
                            throw new SemanticException(String.format("Window frame ROWS end value type must be exact numeric type with scale 0 (actual %s)", type3));
                        }
                    }
                } else {
                    throw new SemanticException("Unsupported frame type: " + (Object)((Object)frame.getType()));
                }
            }
        }

        private void analyzeFrameRangeOffset(Expression offsetValue, FrameBound.Type boundType, StackableAstVisitor.StackableAstVisitorContext<Context> context, Analysis.ResolvedWindow window, Node originalNode) {
            OrderBy orderBy = window.getOrderBy().orElseThrow(() -> new SemanticException("Window frame of type RANGE PRECEDING or FOLLOWING requires ORDER BY"));
            if (orderBy.getSortItems().size() != 1) {
                throw new SemanticException(String.format("Window frame of type RANGE PRECEDING or FOLLOWING requires single sort item in ORDER BY (actual: %s)", orderBy.getSortItems().size()));
            }
            Expression sortKey = ((SortItem)Iterables.getOnlyElement(orderBy.getSortItems())).getSortKey();
            Type sortKeyType = window.isOrderByInherited() ? (Type)ExpressionAnalyzer.this.getPreanalyzedType.apply(sortKey) : ExpressionAnalyzer.this.getExpressionType(sortKey);
            if (!TableMetadataImpl.isNumericType(sortKeyType)) {
                throw new SemanticException(String.format("Window frame of type RANGE PRECEDING or FOLLOWING requires that sort item type be numeric, datetime or interval (actual: %s)", sortKeyType));
            }
            Type offsetValueType = this.process((Node)offsetValue, context);
            if (TableMetadataImpl.isNumericType(sortKeyType) && !TableMetadataImpl.isNumericType(offsetValueType)) {
                throw new SemanticException(String.format("Window frame RANGE value type (%s) not compatible with sort item type (%s)", offsetValueType, sortKeyType));
            }
        }

        @Override
        protected Type visitExists(ExistsPredicate node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            StatementAnalyzer analyzer = (StatementAnalyzer)ExpressionAnalyzer.this.statementAnalyzerFactory.apply(node, context.getContext().getCorrelationSupport());
            Scope subqueryScope = Scope.builder().withParent(context.getContext().getScope()).build();
            List fields = (List)analyzer.analyze(node.getSubquery(), subqueryScope).getRelationType().getAllFields().stream().map(field -> {
                if (field.getName().isPresent()) {
                    return RowType.field((String)field.getName().get(), (Type)field.getType());
                }
                return RowType.field((Type)field.getType());
            }).collect(ImmutableList.toImmutableList());
            ExpressionAnalyzer.this.setExpressionType(node.getSubquery(), (Type)RowType.from((List)fields));
            ExpressionAnalyzer.this.existsSubqueries.add(NodeRef.of(node));
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        protected Type visitQuantifiedComparisonExpression(QuantifiedComparisonExpression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ExpressionAnalyzer.this.quantifiedComparisons.add(NodeRef.of(node));
            Type declaredValueType = this.process((Node)node.getValue(), context);
            Type comparisonType = this.analyzePredicateWithSubquery(node, declaredValueType, (SubqueryExpression)node.getSubquery(), context);
            switch (node.getOperator()) {
                case LESS_THAN: 
                case GREATER_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN_OR_EQUAL: {
                    if (comparisonType.isOrderable()) break;
                    throw new SemanticException(String.format("Type [%s] must be orderable in order to be used in quantified comparison", comparisonType));
                }
                case EQUAL: 
                case NOT_EQUAL: {
                    if (comparisonType.isComparable()) break;
                    throw new SemanticException(String.format("Type [%s] must be comparable in order to be used in quantified comparison", comparisonType));
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected comparison type: %s", new Object[]{node.getOperator()}));
                }
            }
            return ExpressionAnalyzer.this.setExpressionType(node, (Type)BooleanType.BOOLEAN);
        }

        @Override
        public Type visitFieldReference(FieldReference node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            ResolvedField field = this.baseScope.getField(node.getFieldIndex());
            return this.handleResolvedField(node, field, context);
        }

        @Override
        protected Type visitExpression(Expression node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            throw new SemanticException(String.format("not yet implemented: %s", node.getClass().getName()));
        }

        @Override
        protected Type visitNode(Node node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            throw new SemanticException(String.format("not yet implemented: %s", node.getClass().getName()));
        }

        @Override
        protected Type visitColumns(Columns node, StackableAstVisitor.StackableAstVisitorContext<Context> context) {
            throw new SemanticException("Columns only support to be used in SELECT and WHERE clause");
        }

        private Type getOperator(StackableAstVisitor.StackableAstVisitorContext<Context> context, Expression node, OperatorType operatorType, Expression ... arguments) {
            Type type;
            ImmutableList.Builder argumentTypes = ImmutableList.builder();
            for (Expression expression : arguments) {
                argumentTypes.add((Object)this.process((Node)expression, context));
            }
            try {
                type = ExpressionAnalyzer.this.metadata.getOperatorReturnType(operatorType, (List<? extends Type>)argumentTypes.build());
            }
            catch (OperatorNotFoundException e) {
                throw new SemanticException(e.getMessage());
            }
            return ExpressionAnalyzer.this.setExpressionType(node, type);
        }

        private void coerceType(Expression expression, Type actualType, Type expectedType, String message) {
            if (!actualType.equals(expectedType)) {
                throw new SemanticException(String.format("%s must evaluate to a %s (actual: %s)", message, expectedType, actualType));
            }
        }

        private void coerceType(StackableAstVisitor.StackableAstVisitorContext<Context> context, Expression expression, Type expectedType, String message) {
            Type actualType = this.process((Node)expression, context);
            this.coerceType(expression, actualType, expectedType, message);
        }

        private Type coerceToSingleType(StackableAstVisitor.StackableAstVisitorContext<Context> context, Node node, String message, Expression first, Expression second) {
            UnknownType firstType = UnknownType.UNKNOWN;
            if (first != null) {
                firstType = this.process((Node)first, context);
            }
            UnknownType secondType = UnknownType.UNKNOWN;
            if (second != null) {
                secondType = this.process((Node)second, context);
            }
            if (!firstType.equals(secondType)) {
                throw new SemanticException(String.format("%s: %s vs %s", message, firstType, secondType));
            }
            return firstType;
        }

        private Type coerceToSingleType(StackableAstVisitor.StackableAstVisitorContext<Context> context, String description, List<Expression> expressions) {
            UnknownType superType = UnknownType.UNKNOWN;
            LinkedHashMultimap typeExpressions = LinkedHashMultimap.create();
            for (Expression expression : expressions) {
                Type type = this.process((Node)expression, context);
                typeExpressions.put((Object)type, NodeRef.of(expression));
            }
            Set types = typeExpressions.keySet();
            for (Type type : types) {
                if (superType == UnknownType.UNKNOWN) {
                    superType = type;
                    continue;
                }
                if (TableMetadataImpl.isTwoTypeComparable(Arrays.asList(superType, type))) continue;
                throw new SemanticException(String.format("%s must be the same type or coercible to a common type. Cannot find common type between %s and %s, all types (without duplicates): %s", description, superType, type, typeExpressions.keySet()));
            }
            return superType;
        }
    }

    private static class Context {
        private final Scope scope;
        private final List<Type> functionInputTypes;
        private final Optional<PatternRecognitionContext> patternRecognitionContext;
        private final CorrelationSupport correlationSupport;

        private Context(Scope scope, List<Type> functionInputTypes, Optional<PatternRecognitionContext> patternRecognitionContext, CorrelationSupport correlationSupport) {
            this.scope = Objects.requireNonNull(scope, "scope is null");
            this.functionInputTypes = functionInputTypes;
            this.patternRecognitionContext = Objects.requireNonNull(patternRecognitionContext, "patternRecognitionContext is null");
            this.correlationSupport = Objects.requireNonNull(correlationSupport, "correlationSupport is null");
        }

        public static Context notInLambda(Scope scope, CorrelationSupport correlationSupport) {
            return new Context(scope, null, Optional.empty(), correlationSupport);
        }

        public Context expectingLambda(List<Type> functionInputTypes) {
            return new Context(this.scope, Objects.requireNonNull(functionInputTypes, "functionInputTypes is null"), Optional.empty(), this.correlationSupport);
        }

        public Context notExpectingLambda() {
            return new Context(this.scope, null, Optional.empty(), this.correlationSupport);
        }

        public static Context patternRecognition(Scope scope, Set<String> labels) {
            return new Context(scope, null, Optional.of(new PatternRecognitionContext(labels, PatternRecognitionAnalysis.Navigation.DEFAULT)), CorrelationSupport.DISALLOWED);
        }

        public Context withNavigation(PatternRecognitionAnalysis.Navigation navigation) {
            PatternRecognitionContext patternRecognitionContext = new PatternRecognitionContext(this.patternRecognitionContext.get().labels, navigation);
            return new Context(this.scope, this.functionInputTypes, Optional.of(patternRecognitionContext), this.correlationSupport);
        }

        public Context patternRecognition(Set<String> labels) {
            return new Context(this.scope, this.functionInputTypes, Optional.of(new PatternRecognitionContext(labels, PatternRecognitionAnalysis.Navigation.DEFAULT)), CorrelationSupport.DISALLOWED);
        }

        public Context notExpectingLabels() {
            return new Context(this.scope, this.functionInputTypes, Optional.empty(), this.correlationSupport);
        }

        Scope getScope() {
            return this.scope;
        }

        public boolean isExpectingLambda() {
            return this.functionInputTypes != null;
        }

        public boolean isPatternRecognition() {
            return this.patternRecognitionContext.isPresent();
        }

        public List<Type> getFunctionInputTypes() {
            Preconditions.checkState((boolean)this.isExpectingLambda());
            return this.functionInputTypes;
        }

        public PatternRecognitionContext getPatternRecognitionContext() {
            return this.patternRecognitionContext.get();
        }

        public CorrelationSupport getCorrelationSupport() {
            return this.correlationSupport;
        }

        public static class PatternRecognitionContext {
            private final Set<String> labels;
            private final PatternRecognitionAnalysis.Navigation navigation;

            public PatternRecognitionContext(Set<String> labels, PatternRecognitionAnalysis.Navigation navigation) {
                this.labels = labels;
                this.navigation = navigation;
            }

            public Set<String> getLabels() {
                return this.labels;
            }

            public PatternRecognitionAnalysis.Navigation getNavigation() {
                return this.navigation;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PatternRecognitionContext that = (PatternRecognitionContext)o;
                if (!this.labels.equals(that.labels)) {
                    return false;
                }
                return this.navigation.equals(that.navigation);
            }

            public int hashCode() {
                int result = this.labels.hashCode();
                result = 31 * result + this.navigation.hashCode();
                return result;
            }

            public String toString() {
                return "PatternRecognitionContext{labels=" + this.labels + ", navigation=" + this.navigation + '}';
            }
        }
    }

    private static class ArgumentLabel {
        private final boolean hasLabel;
        private final Optional<String> label;

        private ArgumentLabel(boolean hasLabel, Optional<String> label) {
            this.hasLabel = hasLabel;
            this.label = label;
        }

        public static ArgumentLabel noLabel() {
            return new ArgumentLabel(false, Optional.empty());
        }

        public static ArgumentLabel universalLabel() {
            return new ArgumentLabel(true, Optional.empty());
        }

        public static ArgumentLabel explicitLabel(String label) {
            return new ArgumentLabel(true, Optional.of(label));
        }

        public boolean hasLabel() {
            return this.hasLabel;
        }

        public Optional<String> getLabel() {
            Preconditions.checkState((boolean)this.hasLabel, (Object)"no label available");
            return this.label;
        }
    }

    public static class LabelPrefixedReference {
        private final String label;
        private final Optional<Identifier> column;

        public LabelPrefixedReference(String label, Identifier column) {
            this(label, Optional.of(Objects.requireNonNull(column, "column is null")));
        }

        public LabelPrefixedReference(String label) {
            this(label, Optional.empty());
        }

        private LabelPrefixedReference(String label, Optional<Identifier> column) {
            this.label = Objects.requireNonNull(label, "label is null");
            this.column = Objects.requireNonNull(column, "column is null");
        }

        public String getLabel() {
            return this.label;
        }

        public Optional<Identifier> getColumn() {
            return this.column;
        }
    }
}

