/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tsfile.parser.scan;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.encrypt.EncryptParameter;
import org.apache.tsfile.encrypt.IDecryptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.header.ChunkHeader;
import org.apache.tsfile.file.header.PageHeader;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.Chunk;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.reader.chunk.AbstractChunkReader;
import org.apache.tsfile.read.reader.chunk.ChunkReader;
import org.apache.tsfile.read.reader.page.AlignedPageReader;

public class AlignedSinglePageWholeChunkReader
extends AbstractChunkReader {
    private final ChunkHeader timeChunkHeader;
    private final ByteBuffer timeChunkDataBuffer;
    private final EncryptParameter encryptParam;
    private final List<ChunkHeader> valueChunkHeaderList = new ArrayList<ChunkHeader>();
    private final List<ByteBuffer> valueChunkDataBufferList = new ArrayList<ByteBuffer>();
    private final List<List<TimeRange>> valueDeleteIntervalsList = new ArrayList<List<TimeRange>>();

    public AlignedSinglePageWholeChunkReader(Chunk timeChunk, List<Chunk> valueChunkList) throws IOException {
        super(Long.MIN_VALUE, null);
        this.timeChunkHeader = timeChunk.getHeader();
        this.timeChunkDataBuffer = timeChunk.getData();
        this.encryptParam = timeChunk.getEncryptParam();
        valueChunkList.forEach(chunk -> {
            this.valueChunkHeaderList.add(chunk == null ? null : chunk.getHeader());
            this.valueChunkDataBufferList.add(chunk == null ? null : chunk.getData());
            this.valueDeleteIntervalsList.add(chunk == null ? null : chunk.getDeleteIntervalList());
        });
        this.initAllPageReaders();
    }

    private void initAllPageReaders() throws IOException {
        while (this.timeChunkDataBuffer.remaining() > 0) {
            AlignedPageReader alignedPageReader = this.deserializeFromSinglePageChunk();
            if (alignedPageReader == null) continue;
            this.pageReaderList.add(alignedPageReader);
        }
    }

    private AlignedPageReader deserializeFromSinglePageChunk() throws IOException {
        PageHeader timePageHeader = PageHeader.deserializeFrom((ByteBuffer)this.timeChunkDataBuffer, (Statistics)null);
        ArrayList<PageHeader> valuePageHeaderList = new ArrayList<PageHeader>();
        boolean isAllNull = true;
        for (ByteBuffer byteBuffer : this.valueChunkDataBufferList) {
            if (byteBuffer != null) {
                isAllNull = false;
                valuePageHeaderList.add(PageHeader.deserializeFrom((ByteBuffer)byteBuffer, (Statistics)null));
                continue;
            }
            valuePageHeaderList.add(null);
        }
        if (isAllNull) {
            this.skipCurrentPage(timePageHeader, valuePageHeaderList);
            return null;
        }
        return this.constructAlignedPageReader(timePageHeader, valuePageHeaderList);
    }

    private void skipCurrentPage(PageHeader timePageHeader, List<PageHeader> valuePageHeader) {
        this.timeChunkDataBuffer.position(this.timeChunkDataBuffer.position() + timePageHeader.getCompressedSize());
        for (int i = 0; i < valuePageHeader.size(); ++i) {
            if (valuePageHeader.get(i) == null) continue;
            this.valueChunkDataBufferList.get(i).position(this.valueChunkDataBufferList.get(i).position() + valuePageHeader.get(i).getCompressedSize());
        }
    }

    private AlignedPageReader constructAlignedPageReader(PageHeader timePageHeader, List<PageHeader> rawValuePageHeaderList) throws IOException {
        IDecryptor decryptor = IDecryptor.getDecryptor((EncryptParameter)this.encryptParam);
        ByteBuffer timePageData = ChunkReader.deserializePageData((PageHeader)timePageHeader, (ByteBuffer)this.timeChunkDataBuffer, (ChunkHeader)this.timeChunkHeader, (IDecryptor)decryptor);
        ArrayList<PageHeader> valuePageHeaderList = new ArrayList<PageHeader>();
        ArrayList<ByteBuffer> valuePageDataList = new ArrayList<ByteBuffer>();
        ArrayList<TSDataType> valueDataTypeList = new ArrayList<TSDataType>();
        ArrayList<Decoder> valueDecoderList = new ArrayList<Decoder>();
        boolean isAllNull = true;
        for (int i = 0; i < rawValuePageHeaderList.size(); ++i) {
            PageHeader valuePageHeader = rawValuePageHeaderList.get(i);
            if (valuePageHeader == null || valuePageHeader.getUncompressedSize() == 0) {
                valuePageHeaderList.add(null);
                valuePageDataList.add(null);
                valueDataTypeList.add(null);
                valueDecoderList.add(null);
                continue;
            }
            ChunkHeader valueChunkHeader = this.valueChunkHeaderList.get(i);
            valuePageHeaderList.add(valuePageHeader);
            valuePageDataList.add(ChunkReader.deserializePageData((PageHeader)valuePageHeader, (ByteBuffer)this.valueChunkDataBufferList.get(i), (ChunkHeader)valueChunkHeader, (IDecryptor)decryptor));
            valueDataTypeList.add(valueChunkHeader.getDataType());
            valueDecoderList.add(Decoder.getDecoderByType((TSEncoding)valueChunkHeader.getEncodingType(), (TSDataType)valueChunkHeader.getDataType()));
            isAllNull = false;
        }
        if (isAllNull) {
            return null;
        }
        AlignedPageReader alignedPageReader = new AlignedPageReader(timePageHeader, timePageData, this.defaultTimeDecoder, valuePageHeaderList, valuePageDataList, valueDataTypeList, valueDecoderList, this.queryFilter);
        alignedPageReader.setDeleteIntervalList(this.valueDeleteIntervalsList);
        return alignedPageReader;
    }
}

