/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.MoreObjects;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.planner.rowpattern.ExpressionAndValuePointers;
import org.apache.iotdb.db.queryengine.plan.relational.utils.TypeUtil;
import org.apache.tsfile.read.common.type.Type;

public class Measure {
    private final ExpressionAndValuePointers expressionAndValuePointers;
    private final Type type;

    public Measure(ExpressionAndValuePointers expressionAndValuePointers, Type type) {
        this.expressionAndValuePointers = Objects.requireNonNull(expressionAndValuePointers, "expressionAndValuePointers is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public ExpressionAndValuePointers getExpressionAndValuePointers() {
        return this.expressionAndValuePointers;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Measure that = (Measure)o;
        return Objects.equals(this.expressionAndValuePointers, that.expressionAndValuePointers) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.expressionAndValuePointers, this.type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("expressionAndValuePointers", (Object)this.expressionAndValuePointers).add("type", (Object)this.type).toString();
    }

    public static void serialize(Measure measure, ByteBuffer byteBuffer) {
        ExpressionAndValuePointers.serialize(measure.getExpressionAndValuePointers(), byteBuffer);
        TypeUtil.serialize(measure.getType(), byteBuffer);
    }

    public static void serialize(Measure measure, DataOutputStream stream) throws IOException {
        ExpressionAndValuePointers.serialize(measure.expressionAndValuePointers, stream);
        TypeUtil.serialize(measure.getType(), stream);
    }

    public static Measure deserialize(ByteBuffer byteBuffer) {
        ExpressionAndValuePointers expressionAndValuePointers = ExpressionAndValuePointers.deserialize(byteBuffer);
        Type type = TypeUtil.deserialize(byteBuffer);
        return new Measure(expressionAndValuePointers, type);
    }
}

