/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.metric;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.schemaengine.metric.ISchemaRegionMetric;
import org.apache.iotdb.db.schemaengine.metric.SchemaRegionMemMetric;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.rescon.MemSchemaRegionStatistics;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.impl.DoNothingMetricManager;
import org.apache.iotdb.metrics.type.Counter;
import org.apache.iotdb.metrics.type.Timer;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class SchemaRegionCachedMetric
implements ISchemaRegionMetric {
    private static final String PINNED_NODE_NUM = "pbtree_pinned_num";
    private static final String UNPINNED_NODE_NUM = "pbtree_unpinned_num";
    private static final String PINNED_MEM_SIZE = "pbtree_pinned_mem";
    private static final String UNPINNED_MEM_SIZE = "pbtree_unpinned_mem";
    private static final String VOLATILE_NODE_NUM = "pbtree_volatile_node_num";
    private static final String CACHE_NODE_NUM = "pbtree_cache_node_num";
    private static final String MLOG_LENGTH = "pbtree_mlog_length";
    private static final String MLOG_CHECKPOINT = "pbtree_mlog_checkpoint";
    private static final String RELEASE_TIMER = "pbtree_release_timer";
    private static final String RELEASE_MEM = "pbtree_release_mem";
    private static final String RELEASE_NODE = "pbtree_release_node";
    private static final String FLUSH_TIMER = "pbtree_flush_timer";
    private static final String FLUSH_MEM = "pbtree_flush_mem";
    private static final String FLUSH_NODE = "pbtree_flush_node";
    private static final String LOAD_MEM = "pbtree_load_mem";
    private static final String LOAD_NODE = "pbtree_load_node";
    private static final String LOAD_PAGE_NUM = "pbtree_load_page_num";
    private static final String FLUSH_PAGE_NUM = "pbtree_flush_page_num";
    private Timer releaseTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Timer flushTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
    private Counter releaseMem = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter releaseNode = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter flushMem = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter flushNode = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter loadMem = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter loadNode = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter loadPageNum = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private Counter flushPageNum = DoNothingMetricManager.DO_NOTHING_COUNTER;
    private final CachedSchemaRegionStatistics regionStatistics;
    private final String regionTagValue;
    private final SchemaRegionMemMetric memSchemaRegionMetric;
    private final String database;

    public SchemaRegionCachedMetric(CachedSchemaRegionStatistics regionStatistics, String database) {
        this.regionStatistics = regionStatistics;
        this.regionTagValue = String.format("SchemaRegion[%d]", regionStatistics.getSchemaRegionId());
        this.memSchemaRegionMetric = new SchemaRegionMemMetric(regionStatistics, database);
        this.database = database;
    }

    public void bindTo(AbstractMetricService metricService) {
        this.memSchemaRegionMetric.bindTo(metricService);
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, CachedSchemaRegionStatistics::getPinnedMNodeNum, new String[]{Tag.NAME.toString(), PINNED_NODE_NUM, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, CachedSchemaRegionStatistics::getUnpinnedMNodeNum, new String[]{Tag.NAME.toString(), UNPINNED_NODE_NUM, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, CachedSchemaRegionStatistics::getPinnedMemorySize, new String[]{Tag.NAME.toString(), PINNED_MEM_SIZE, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, CachedSchemaRegionStatistics::getUnpinnedMemorySize, new String[]{Tag.NAME.toString(), UNPINNED_MEM_SIZE, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, CachedSchemaRegionStatistics::getVolatileMNodeNum, new String[]{Tag.NAME.toString(), VOLATILE_NODE_NUM, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, CachedSchemaRegionStatistics::getCacheNodeNum, new String[]{Tag.NAME.toString(), CACHE_NODE_NUM, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, MemSchemaRegionStatistics::getMLogLength, new String[]{Tag.NAME.toString(), MLOG_LENGTH, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        metricService.createAutoGauge(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, (Object)this.regionStatistics, CachedSchemaRegionStatistics::getMlogCheckPoint, new String[]{Tag.NAME.toString(), MLOG_CHECKPOINT, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        this.flushTimer = metricService.getOrCreateTimer(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), FLUSH_TIMER, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        this.releaseTimer = metricService.getOrCreateTimer(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RELEASE_TIMER, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        this.releaseMem = metricService.getOrCreateCounter(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RELEASE_MEM, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        this.releaseNode = metricService.getOrCreateCounter(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), RELEASE_NODE, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        this.flushMem = metricService.getOrCreateCounter(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), FLUSH_MEM, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        this.flushNode = metricService.getOrCreateCounter(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), FLUSH_NODE, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        this.loadNode = metricService.getOrCreateCounter(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), LOAD_NODE, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        this.loadMem = metricService.getOrCreateCounter(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), LOAD_MEM, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        this.flushPageNum = metricService.getOrCreateCounter(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), FLUSH_PAGE_NUM, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
        this.loadPageNum = metricService.getOrCreateCounter(Metric.SCHEMA_REGION.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), LOAD_PAGE_NUM, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.memSchemaRegionMetric.unbindFrom(metricService);
        this.releaseTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.flushTimer = DoNothingMetricManager.DO_NOTHING_TIMER;
        this.releaseMem = DoNothingMetricManager.DO_NOTHING_COUNTER;
        this.releaseNode = DoNothingMetricManager.DO_NOTHING_COUNTER;
        this.flushMem = DoNothingMetricManager.DO_NOTHING_COUNTER;
        this.flushNode = DoNothingMetricManager.DO_NOTHING_COUNTER;
        this.loadMem = DoNothingMetricManager.DO_NOTHING_COUNTER;
        this.loadNode = DoNothingMetricManager.DO_NOTHING_COUNTER;
        this.flushPageNum = DoNothingMetricManager.DO_NOTHING_COUNTER;
        this.loadPageNum = DoNothingMetricManager.DO_NOTHING_COUNTER;
        Arrays.asList(PINNED_NODE_NUM, UNPINNED_NODE_NUM, PINNED_MEM_SIZE, UNPINNED_MEM_SIZE, VOLATILE_NODE_NUM, CACHE_NODE_NUM, MLOG_LENGTH, MLOG_CHECKPOINT).forEach(name -> metricService.remove(MetricType.AUTO_GAUGE, Metric.SCHEMA_REGION.toString(), new String[]{Tag.NAME.toString(), name, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database}));
        Arrays.asList(FLUSH_TIMER, RELEASE_TIMER).forEach(name -> metricService.remove(MetricType.TIMER, Metric.SCHEMA_REGION.toString(), new String[]{Tag.NAME.toString(), name, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database}));
        Arrays.asList(RELEASE_MEM, RELEASE_NODE, FLUSH_MEM, FLUSH_NODE, LOAD_MEM, LOAD_NODE, FLUSH_PAGE_NUM, LOAD_PAGE_NUM).forEach(name -> metricService.remove(MetricType.COUNTER, Metric.SCHEMA_REGION.toString(), new String[]{Tag.NAME.toString(), name, Tag.REGION.toString(), this.regionTagValue, Tag.DATABASE.toString(), this.database}));
    }

    public void recordRelease(long time, long mem, long node) {
        this.releaseTimer.update(time, TimeUnit.MILLISECONDS);
        this.releaseMem.inc(mem);
        this.releaseNode.inc(node);
    }

    public void recordFlush(long time, long mem, long node) {
        this.flushTimer.update(time, TimeUnit.MILLISECONDS);
        this.flushMem.inc(mem);
        this.flushNode.inc(node);
    }

    public void recordLoadFromDisk(long mem, long node) {
        this.loadMem.inc(mem);
        this.loadNode.inc(node);
    }

    public void recordFlushPageNum(int pageNum) {
        this.flushPageNum.inc((long)pageNum);
    }

    public void recordLoadPageNum(int pageNum) {
        this.loadPageNum.inc((long)pageNum);
    }

    public void recordTraverser(long time) {
        this.memSchemaRegionMetric.recordTraverser(time);
    }
}

