/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.write.schema;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.write.schema.MeasurementSchemaType;

public interface IMeasurementSchema
extends Accountable {
    public MeasurementSchemaType getSchemaType();

    public String getMeasurementName();

    public CompressionType getCompressor();

    public TSEncoding getEncodingType();

    public TSDataType getType();

    public byte getTypeInByte();

    public void setDataType(TSDataType var1);

    public TSEncoding getTimeTSEncoding();

    public Encoder getTimeEncoder();

    public Encoder getValueEncoder();

    public Map<String, String> getProps();

    public List<String> getSubMeasurementsList();

    public List<TSDataType> getSubMeasurementsTSDataTypeList();

    public List<TSEncoding> getSubMeasurementsTSEncodingList();

    public List<Encoder> getSubMeasurementsEncoderList();

    public int getSubMeasurementIndex(String var1);

    public int getSubMeasurementsCount();

    public boolean containsSubMeasurement(String var1);

    public int serializedSize();

    public int serializeTo(ByteBuffer var1);

    public int serializeTo(OutputStream var1) throws IOException;

    public int partialSerializeTo(ByteBuffer var1);

    public int partialSerializeTo(OutputStream var1) throws IOException;

    public boolean isLogicalView();

    public static List<String> getMeasurementNameList(List<? extends IMeasurementSchema> schemaList) {
        return schemaList.stream().map(IMeasurementSchema::getMeasurementName).collect(Collectors.toList());
    }

    public static List<TSDataType> getDataTypeList(List<? extends IMeasurementSchema> schemaList) {
        return schemaList.stream().map(IMeasurementSchema::getType).collect(Collectors.toList());
    }
}

