/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.aes;

import com.google.crypto.tink.subtle.Hex;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.blob.aes.CryptoConfigBuilder;

public class CryptoConfig {
    private final String salt;
    private final char[] password;
    private final Optional<String> privateKeyAlgorithm;

    public static CryptoConfigBuilder builder() {
        return new CryptoConfigBuilder();
    }

    CryptoConfig(String salt, char[] password, Optional<String> privateKeyAlgorithm) {
        this.salt = salt;
        this.password = password;
        this.privateKeyAlgorithm = privateKeyAlgorithm;
    }

    public byte[] salt() {
        return Hex.decode((String)this.salt);
    }

    public char[] password() {
        return this.password;
    }

    public Optional<String> getPrivateKeyAlgorithm() {
        return this.privateKeyAlgorithm;
    }

    public final boolean equals(Object o) {
        if (o instanceof CryptoConfig) {
            CryptoConfig that = (CryptoConfig)o;
            return Objects.equals(this.salt, that.salt) && Arrays.equals(this.password, that.password) && Objects.equals(this.privateKeyAlgorithm, that.privateKeyAlgorithm);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.salt, this.password, this.privateKeyAlgorithm);
    }
}

