/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.user.api.UsernameChangeTaskStep;
import org.apache.james.webadmin.service.UsernameChangeService;
import org.apache.james.webadmin.service.UsernameChangeTask;

public class UsernameChangeTaskDTO
implements TaskDTO {
    private final String type;
    private final String oldUser;
    private final String newUser;
    private final Optional<String> fromStep;

    public static TaskDTOModule<UsernameChangeTask, UsernameChangeTaskDTO> module(UsernameChangeService service) {
        return (TaskDTOModule)DTOModule.forDomainObject(UsernameChangeTask.class).convertToDTO(UsernameChangeTaskDTO.class).toDomainObjectConverter(dto -> dto.fromDTO(service)).toDTOConverter(UsernameChangeTaskDTO::toDTO).typeName(UsernameChangeTask.TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    public static UsernameChangeTaskDTO toDTO(UsernameChangeTask domainObject, String typeName) {
        return new UsernameChangeTaskDTO(typeName, domainObject.getOldUser().asString(), domainObject.getNewUser().asString(), domainObject.getFromStep().map(UsernameChangeTaskStep.StepName::asString));
    }

    public UsernameChangeTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="oldUser") String oldUser, @JsonProperty(value="newUser") String newUser, @JsonProperty(value="fromStep") Optional<String> fromStep) {
        this.type = type;
        this.oldUser = oldUser;
        this.newUser = newUser;
        this.fromStep = fromStep;
    }

    public UsernameChangeTask fromDTO(UsernameChangeService service) {
        return new UsernameChangeTask(service, Username.of((String)this.oldUser), Username.of((String)this.newUser), this.fromStep.map(UsernameChangeTaskStep.StepName::new));
    }

    public String getType() {
        return this.type;
    }

    public String getOldUser() {
        return this.oldUser;
    }

    public String getNewUser() {
        return this.newUser;
    }

    public Optional<String> getFromStep() {
        return this.fromStep;
    }
}

