/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail.dao;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.UUID;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.james.backends.postgres.PostgresCommons;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.PostgresMessageId;
import org.apache.james.mailbox.postgres.mail.PostgresMessageDataDefinition;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxMessageDAOUtils;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.mail.model.impl.SimpleMailboxMessage;
import org.jooq.Field;
import org.jooq.Record;

public interface PostgresMailboxMessageFetchStrategy {
    public static final PostgresMailboxMessageFetchStrategy METADATA = new MetaData();
    public static final PostgresMailboxMessageFetchStrategy FULL = new Full();

    public Field<?>[] fetchFields();

    public Function<Record, SimpleMailboxMessage.Builder> toMessageBuilder();

    public static Function<Record, SimpleMailboxMessage.Builder> toMessageBuilderMetadata() {
        return record -> SimpleMailboxMessage.builder().messageId((MessageId)PostgresMessageId.Factory.of((UUID)record.get(PostgresMessageDataDefinition.MessageTable.MESSAGE_ID))).mailboxId((MailboxId)PostgresMailboxId.of((UUID)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID))).uid(MessageUid.of((long)((Long)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID)))).modseq(ModSeq.of((long)((Long)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.MOD_SEQ)))).threadId(PostgresMailboxMessageDAOUtils.RECORD_TO_THREAD_ID_FUNCTION.apply((Record)record)).internalDate((Date)PostgresCommons.LOCAL_DATE_TIME_DATE_FUNCTION.apply((LocalDateTime)record.get(PostgresMessageDataDefinition.MessageTable.INTERNAL_DATE, LocalDateTime.class))).saveDate((Date)PostgresCommons.LOCAL_DATE_TIME_DATE_FUNCTION.apply((LocalDateTime)record.get(PostgresMessageDataDefinition.MessageToMailboxTable.SAVE_DATE, LocalDateTime.class))).flags(PostgresMailboxMessageDAOUtils.RECORD_TO_FLAGS_FUNCTION.apply((Record)record)).size(((Long)record.get(PostgresMessageDataDefinition.MessageTable.SIZE)).longValue()).bodyStartOctet(((Integer)record.get(PostgresMessageDataDefinition.MessageTable.BODY_START_OCTET)).intValue());
    }

    public static Field<?>[] fetchFieldsMetadata() {
        return new Field[]{PostgresCommons.tableField(PostgresMessageDataDefinition.MessageTable.TABLE_NAME, PostgresMessageDataDefinition.MessageTable.MESSAGE_ID).as(PostgresMessageDataDefinition.MessageTable.MESSAGE_ID), PostgresCommons.tableField(PostgresMessageDataDefinition.MessageTable.TABLE_NAME, PostgresMessageDataDefinition.MessageTable.INTERNAL_DATE).as(PostgresMessageDataDefinition.MessageTable.INTERNAL_DATE), PostgresCommons.tableField(PostgresMessageDataDefinition.MessageTable.TABLE_NAME, PostgresMessageDataDefinition.MessageTable.SIZE).as(PostgresMessageDataDefinition.MessageTable.SIZE), PostgresMessageDataDefinition.MessageTable.BODY_BLOB_ID, PostgresMessageDataDefinition.MessageTable.MIME_TYPE, PostgresMessageDataDefinition.MessageTable.MIME_SUBTYPE, PostgresMessageDataDefinition.MessageTable.BODY_START_OCTET, PostgresMessageDataDefinition.MessageTable.TEXTUAL_LINE_COUNT, PostgresMessageDataDefinition.MessageTable.ATTACHMENT_METADATA, PostgresMessageDataDefinition.MessageToMailboxTable.MAILBOX_ID, PostgresMessageDataDefinition.MessageToMailboxTable.MESSAGE_UID, PostgresMessageDataDefinition.MessageToMailboxTable.MOD_SEQ, PostgresMessageDataDefinition.MessageToMailboxTable.THREAD_ID, PostgresMessageDataDefinition.MessageToMailboxTable.IS_DELETED, PostgresMessageDataDefinition.MessageToMailboxTable.IS_ANSWERED, PostgresMessageDataDefinition.MessageToMailboxTable.IS_DRAFT, PostgresMessageDataDefinition.MessageToMailboxTable.IS_FLAGGED, PostgresMessageDataDefinition.MessageToMailboxTable.IS_RECENT, PostgresMessageDataDefinition.MessageToMailboxTable.IS_SEEN, PostgresMessageDataDefinition.MessageToMailboxTable.USER_FLAGS, PostgresMessageDataDefinition.MessageToMailboxTable.SAVE_DATE};
    }

    public static class MetaData
    implements PostgresMailboxMessageFetchStrategy {
        public static final Field<?>[] FETCH_FIELDS = PostgresMailboxMessageFetchStrategy.fetchFieldsMetadata();
        public static final Content EMPTY_CONTENT = PostgresMailboxMessageDAOUtils.BYTE_TO_CONTENT_FUNCTION.apply(new byte[0]);
        public static final PropertyBuilder EMPTY_PROPERTY_BUILDER = new PropertyBuilder();

        @Override
        public Field<?>[] fetchFields() {
            return FETCH_FIELDS;
        }

        @Override
        public Function<Record, SimpleMailboxMessage.Builder> toMessageBuilder() {
            return record -> PostgresMailboxMessageFetchStrategy.toMessageBuilderMetadata().apply((Record)record).content(EMPTY_CONTENT).properties(EMPTY_PROPERTY_BUILDER);
        }
    }

    public static class Full
    implements PostgresMailboxMessageFetchStrategy {
        public static final Field<?>[] FETCH_FIELDS = (Field[])ArrayUtils.addAll((Object[])PostgresMailboxMessageFetchStrategy.fetchFieldsMetadata(), (Object[])new Field[]{PostgresMessageDataDefinition.MessageTable.HEADER_CONTENT, PostgresMessageDataDefinition.MessageTable.TEXTUAL_LINE_COUNT, PostgresMessageDataDefinition.MessageTable.CONTENT_DESCRIPTION, PostgresMessageDataDefinition.MessageTable.CONTENT_LOCATION, PostgresMessageDataDefinition.MessageTable.CONTENT_TRANSFER_ENCODING, PostgresMessageDataDefinition.MessageTable.CONTENT_DISPOSITION_TYPE, PostgresMessageDataDefinition.MessageTable.CONTENT_ID, PostgresMessageDataDefinition.MessageTable.CONTENT_MD5, PostgresMessageDataDefinition.MessageTable.CONTENT_LANGUAGE, PostgresMessageDataDefinition.MessageTable.CONTENT_TYPE_PARAMETERS, PostgresMessageDataDefinition.MessageTable.CONTENT_DISPOSITION_PARAMETERS});

        @Override
        public Field<?>[] fetchFields() {
            return FETCH_FIELDS;
        }

        @Override
        public Function<Record, SimpleMailboxMessage.Builder> toMessageBuilder() {
            return record -> PostgresMailboxMessageFetchStrategy.toMessageBuilderMetadata().apply((Record)record).content(PostgresMailboxMessageDAOUtils.BYTE_TO_CONTENT_FUNCTION.apply((byte[])record.get(PostgresMessageDataDefinition.MessageTable.HEADER_CONTENT))).properties(PostgresMailboxMessageDAOUtils.RECORD_TO_PROPERTIES_FUNCTION.apply((Record)record));
        }
    }
}

