/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.routes;

import eu.timepit.refined.api.Refined;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.apache.commons.fileupload.util.LimitedInputStream;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.api.model.UploadId;
import org.apache.james.jmap.api.model.UploadMetaData;
import org.apache.james.jmap.api.upload.UploadService;
import org.apache.james.jmap.core.AccountId;
import org.apache.james.jmap.core.Id;
import org.apache.james.jmap.core.Id$;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.ProblemDetails;
import org.apache.james.jmap.core.ProblemDetails$;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.json.UploadSerializer;
import org.apache.james.jmap.mail.BlobId;
import org.apache.james.jmap.mail.BlobId$;
import org.apache.james.jmap.method.AccountNotFoundException;
import org.apache.james.jmap.routes.ForbiddenException;
import org.apache.james.jmap.routes.TooBigUploadException;
import org.apache.james.jmap.routes.UploadResponse;
import org.apache.james.jmap.routes.UploadRoutes$;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\tUs!\u0002\u0010 \u0011\u0003Qc!\u0002\u0017 \u0011\u0003i\u0003\"\u0002\u001b\u0002\t\u0003)\u0004b\u0002\u001c\u0002\u0005\u0004%\ta\u000e\u0005\u0007}\u0005\u0001\u000b\u0011\u0002\u001d\u0007\t1z\u0002a\u0010\u0005\t\u0019\u0016\u0011)\u0019!C\u0001\u001b\"AA+\u0002B\u0001B\u0003%a\n\u0003\u0005V\u000b\t\u0015\r\u0011\"\u0001W\u0011!iVA!A!\u0002\u00139\u0006\u0002\u00030\u0006\u0005\u000b\u0007I\u0011A0\t\u0011!,!\u0011!Q\u0001\n\u0001D\u0001\"[\u0003\u0003\u0006\u0004%\tA\u001b\u0005\tc\u0016\u0011\t\u0011)A\u0005W\"A!/\u0002BC\u0002\u0013\u00051\u000f\u0003\u0005x\u000b\t\u0005\t\u0015!\u0003u\u0011\u0015!T\u0001\"\u0001y\u0011%\ty\"\u0002b\u0001\n\u0013\t\t\u0003\u0003\u0005\u0002:\u0015\u0001\u000b\u0011BA\u0012\u0011%\tY$\u0002b\u0001\n\u0013\ti\u0004\u0003\u0005\u0002D\u0015\u0001\u000b\u0011BA \u0011\u0019\u0001S\u0001\"\u0011\u0002F!9\u0011QL\u0003\u0005\u0002\u0005}\u0003bBA/\u000b\u0011\u0005\u0011\u0011\u0014\u0005\b\u0003\u0017,A\u0011BAg\u0011\u001d\tY-\u0002C\u0001\u0003GDq!a@\u0006\t\u0003\u0011\t\u0001C\u0004\u0003\u0016\u0015!IAa\u0006\t\u000f\t%R\u0001\"\u0003\u0003,!9!1I\u0003\u0005\n\t\u0015\u0013\u0001D+qY>\fGMU8vi\u0016\u001c(B\u0001\u0011\"\u0003\u0019\u0011x.\u001e;fg*\u0011!eI\u0001\u0005U6\f\u0007O\u0003\u0002%K\u0005)!.Y7fg*\u0011aeJ\u0001\u0007CB\f7\r[3\u000b\u0003!\n1a\u001c:h\u0007\u0001\u0001\"aK\u0001\u000e\u0003}\u0011A\"\u00169m_\u0006$'k\\;uKN\u001c\"!\u0001\u0018\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!&\u0001\u0004M\u001f\u001e;UIU\u000b\u0002qA\u0011\u0011\bP\u0007\u0002u)\u00111hJ\u0001\u0006g24GG[\u0005\u0003{i\u0012a\u0001T8hO\u0016\u0014\u0018a\u0002'P\u000f\u001e+%\u000bI\n\u0004\u000b\u0001C\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\u000bAA[1wC&\u0011qI\u0011\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005%SU\"A\u0011\n\u0005-\u000b#A\u0003&N\u0003B\u0013v.\u001e;fg\u0006i\u0011-\u001e;iK:$\u0018nY1u_J,\u0012A\u0014\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#\u0006\nA\u0001\u001b;ua&\u00111\u000b\u0015\u0002\u000e\u0003V$\b.\u001a8uS\u000e\fGo\u001c:\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^8sA\u0005i1m\u001c8gS\u001e,(/\u0019;j_:,\u0012a\u0016\t\u00031nk\u0011!\u0017\u0006\u00035\u0006\nAaY8sK&\u0011A,\u0017\u0002\u0019\u00156\f\u0007O\u00154dqY\u0012\u0014gQ8oM&<WO]1uS>t\u0017AD2p]\u001aLw-\u001e:bi&|g\u000eI\u0001\u000ekBdw.\u00193TKJ4\u0018nY3\u0016\u0003\u0001\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\rU\u0004Hn\\1e\u0015\t)\u0017%A\u0002ba&L!a\u001a2\u0003\u001bU\u0003Hn\\1e'\u0016\u0014h/[2f\u00039)\b\u000f\\8bIN+'O^5dK\u0002\n!b]3sS\u0006d\u0017N_3s+\u0005Y\u0007C\u00017p\u001b\u0005i'B\u00018\"\u0003\u0011Q7o\u001c8\n\u0005Al'\u0001E+qY>\fGmU3sS\u0006d\u0017N_3s\u0003-\u0019XM]5bY&TXM\u001d\u0011\u0002#M,7o]5p]R\u0013\u0018M\\:mCR|'/F\u0001u!\tAV/\u0003\u0002w3\n\t2+Z:tS>tGK]1og2\fGo\u001c:\u0002%M,7o]5p]R\u0013\u0018M\\:mCR|'\u000f\t\u000b\u000bsj\fy!!\u0005\u0002\u0014\u0005U\u0001CA\u0016\u0006\u0011\u0015a\u0005\u00031\u0001OQ\u0019QH0!\u0003\u0002\fA\u0019Q0!\u0002\u000e\u0003yT1a`A\u0001\u0003\u0019IgN[3di*\u0011\u00111A\u0001\bU\u0006\\\u0017M\u001d;b\u0013\r\t9A \u0002\u0006\u001d\u0006lW\rZ\u0001\u0006m\u0006dW/Z\u0011\u0003\u0003\u001b\t\u0001B\u0015$D[a2$'\r\u0005\u0006+B\u0001\ra\u0016\u0005\u0006=B\u0001\r\u0001\u0019\u0005\u0006SB\u0001\ra\u001b\u0005\u0006eB\u0001\r\u0001\u001e\u0015\u0004!\u0005e\u0001cA?\u0002\u001c%\u0019\u0011Q\u0004@\u0003\r%s'.Z2u\u00039\t7mY8v]RLE\rU1sC6,\"!a\t\u0011\t\u0005\u0015\u00121\u0007\b\u0005\u0003O\ty\u0003E\u0002\u0002*Aj!!a\u000b\u000b\u0007\u00055\u0012&\u0001\u0004=e>|GOP\u0005\u0004\u0003c\u0001\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00026\u0005]\"AB*ue&twMC\u0002\u00022A\nq\"Y2d_VtG/\u00133QCJ\fW\u000eI\u0001\nkBdw.\u00193V%&+\"!a\u0010\u0011\u0007\u0005\u000b\t%C\u0002\u00026\t\u000b!\"\u001e9m_\u0006$WKU%!)\t\t9\u0005\u0005\u0004\u0002J\u0005M\u0013qK\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u000511\u000f\u001e:fC6T1!!\u0015E\u0003\u0011)H/\u001b7\n\t\u0005U\u00131\n\u0002\u0007'R\u0014X-Y7\u0011\u0007%\u000bI&C\u0002\u0002\\\u0005\u0012\u0011BS'B!J{W\u000f^3\u0002\tA|7\u000f\u001e\u000b\u0007\u0003C\nI(a$\u0011\r\u0005\r\u0014qNA:\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014!\u00039vE2L7\u000f[3s\u0015\rQ\u00161\u000e\u0006\u0003\u0003[\nqA]3bGR|'/\u0003\u0003\u0002r\u0005\u0015$\u0001B'p]>\u00042!QA;\u0013\r\t9H\u0011\u0002\u0005->LG\rC\u0004\u0002|Y\u0001\r!! \u0002\u000fI,\u0017/^3tiB!\u0011qPAF\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015AB:feZ,'OC\u0002R\u0003\u000fSA!!#\u0002l\u0005)a.\u001a;us&!\u0011QRAA\u0005EAE\u000f\u001e9TKJ4XM\u001d*fcV,7\u000f\u001e\u0005\b\u0003#3\u0002\u0019AAJ\u0003!\u0011Xm\u001d9p]N,\u0007\u0003BA@\u0003+KA!a&\u0002\u0002\n\u0011\u0002\n\u001e;q'\u0016\u0014h/\u001a:SKN\u0004xN\\:f))\tY*a*\u0002*\u0006-\u0016q\u0018\t\u0007\u0003;\u000b\u0019+a\u001d\u000e\u0005\u0005}%\u0002BA4\u0003CS1!MA5\u0013\u0011\t)+a(\u0003\u000bMkuN\\8\t\u000f\u0005mt\u00031\u0001\u0002~!9\u0011\u0011S\fA\u0002\u0005M\u0005bBAW/\u0001\u0007\u0011qV\u0001\fG>tG/\u001a8u)f\u0004X\r\u0005\u0003\u00022\u0006mVBAAZ\u0015\u0011\t),a.\u0002\u000b5|G-\u001a7\u000b\u0007\u0005e6%A\u0004nC&d'm\u001c=\n\t\u0005u\u00161\u0017\u0002\f\u0007>tG/\u001a8u)f\u0004X\rC\u0004\u0002B^\u0001\r!a1\u0002\u001d5\f\u0017\u000e\u001c2pqN+7o]5p]B!\u0011QYAd\u001b\t\t9,\u0003\u0003\u0002J\u0006]&AD'bS2\u0014w\u000e_*fgNLwN\\\u0001\u0007Q\u0006tG\r\\3\u0015\u0019\u0005m\u0015qZAi\u0003'\f).!7\t\u000f\u0005m\u0004\u00041\u0001\u0002~!9\u0011\u0011\u0013\rA\u0002\u0005M\u0005bBAW1\u0001\u0007\u0011q\u0016\u0005\b\u0003/D\u0002\u0019AAb\u0003\u001d\u0019Xm]:j_:Dq!a7\u0019\u0001\u0004\ti.A\buCJ<W\r^!dG>,h\u000e^%e!\rA\u0016q\\\u0005\u0004\u0003CL&!C!dG>,h\u000e^%e)1\tY*!:\u0002j\u0006-\u00181`A\u007f\u0011\u001d\t9/\u0007a\u0001\u0003;\f\u0011\"Y2d_VtG/\u00133\t\u000f\u00055\u0016\u00041\u0001\u00020\"9\u0011Q^\rA\u0002\u0005=\u0018aB2p]R,g\u000e\u001e\t\u0005\u0003c\f90\u0004\u0002\u0002t*\u0019\u0011Q\u001f#\u0002\u0005%|\u0017\u0002BA}\u0003g\u00141\"\u00138qkR\u001cFO]3b[\"9\u0011\u0011Y\rA\u0002\u0005\r\u0007bBAI3\u0001\u0007\u00111S\u0001\u000ekBdw.\u00193D_:$XM\u001c;\u0015\u0015\t\r!1\u0002B\u0007\u0005\u001f\u0011\u0019\u0002\u0005\u0004\u0002\u001e\u0006\r&Q\u0001\t\u0004W\t\u001d\u0011b\u0001B\u0005?\tqQ\u000b\u001d7pC\u0012\u0014Vm\u001d9p]N,\u0007bBAt5\u0001\u0007\u0011Q\u001c\u0005\b\u0003[S\u0002\u0019AAX\u0011\u001d\u0011\tB\u0007a\u0001\u0003_\f1\"\u001b8qkR\u001cFO]3b[\"9\u0011q\u001b\u000eA\u0002\u0005\r\u0017A\u00044s_6\fE\u000f^1dQ6,g\u000e\u001e\u000b\u0007\u0005\u000b\u0011IBa\n\t\u000f\tm1\u00041\u0001\u0003\u001e\u0005qQ\u000f\u001d7pC\u0012lU\r^1ECR\f\u0007\u0003\u0002B\u0010\u0005Gi!A!\t\u000b\u0007\u0005UF-\u0003\u0003\u0003&\t\u0005\"AD+qY>\fG-T3uC\u0012\u000bG/\u0019\u0005\b\u0003O\\\u0002\u0019AAo\u0003!\t7O\u00117pE&#G\u0003\u0002B\u0017\u0005s\u0001BAa\f\u000365\u0011!\u0011\u0007\u0006\u0004\u0005g\t\u0013\u0001B7bS2LAAa\u000e\u00032\t1!\t\\8c\u0013\u0012DqAa\u000f\u001d\u0001\u0004\u0011i$\u0001\u0005va2|\u0017\rZ%e!\u0011\u0011yBa\u0010\n\t\t\u0005#\u0011\u0005\u0002\t+Bdw.\u00193JI\u0006q!/Z:q_:$G)\u001a;bS2\u001cHCBAN\u0005\u000f\u0012Y\u0005C\u0004\u0003Ju\u0001\r!a%\u0002%!$H\u000f]*feZ,'OU3ta>t7/\u001a\u0005\b\u0005\u001bj\u0002\u0019\u0001B(\u0003\u001d!W\r^1jYN\u00042\u0001\u0017B)\u0013\r\u0011\u0019&\u0017\u0002\u000f!J|'\r\\3n\t\u0016$\u0018-\u001b7t\u0001")
public class UploadRoutes
implements JMAPRoutes {
    private final Authenticator authenticator;
    private final JmapRfc8621Configuration configuration;
    private final UploadService uploadService;
    private final UploadSerializer serializer;
    private final SessionTranslator sessionTranslator;
    private final String accountIdParam;
    private final String uploadURI;

    public static Logger LOGGER() {
        return UploadRoutes$.MODULE$.LOGGER();
    }

    public Authenticator authenticator() {
        return this.authenticator;
    }

    public JmapRfc8621Configuration configuration() {
        return this.configuration;
    }

    public UploadService uploadService() {
        return this.uploadService;
    }

    public UploadSerializer serializer() {
        return this.serializer;
    }

    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    private String accountIdParam() {
        return this.accountIdParam;
    }

    private String uploadURI() {
        return this.uploadURI;
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of((Object[])new JMAPRoute[]{JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.POST, this.uploadURI())).action((request, response) -> this.post(request, response)).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, this.uploadURI())).action(JMAPRoutes.CORS_CONTROL).noCorsHeaders()});
    }

    public Mono<Void> post(HttpServerRequest request, HttpServerResponse response) {
        String string2;
        String string3 = request.requestHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (string3 != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(string2 = string3))) {
            return SMono$.MODULE$.fromPublisher((Publisher)this.authenticator().authenticate(request)).flatMap((Function1 & Serializable)session -> this.post(request, response, ContentType.of((String)string2), (MailboxSession)session)).onErrorResume((Function1 & Serializable)x0$1 -> {
                Throwable throwable = x0$1;
                if (throwable instanceof UnauthorizedException) {
                    UnauthorizedException unauthorizedException = (UnauthorizedException)throwable;
                    UploadRoutes$.MODULE$.LOGGER().warn("Unauthorized", (Throwable)unauthorizedException);
                    HttpResponseStatus x$1 = HttpResponseStatus.UNAUTHORIZED;
                    String x$2 = unauthorizedException.getMessage();
                    String x$3 = ProblemDetails$.MODULE$.apply$default$1();
                    Option<String> x$4 = ProblemDetails$.MODULE$.apply$default$3();
                    return this.respondDetails(unauthorizedException.addHeaders(response), new ProblemDetails(x$3, x$1, x$4, x$2));
                }
                if (throwable instanceof TooBigUploadException) {
                    HttpResponseStatus x$5 = HttpResponseStatus.BAD_REQUEST;
                    String x$6 = "Attempt to upload exceed max size";
                    String x$7 = ProblemDetails$.MODULE$.apply$default$1();
                    Option<String> x$8 = ProblemDetails$.MODULE$.apply$default$3();
                    return this.respondDetails(response, new ProblemDetails(x$7, x$5, x$8, "Attempt to upload exceed max size"));
                }
                if (throwable instanceof ForbiddenException ? true : throwable instanceof AccountNotFoundException) {
                    HttpResponseStatus x$9 = HttpResponseStatus.FORBIDDEN;
                    String x$10 = "Upload to other accounts is forbidden";
                    String x$11 = ProblemDetails$.MODULE$.apply$default$1();
                    Option<String> x$12 = ProblemDetails$.MODULE$.apply$default$3();
                    return this.respondDetails(response, new ProblemDetails(x$11, x$9, x$12, "Upload to other accounts is forbidden"));
                }
                UploadRoutes$.MODULE$.LOGGER().error("Unexpected error upon upload {}", (Object)request.uri(), (Object)throwable);
                HttpResponseStatus x$13 = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                String x$14 = throwable.getMessage();
                String x$15 = ProblemDetails$.MODULE$.apply$default$1();
                Option<String> x$16 = ProblemDetails$.MODULE$.apply$default$3();
                return this.respondDetails(response, new ProblemDetails(x$15, x$13, x$16, x$14));
            }).asJava().subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).then();
        }
        UploadRoutes$.MODULE$.LOGGER().info("Upload was missing compulsory Content-Type header");
        HttpResponseStatus x$17 = HttpResponseStatus.BAD_REQUEST;
        String x$18 = "Upload is missing compulsory Content-Type header";
        String x$19 = ProblemDetails$.MODULE$.apply$default$1();
        Option<String> x$20 = ProblemDetails$.MODULE$.apply$default$3();
        return this.respondDetails(response, new ProblemDetails(x$19, x$17, x$20, "Upload is missing compulsory Content-Type header")).asJava();
    }

    public SMono<Void> post(HttpServerRequest request, HttpServerResponse response, ContentType contentType, MailboxSession mailboxSession) {
        Left left;
        IllegalArgumentException throwable;
        Right right;
        String id;
        Either<IllegalArgumentException, Refined<String, Id.IdConstraint>> either = Id$.MODULE$.validate(request.param((CharSequence)this.accountIdParam()));
        if (either instanceof Right && new Refined((Object)(id = (String)((Refined)(right = (Right)either).value()).value())) instanceof Refined) {
            String string2 = id;
            AccountId targetAccountId = new AccountId(string2);
            return this.sessionTranslator().delegateIfNeeded(mailboxSession, targetAccountId).flatMap((Function1 & Serializable)session -> this.handle(request, response, contentType, (MailboxSession)session, targetAccountId));
        }
        if (either instanceof Left && (throwable = (IllegalArgumentException)(left = (Left)either).value()) != null) {
            IllegalArgumentException illegalArgumentException = throwable;
            return SMono$.MODULE$.error((Throwable)illegalArgumentException);
        }
        throw new MatchError(either);
    }

    private SMono<Void> handle(HttpServerRequest request, HttpServerResponse response, ContentType contentType, MailboxSession session, AccountId targetAccountId) {
        return SMono$.MODULE$.fromCallable(() -> ReactorUtils.toInputStream((Flux)request.receive().asByteArray().map(array -> ByteBuffer.wrap(array)))).flatMap((Function1 & Serializable)content -> this.handle(targetAccountId, contentType, (InputStream)content, session, response));
    }

    public SMono<Void> handle(AccountId accountId, ContentType contentType, InputStream content, MailboxSession mailboxSession, HttpServerResponse response) {
        long maxSize = BoxesRunTime.unboxToLong((Object)this.configuration().maxUploadSize().value());
        return SMono$.MODULE$.fromCallable(() -> new LimitedInputStream(null, content, maxSize){

            public void raiseError(long max, long count) {
                if (count > max) {
                    throw new TooBigUploadException();
                }
            }
        }).flatMap((Function1 & Serializable)x$1 -> this.uploadContent(accountId, contentType, (InputStream)x$1, mailboxSession)).flatMap((Function1 & Serializable)uploadResponse -> {
            JsValue jsonValue = this.serializer().serialize((UploadResponse)uploadResponse);
            String json = Json$.MODULE$.stringify(jsonValue);
            byte[] bytes = json.getBytes(StandardCharsets.UTF_8);
            return SMono$.MODULE$.fromPublisher((Publisher)response.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(bytes.length)).status(HttpResponseStatus.CREATED).sendByteArray((Publisher)SMono$.MODULE$.just((Object)bytes)));
        });
    }

    public SMono<UploadResponse> uploadContent(AccountId accountId, ContentType contentType, InputStream inputStream, MailboxSession session) {
        return SMono$.MODULE$.fromPublisher(this.uploadService().upload(inputStream, contentType, session.getUser())).map((Function1 & Serializable)x$2 -> this.fromAttachment((UploadMetaData)x$2, accountId));
    }

    private UploadResponse fromAttachment(UploadMetaData uploadMetaData, AccountId accountId) {
        BlobId x$1 = this.asBlobId(uploadMetaData.uploadId());
        ContentType x$2 = uploadMetaData.contentType();
        Long x$3 = uploadMetaData.size();
        AccountId x$4 = accountId;
        return new UploadResponse(x$4, x$1, x$2, x$3);
    }

    private BlobId asBlobId(UploadId uploadId) {
        return (BlobId)BlobId$.MODULE$.of("uploads-" + uploadId.asString()).get();
    }

    private SMono<Void> respondDetails(HttpServerResponse httpServerResponse, ProblemDetails details) {
        return SMono$.MODULE$.fromCallable(() -> ResponseSerializer$.MODULE$.serialize(details).toString()).map((Function1 & Serializable)x$3 -> x$3.getBytes(StandardCharsets.UTF_8)).flatMap((Function1 & Serializable)bytes -> SMono$.MODULE$.fromPublisher((Publisher)httpServerResponse.status(details.status()).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])bytes).length)).sendByteArray((Publisher)SMono$.MODULE$.just(bytes)).then()));
    }

    @Inject
    public UploadRoutes(@Named(value="RFC-8621") Authenticator authenticator, JmapRfc8621Configuration configuration, UploadService uploadService, UploadSerializer serializer, SessionTranslator sessionTranslator) {
        this.authenticator = authenticator;
        this.configuration = configuration;
        this.uploadService = uploadService;
        this.serializer = serializer;
        this.sessionTranslator = sessionTranslator;
        this.accountIdParam = "accountId";
        this.uploadURI = "/upload/{" + this.accountIdParam() + "}";
    }
}

