/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import jakarta.mail.MessagingException;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.apache.james.core.MailAddress;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class SplitMail
extends GenericMailet {
    private static final int DEFAULT_BATCH_SIZE = 100;
    private int batchSize;

    public void init() throws MessagingException {
        this.batchSize = Integer.parseInt(Optional.ofNullable(this.getInitParameter("batchSize")).orElse(String.valueOf(100)));
    }

    public void service(Mail mail) throws MessagingException {
        if (mail.getRecipients().stream().count() > (long)this.batchSize) {
            Flux.fromIterable((Iterable)mail.getRecipients()).window(this.batchSize).index().flatMap(this.sendMail(mail)).then().block();
        }
    }

    private Function<Tuple2<Long, Flux<MailAddress>>, Publisher<Void>> sendMail(Mail mail) {
        return tuple -> {
            boolean firstBatch;
            boolean bl = firstBatch = (Long)tuple.getT1() == 0L;
            if (firstBatch) {
                return this.sendMailToFirstRecipientsBatchDirectly(mail, (Flux<MailAddress>)((Flux)tuple.getT2()));
            }
            return this.sendMailToRemainingRecipientsBatchAsynchronously(mail, (Flux<MailAddress>)((Flux)tuple.getT2()));
        };
    }

    private Mono<Void> sendMailToFirstRecipientsBatchDirectly(Mail mail, Flux<MailAddress> firstRecipientsBatch) {
        return firstRecipientsBatch.collectList().flatMap(recipients -> Mono.fromRunnable(() -> mail.setRecipients((Collection)recipients))).then();
    }

    private Mono<Void> sendMailToRemainingRecipientsBatchAsynchronously(Mail mail, Flux<MailAddress> remainingRecipientsBatch) {
        return remainingRecipientsBatch.collectList().flatMap(recipients -> Mono.fromRunnable((Runnable)Throwing.runnable(() -> {
            Mail duplicateMail = mail.duplicate();
            try {
                duplicateMail.setRecipients((Collection)recipients);
                this.getMailetContext().sendMail(duplicateMail);
            }
            finally {
                LifecycleUtil.dispose((Object)duplicateMail);
            }
        }))).then();
    }

    public String getMailetName() {
        return "SplitMail";
    }
}

