/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.blob.deduplication;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import com.google.common.io.FileBackedOutputStream;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.BlobStoreDAO;
import org.apache.james.blob.api.BucketName;
import org.apache.james.server.blob.deduplication.DeDuplicationBlobStore$;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuples;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Tuple2;
import scala.compat.java8.FunctionConverters.package$;
import scala.compat.java8.functionConverterImpls.RichFunction1AsConsumer$;
import scala.compat.java8.functionConverterImpls.RichFunction1AsFunction$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tms!B\u0014)\u0011\u0003)d!B\u001c)\u0011\u0003A\u0004\"B \u0002\t\u0003\u0001\u0005bB!\u0002\u0005\u0004%\tA\u0011\u0005\u0007\r\u0006\u0001\u000b\u0011B\"\t\u000f\u001d\u000b!\u0019!C\u0001\u0011\"1A*\u0001Q\u0001\n%Cq!T\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004O\u0003\u0001\u0006I!\u0013\u0005\u0006\u001f\u0006!I\u0001\u0015\u0004\u0005o!\u0002!\u000e\u0003\u0005{\u0015\t\u0005\t\u0015!\u0003|\u0011!q(B!A!\u0002\u0013y\bBCA\u000f\u0015\t\u0005\t\u0015!\u0003\u0002 !1qH\u0003C\u0001\u0003[A\u0011\"!\u0011\u000b\u0005\u0004%I!a\u0011\t\u0011\u0005%#\u0002)A\u0005\u0003\u000bB\u0011\"a\u0013\u000b\u0005\u0004%I!!\u0014\t\u000f\u0005=#\u0002)A\u0005#\"I\u0011\u0011\u000b\u0006C\u0002\u0013%\u0011Q\n\u0005\b\u0003'R\u0001\u0015!\u0003R\u0011\u001d\t)F\u0003C!\u0003/Bq!!\u0016\u000b\t\u0003\n\t\nC\u0004\u0002V)!\t%a)\t\u000f\u0005U#\u0002\"\u0011\u00022\"9\u0011Q\u000b\u0006\u0005B\u0005e\u0007bBAs\u0015\u0011%\u0011q\u001d\u0005\b\u0003WTA\u0011BAw\u0011\u001d\tyO\u0003C\u0005\u0003cDq!a=\u000b\t\u0013\t)\u0010C\u0004\u0002V)!\tEa\u0002\t\u000f\tE!\u0002\"\u0011\u0003\u0014!9!Q\u0004\u0006\u0005B\t}\u0001b\u0002B\u0013\u0015\u0011\u0005#q\u0005\u0005\b\u0005_QA\u0011\tB\u0019\u0011\u001d\u0011\u0019D\u0003C!\u0005kAqA!\u0011\u000b\t\u0003\u0012\u0019\u0005C\u0004\u0003P)!\tE!\u0015\t\u000f\tU#\u0002\"\u0011\u0003X\u00051B)\u001a#va2L7-\u0019;j_:\u0014En\u001c2Ti>\u0014XM\u0003\u0002*U\u0005iA-\u001a3va2L7-\u0019;j_:T!a\u000b\u0017\u0002\t\tdwN\u0019\u0006\u0003[9\naa]3sm\u0016\u0014(BA\u00181\u0003\u0015Q\u0017-\\3t\u0015\t\t$'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002g\u0005\u0019qN]4\u0004\u0001A\u0011a'A\u0007\u0002Q\t1B)\u001a#va2L7-\u0019;j_:\u0014En\u001c2Ti>\u0014Xm\u0005\u0002\u0002sA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001b\u0002+1\u000b%,W0S\u000bN{UKU\"F?\u000ecU)\u0011(V!V\t1\t\u0005\u0002;\t&\u0011Qi\u000f\u0002\b\u0005>|G.Z1o\u0003Ya\u0015IW-`%\u0016\u001bv*\u0016*D\u000b~\u001bE*R!O+B\u0003\u0013A\u0004$J\u0019\u0016{F\u000b\u0013*F'\"{E\nR\u000b\u0002\u0013B\u0011!HS\u0005\u0003\u0017n\u00121!\u00138u\u0003=1\u0015\nT#`)\"\u0013Vi\u0015%P\u0019\u0012\u0003\u0013a\u0006+I%\u0016\u000bEiX*X\u0013R\u001b\u0005j\u0018+I%\u0016\u001b\u0006j\u0014'E\u0003a!\u0006JU#B\t~\u001bv+\u0013+D\u0011~#\u0006JU#T\u0011>cE\tI\u0001\u0011E\u0006\u001cX-\u00128d_\u0012Lgn\u001a$s_6$\"!U/\u0011\u0005I[V\"A*\u000b\u0005Q+\u0016AA5p\u0015\t1v+\u0001\u0004d_6lwN\u001c\u0006\u00031f\u000baaZ8pO2,'\"\u0001.\u0002\u0007\r|W.\u0003\u0002]'\na!)Y:f\u000b:\u001cw\u000eZ5oO\")a,\u0003a\u0001?\u0006aQM\\2pI&tw\rV=qKB\u0011\u0001m\u001a\b\u0003C\u0016\u0004\"AY\u001e\u000e\u0003\rT!\u0001\u001a\u001b\u0002\rq\u0012xn\u001c;?\u0013\t17(\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u0014aa\u0015;sS:<'B\u00014<'\rQ1n\u001d\t\u0003YFl\u0011!\u001c\u0006\u0003]>\fA\u0001\\1oO*\t\u0001/\u0001\u0003kCZ\f\u0017B\u0001:n\u0005\u0019y%M[3diB\u0011A\u000f_\u0007\u0002k*\u0011ao^\u0001\u0004CBL'BA\u0016/\u0013\tIXOA\u0005CY>\u00147\u000b^8sK\u0006a!\r\\8c'R|'/\u001a#B\u001fB\u0011A\u000f`\u0005\u0003{V\u0014AB\u00117pEN#xN]3E\u0003>\u000b\u0011\u0003Z3gCVdGOQ;dW\u0016$h*Y7f!\r!\u0018\u0011A\u0005\u0004\u0003\u0007)(A\u0003\"vG.,GOT1nK\":A\"a\u0002\u0002\u0018\u0005e\u0001\u0003BA\u0005\u0003'i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0007S:TWm\u0019;\u000b\u0005\u0005E\u0011a\u00026bW\u0006\u0014H/Y\u0005\u0005\u0003+\tYAA\u0003OC6,G-A\u0003wC2,X-\t\u0002\u0002\u001c\u0005iA-\u001a4bk2$()^2lKR\fQB\u00197pE&#g)Y2u_JL\b\u0003BA\u0011\u0003Oq1\u0001^A\u0012\u0013\r\t)#^\u0001\u0007\u00052|'-\u00133\n\t\u0005%\u00121\u0006\u0002\b\r\u0006\u001cGo\u001c:z\u0015\r\t)#\u001e\u000b\t\u0003_\t\t$a\r\u00028A\u0011aG\u0003\u0005\u0006u:\u0001\ra\u001f\u0005\u0006}:\u0001\ra \u0015\t\u0003g\t9!a\u0006\u0002\u001a!9\u0011Q\u0004\bA\u0002\u0005}\u0001f\u0001\b\u0002<A!\u0011\u0011BA\u001f\u0013\u0011\ty$a\u0003\u0003\r%s'.Z2u\u0003\rB\u0015i\u0015%`\u00052{%iX%E?\u0016s5i\u0014#J\u001d\u001e{F+\u0017)F?B\u0013v\nU#S)f+\"!!\u0012\u0011\u00071\f9%\u0003\u0002i[\u0006!\u0003*Q*I?\ncuJQ0J\t~+ejQ(E\u0013:;u\fV-Q\u000b~\u0003&k\u0014)F%RK\u0006%A\u000fI\u0003NCuL\u0011'P\u0005~KEiX#O\u0007>#\u0015JT$`\t\u00163\u0015)\u0016'U+\u0005\t\u0016A\b%B'\"{&\tT(C?&#u,\u0012(D\u001f\u0012KejR0E\u000b\u001a\u000bU\u000b\u0014+!\u00031\u0011\u0017m]3F]\u000e|G-\u001b8h\u00035\u0011\u0017m]3F]\u000e|G-\u001b8hA\u0005!1/\u0019<f)!\tI&a\u001b\u0002p\u0005}\u0004CBA.\u0003C\n)'\u0004\u0002\u0002^)\u0019\u0011q\f\u001a\u0002\u001fI,\u0017m\u0019;jm\u0016\u001cHO]3b[NLA!a\u0019\u0002^\tI\u0001+\u001e2mSNDWM\u001d\t\u0004i\u0006\u001d\u0014bAA5k\n1!\t\\8c\u0013\u0012Da!!\u001c\u0016\u0001\u0004y\u0018A\u00032vG.,GOT1nK\"9\u0011\u0011O\u000bA\u0002\u0005M\u0014\u0001\u00023bi\u0006\u0004RAOA;\u0003sJ1!a\u001e<\u0005\u0015\t%O]1z!\rQ\u00141P\u0005\u0004\u0003{Z$\u0001\u0002\"zi\u0016Dq!!!\u0016\u0001\u0004\t\u0019)A\u0007ti>\u0014\u0018mZ3Q_2L7-\u001f\t\u0005\u0003\u000b\u000bYID\u0002u\u0003\u000fK1!!#v\u0003%\u0011En\u001c2Ti>\u0014X-\u0003\u0003\u0002\u000e\u0006=%!D*u_J\fw-\u001a)pY&\u001c\u0017PC\u0002\u0002\nV$\u0002\"!\u0017\u0002\u0014\u0006U\u0015\u0011\u0015\u0005\u0007\u0003[2\u0002\u0019A@\t\u000f\u0005Ed\u00031\u0001\u0002\u0018B!\u0011\u0011TAO\u001b\t\tYJ\u0003\u0002U_&!\u0011qTAN\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000f\u0005\u0005e\u00031\u0001\u0002\u0004RA\u0011\u0011LAS\u0003O\u000by\u000b\u0003\u0004\u0002n]\u0001\ra \u0005\b\u0003c:\u0002\u0019AAU!\r\u0011\u00161V\u0005\u0004\u0003[\u001b&A\u0003\"zi\u0016\u001cv.\u001e:dK\"9\u0011\u0011Q\fA\u0002\u0005\rECCA-\u0003g\u000b),a.\u0002X\"1\u0011Q\u000e\rA\u0002}Dq!!\u001d\u0019\u0001\u0004\t\u0019\bC\u0004\u0002:b\u0001\r!a/\u0002\u001d\tdwNY%e!J|g/\u001b3feB1\u0011QXAj\u0003grA!a0\u0002\b:!\u0011\u0011YAi\u001d\u0011\t\u0019-a4\u000f\t\u0005\u0015\u0017Q\u001a\b\u0005\u0003\u000f\fYMD\u0002c\u0003\u0013L\u0011aM\u0005\u0003cIJ!a\f\u0019\n\u0005-r\u0013B\u0001<x\u0013\u0011\t).a$\u0003\u001d\tcwNY%e!J|g/\u001b3fe\"9\u0011\u0011\u0011\rA\u0002\u0005\rECCA-\u00037\fi.a8\u0002d\"1\u0011QN\rA\u0002}Dq!!\u001d\u001a\u0001\u0004\tI\u000bC\u0004\u0002:f\u0001\r!!9\u0011\r\u0005u\u00161[AU\u0011\u001d\t\t)\u0007a\u0001\u0003\u0007\u000b!b^5uQ\ncwNY%e+\t\tI\u000f\u0005\u0004\u0002>\u0006M\u0017qS\u0001\u0019o&$\bN\u00117pE&#gI]8n\u0005f$XmU8ve\u000e,WCAAq\u0003M9\u0018\u000e\u001e5CY>\u0014\u0017\n\u001a$s_6\f%O]1z+\t\tY,\u0001\u0004cCN,g\u0007\u000e\u000b\u0005\u0003\u000b\n9\u0010C\u0004\u0002zv\u0001\r!a?\u0002\u0011!\f7\u000f[\"pI\u0016\u0004B!!@\u0003\u00045\u0011\u0011q \u0006\u0004\u0005\u0003)\u0016\u0001\u00025bg\"LAA!\u0002\u0002\u0000\nA\u0001*Y:i\u0007>$W\r\u0006\u0006\u0002Z\t%!1\u0002B\u0007\u0005\u001fAa!!\u001c\u001f\u0001\u0004y\bbBA9=\u0001\u0007\u0011q\u0013\u0005\b\u0003ss\u0002\u0019AAu\u0011\u001d\t\tI\ba\u0001\u0003\u0007\u000b\u0011B]3bI\nKH/Z:\u0015\r\tU!q\u0003B\r!\u0019\tY&!\u0019\u0002t!1\u0011QN\u0010A\u0002}DqAa\u0007 \u0001\u0004\t)'\u0001\u0004cY>\u0014\u0017\nZ\u0001\u0005e\u0016\fG\r\u0006\u0004\u0002\u0018\n\u0005\"1\u0005\u0005\u0007\u0003[\u0002\u0003\u0019A@\t\u000f\tm\u0001\u00051\u0001\u0002f\u0005a!/Z1e%\u0016\f7\r^5wKR1!\u0011\u0006B\u0016\u0005[\u0001b!a\u0017\u0002b\u0005]\u0005BBA7C\u0001\u0007q\u0010C\u0004\u0003\u001c\u0005\u0002\r!!\u001a\u0002)\u001d,G\u000fR3gCVdGOQ;dW\u0016$h*Y7f)\u0005y\u0018\u0001\u00043fY\u0016$XMQ;dW\u0016$H\u0003\u0002B\u001c\u0005\u007f\u0001b!a\u0017\u0002b\te\u0002c\u00017\u0003<%\u0019!QH7\u0003\tY{\u0017\u000e\u001a\u0005\u0007\u0003[\u001a\u0003\u0019A@\u0002\r\u0011,G.\u001a;f)\u0019\u0011)Ea\u0013\u0003NA1\u00111LA1\u0005\u000f\u00022\u0001\u001cB%\u0013\t)U\u000e\u0003\u0004\u0002n\u0011\u0002\ra \u0005\b\u00057!\u0003\u0019AA3\u0003-a\u0017n\u001d;Ck\u000e\\W\r^:\u0015\u0005\tM\u0003#BA.\u0003Cz\u0018!\u00037jgR\u0014En\u001c2t)\u0011\tIF!\u0017\t\r\u00055d\u00051\u0001\u0000\u0001")
public class DeDuplicationBlobStore
implements BlobStore {
    private final BlobStoreDAO blobStoreDAO;
    @Named(value="defaultBucket")
    private final BucketName defaultBucketName;
    private final BlobId.Factory blobIdFactory;
    private final String HASH_BLOB_ID_ENCODING_TYPE_PROPERTY;
    private final BaseEncoding HASH_BLOB_ID_ENCODING_DEFAULT;
    private final BaseEncoding baseEncoding;

    public static int THREAD_SWITCH_THRESHOLD() {
        return DeDuplicationBlobStore$.MODULE$.THREAD_SWITCH_THRESHOLD();
    }

    public static int FILE_THRESHOLD() {
        return DeDuplicationBlobStore$.MODULE$.FILE_THRESHOLD();
    }

    public static boolean LAZY_RESOURCE_CLEANUP() {
        return DeDuplicationBlobStore$.MODULE$.LAZY_RESOURCE_CLEANUP();
    }

    public Publisher<BlobId> save(BucketName bucketName, String data, BlobStore.StoragePolicy storagePolicy) {
        return super.save(bucketName, data, storagePolicy);
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return super.readBytes(bucketName, blobId, storagePolicy);
    }

    public InputStream read(BucketName bucketName, BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return super.read(bucketName, blobId, storagePolicy);
    }

    public Publisher<InputStream> readReactive(BucketName bucketName, BlobId blobId, BlobStore.StoragePolicy storagePolicy) {
        return super.readReactive(bucketName, blobId, storagePolicy);
    }

    private String HASH_BLOB_ID_ENCODING_TYPE_PROPERTY() {
        return this.HASH_BLOB_ID_ENCODING_TYPE_PROPERTY;
    }

    private BaseEncoding HASH_BLOB_ID_ENCODING_DEFAULT() {
        return this.HASH_BLOB_ID_ENCODING_DEFAULT;
    }

    private BaseEncoding baseEncoding() {
        return this.baseEncoding;
    }

    public Publisher<BlobId> save(BucketName bucketName, byte[] data, BlobStore.StoragePolicy storagePolicy) {
        return this.save(bucketName, data, this.withBlobIdFromArray(), storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, InputStream data, BlobStore.StoragePolicy storagePolicy) {
        return this.save(bucketName, data, this.withBlobId(), storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, ByteSource data, BlobStore.StoragePolicy storagePolicy) {
        return this.save(bucketName, data, this.withBlobIdFromByteSource(), storagePolicy);
    }

    public Publisher<BlobId> save(BucketName bucketName, byte[] data, BlobStore.BlobIdProvider<byte[]> blobIdProvider, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        return SMono$.MODULE$.apply(blobIdProvider.apply((Object)data)).map((Function1 & Serializable)x$1 -> (BlobId)x$1.getT1()).flatMap((Function1 & Serializable)blobId -> SMono$.MODULE$.apply($this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just(blobId)));
    }

    public Publisher<BlobId> save(BucketName bucketName, ByteSource data, BlobStore.BlobIdProvider<ByteSource> blobIdProvider, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        return SMono$.MODULE$.apply(blobIdProvider.apply((Object)data)).map((Function1 & Serializable)x$2 -> (BlobId)x$2.getT1()).flatMap((Function1 & Serializable)blobId -> SMono$.MODULE$.apply($this.blobStoreDAO.save(bucketName, blobId, data)).then(SMono$.MODULE$.just(blobId))).subscribeOn(Schedulers.boundedElastic());
    }

    private BlobStore.BlobIdProvider<InputStream> withBlobId() {
        return data -> {
            HashingInputStream hashingInputStream = new HashingInputStream(Hashing.sha256(), data);
            Callable<FileBackedOutputStream> ressourceSupplier = () -> new FileBackedOutputStream(DeDuplicationBlobStore$.MODULE$.FILE_THRESHOLD());
            Function1 & Serializable sourceSupplier = (Function1 & Serializable)fileBackedOutputStream -> SMono$.MODULE$.fromCallable(() -> {
                IOUtils.copy((InputStream)hashingInputStream, (OutputStream)fileBackedOutputStream);
                return new Tuple2((Object)$this.blobIdFactory.of(this.base64(hashingInputStream.hash())), (Object)fileBackedOutputStream.asByteSource().openStream());
            }).asJava();
            return Mono.using(ressourceSupplier, (Function)RichFunction1AsFunction$.MODULE$.asJava$extension(package$.MODULE$.enrichAsJavaFunction((Function1)sourceSupplier)), (Consumer)RichFunction1AsConsumer$.MODULE$.asJava$extension(package$.MODULE$.enrichAsJavaConsumer((Function1 & Serializable)fileBackedOutputStream -> {
                fileBackedOutputStream.reset();
                return BoxedUnit.UNIT;
            })), (boolean)DeDuplicationBlobStore$.MODULE$.LAZY_RESOURCE_CLEANUP()).subscribeOn(Schedulers.boundedElastic()).map(x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    BlobId blobId = (BlobId)tuple2._1();
                    InputStream data = (InputStream)tuple2._2();
                    return Tuples.of((Object)blobId, (Object)data);
                }
                throw new MatchError((Object)tuple2);
            });
        };
    }

    private BlobStore.BlobIdProvider<ByteSource> withBlobIdFromByteSource() {
        return data -> Mono.fromCallable(() -> data.hash(Hashing.sha256())).subscribeOn(Schedulers.boundedElastic()).map(hashCode -> this.base64((HashCode)hashCode)).map(id -> $this.blobIdFactory.of(id)).map(blobId -> Tuples.of((Object)blobId, (Object)data));
    }

    private BlobStore.BlobIdProvider<byte[]> withBlobIdFromArray() {
        return data -> {
            if (((byte[])data).length < DeDuplicationBlobStore$.MODULE$.THREAD_SWITCH_THRESHOLD()) {
                HashCode code = Hashing.sha256().hashBytes(data);
                BlobId blobId = $this.blobIdFactory.of(this.base64(code));
                return Mono.just((Object)Tuples.of((Object)blobId, (Object)data));
            }
            return SMono$.MODULE$.fromCallable(() -> {
                HashCode code = Hashing.sha256().hashBytes(data);
                BlobId blobId = $this.blobIdFactory.of(this.base64(code));
                return Tuples.of((Object)blobId, (Object)data);
            });
        };
    }

    private String base64(HashCode hashCode) {
        byte[] bytes = hashCode.asBytes();
        return this.baseEncoding().encode(bytes);
    }

    public Publisher<BlobId> save(BucketName bucketName, InputStream data, BlobStore.BlobIdProvider<InputStream> blobIdProvider, BlobStore.StoragePolicy storagePolicy) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)data);
        return Mono.from((Publisher)blobIdProvider.apply((Object)data)).subscribeOn(Schedulers.boundedElastic()).flatMap(tuple -> SMono$.MODULE$.apply($this.blobStoreDAO.save(bucketName, (BlobId)tuple.getT1(), (InputStream)tuple.getT2())).then(SMono$.MODULE$.just(tuple.getT1())).asJava());
    }

    public Publisher<byte[]> readBytes(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readBytes(bucketName, blobId);
    }

    public InputStream read(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.read(bucketName, blobId);
    }

    public Publisher<InputStream> readReactive(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        return this.blobStoreDAO.readReactive(bucketName, blobId);
    }

    public BucketName getDefaultBucketName() {
        return this.defaultBucketName;
    }

    public Publisher<Void> deleteBucket(BucketName bucketName) {
        return this.blobStoreDAO.deleteBucket(bucketName);
    }

    public Publisher<Boolean> delete(BucketName bucketName, BlobId blobId) {
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)blobId);
        return SMono$.MODULE$.just((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public Publisher<BucketName> listBuckets() {
        return Flux.concat((Publisher[])new Publisher[]{this.blobStoreDAO.listBuckets(), Flux.just((Object)this.defaultBucketName)}).distinct();
    }

    public Publisher<BlobId> listBlobs(BucketName bucketName) {
        return this.blobStoreDAO.listBlobs(bucketName);
    }

    @Inject
    public DeDuplicationBlobStore(BlobStoreDAO blobStoreDAO, @Named(value="defaultBucket") BucketName defaultBucketName, BlobId.Factory blobIdFactory) {
        this.blobStoreDAO = blobStoreDAO;
        this.defaultBucketName = defaultBucketName;
        this.blobIdFactory = blobIdFactory;
        this.HASH_BLOB_ID_ENCODING_TYPE_PROPERTY = "james.blob.id.hash.encoding";
        this.HASH_BLOB_ID_ENCODING_DEFAULT = BaseEncoding.base64Url();
        this.baseEncoding = (BaseEncoding)Option$.MODULE$.apply((Object)System.getProperty(this.HASH_BLOB_ID_ENCODING_TYPE_PROPERTY())).map((Function1 & Serializable)encodingType -> DeDuplicationBlobStore$.MODULE$.org$apache$james$server$blob$deduplication$DeDuplicationBlobStore$$baseEncodingFrom((String)encodingType)).getOrElse((Function0 & Serializable)() -> this.HASH_BLOB_ID_ENCODING_DEFAULT());
    }
}

