/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.table.CassandraACLV2Table;
import org.apache.james.mailbox.model.MailboxACL;
import reactor.core.publisher.Mono;

public class CassandraACLDAOV2 {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement insertRights;
    private final PreparedStatement removeRights;
    private final PreparedStatement replaceRights;
    private final PreparedStatement delete;
    private final PreparedStatement read;

    @Inject
    public CassandraACLDAOV2(CqlSession session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.insertRights = this.prepareInsertRights(session);
        this.removeRights = this.prepareRemoveRights(session);
        this.replaceRights = this.prepareReplaceRights(session);
        this.read = this.prepareRead(session);
        this.delete = this.prepareDelete(session);
    }

    private PreparedStatement prepareDelete(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"aclv2").where((Relation)Relation.column((CqlIdentifier)CassandraACLV2Table.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLV2Table.ID)))).build());
    }

    private PreparedStatement prepareInsertRights(CqlSession session) {
        return session.prepare(((Update)QueryBuilder.update((String)"aclv2").append(CassandraACLV2Table.RIGHTS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLV2Table.RIGHTS)).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraACLV2Table.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLV2Table.ID)), (Relation)Relation.column((CqlIdentifier)CassandraACLV2Table.KEY).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLV2Table.KEY))})).build());
    }

    private PreparedStatement prepareReplaceRights(CqlSession session) {
        return session.prepare(((Update)QueryBuilder.update((String)"aclv2").setColumn(CassandraACLV2Table.RIGHTS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLV2Table.RIGHTS)).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraACLV2Table.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLV2Table.ID)), (Relation)Relation.column((CqlIdentifier)CassandraACLV2Table.KEY).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLV2Table.KEY))})).build());
    }

    private PreparedStatement prepareRemoveRights(CqlSession session) {
        return session.prepare(((Update)QueryBuilder.update((String)"aclv2").remove(CassandraACLV2Table.RIGHTS, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLV2Table.RIGHTS)).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraACLV2Table.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLV2Table.ID)), (Relation)Relation.column((CqlIdentifier)CassandraACLV2Table.KEY).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLV2Table.KEY))})).build());
    }

    private PreparedStatement prepareRead(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"aclv2").all().where((Relation)Relation.column((CqlIdentifier)CassandraACLV2Table.ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraACLV2Table.ID)))).build());
    }

    public Mono<Void> delete(CassandraId cassandraId) {
        return this.executor.executeVoid((Statement)this.delete.bind(new Object[0]).setUuid(CassandraACLV2Table.ID, cassandraId.asUuid()));
    }

    public Mono<MailboxACL> getACL(CassandraId cassandraId) {
        return this.executor.executeRows((Statement)this.read.bind(new Object[0]).set(CassandraACLV2Table.ID, (Object)cassandraId.asUuid(), TypeCodecs.TIMEUUID)).map((Function)Throwing.function(row -> {
            MailboxACL.EntryKey entryKey = MailboxACL.EntryKey.deserialize((String)row.getString(CassandraACLV2Table.KEY));
            MailboxACL.Rfc4314Rights rights = row.getSet(CassandraACLV2Table.RIGHTS, String.class).stream().map(Throwing.function(MailboxACL.Rfc4314Rights::deserialize)).reduce(MailboxACL.NO_RIGHTS, Throwing.binaryOperator(MailboxACL.Rfc4314Rights::union));
            return new MailboxACL((Map)ImmutableMap.of((Object)entryKey, (Object)rights));
        })).reduce((BiFunction)Throwing.biFunction(MailboxACL::union));
    }

    public Mono<Void> updateACL(CassandraId cassandraId, MailboxACL.ACLCommand command) {
        ImmutableSet<String> rightStrings = this.asStringSet(command.getRights());
        switch (command.getEditMode()) {
            case ADD: {
                return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.insertRights.bind(new Object[0]).setUuid(CassandraACLV2Table.ID, cassandraId.asUuid())).setString(CassandraACLV2Table.KEY, command.getEntryKey().serialize())).setSet(CassandraACLV2Table.RIGHTS, (Set)ImmutableSet.copyOf(rightStrings), String.class));
            }
            case REMOVE: {
                return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.removeRights.bind(new Object[0]).setUuid(CassandraACLV2Table.ID, cassandraId.asUuid())).setString(CassandraACLV2Table.KEY, command.getEntryKey().serialize())).setSet(CassandraACLV2Table.RIGHTS, (Set)ImmutableSet.copyOf(rightStrings), String.class));
            }
            case REPLACE: {
                return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.replaceRights.bind(new Object[0]).setUuid(CassandraACLV2Table.ID, cassandraId.asUuid())).setString(CassandraACLV2Table.KEY, command.getEntryKey().serialize())).setSet(CassandraACLV2Table.RIGHTS, rightStrings, String.class));
            }
        }
        throw new NotImplementedException(String.valueOf(command.getEditMode()) + "is not supported");
    }

    private ImmutableSet<String> asStringSet(MailboxACL.Rfc4314Rights rights) {
        return (ImmutableSet)rights.list().stream().map(MailboxACL.Right::asCharacter).map(String::valueOf).collect(ImmutableSet.toImmutableSet());
    }
}

