/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.eventsourcing.acl;

import org.apache.james.event.acl.ACLUpdated;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventWithState;
import org.apache.james.eventsourcing.ReactiveSubscriber;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.mail.CassandraUserMailboxRightsDAO;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class UserRightsDAOSubscriber
implements ReactiveSubscriber {
    private final CassandraUserMailboxRightsDAO userRightsDAO;

    public UserRightsDAOSubscriber(CassandraUserMailboxRightsDAO userRightsDAO) {
        this.userRightsDAO = userRightsDAO;
    }

    public Publisher<Void> handleReactive(EventWithState eventWithState) {
        Event event = eventWithState.event();
        if (event instanceof ACLUpdated) {
            ACLUpdated aclUpdated = (ACLUpdated)event;
            return this.userRightsDAO.update((CassandraId)aclUpdated.mailboxId(), aclUpdated.getAclDiff());
        }
        return Mono.empty();
    }
}

