/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail.task;

import com.google.common.collect.ImmutableList;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.mailbox.cassandra.mail.task.ConflictingEntry;
import org.apache.james.mailbox.cassandra.mail.task.SolveMailboxInconsistenciesService;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolveMailboxInconsistenciesTask
implements Task {
    static final TaskType SOLVE_MAILBOX_INCONSISTENCIES = TaskType.of((String)"solve-mailbox-inconsistencies");
    public static final Logger LOGGER = LoggerFactory.getLogger(SolveMailboxInconsistenciesTask.class);
    private final SolveMailboxInconsistenciesService.Context context;
    private final SolveMailboxInconsistenciesService service;

    public SolveMailboxInconsistenciesTask(SolveMailboxInconsistenciesService service) {
        this.service = service;
        this.context = new SolveMailboxInconsistenciesService.Context();
    }

    public Task.Result run() {
        return (Task.Result)this.service.fixMailboxInconsistencies(this.context).block();
    }

    public TaskType type() {
        return SOLVE_MAILBOX_INCONSISTENCIES;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        SolveMailboxInconsistenciesService.Context.Snapshot snapshot = this.context.snapshot();
        return Optional.of(new Details(Clock.systemUTC().instant(), snapshot.getProcessedMailboxEntries(), snapshot.getProcessedMailboxPathEntries(), (ImmutableList<String>)((ImmutableList)snapshot.getFixedInconsistencies().stream().map(MailboxId::serialize).collect(ImmutableList.toImmutableList())), snapshot.getConflictingEntries(), snapshot.getErrors()));
    }

    public static class Details
    implements TaskExecutionDetails.AdditionalInformation {
        private final Instant instant;
        private final long processedMailboxEntries;
        private final long processedMailboxPathEntries;
        private final ImmutableList<String> fixedInconsistencies;
        private final ImmutableList<ConflictingEntry> conflictingEntries;
        private final long errors;

        Details(Instant instant, long processedMailboxEntries, long processedMailboxPathEntries, ImmutableList<String> fixedInconsistencies, ImmutableList<ConflictingEntry> conflictingEntries, long errors) {
            this.instant = instant;
            this.processedMailboxEntries = processedMailboxEntries;
            this.processedMailboxPathEntries = processedMailboxPathEntries;
            this.fixedInconsistencies = fixedInconsistencies;
            this.conflictingEntries = conflictingEntries;
            this.errors = errors;
        }

        public Instant timestamp() {
            return this.instant;
        }

        long getProcessedMailboxEntries() {
            return this.processedMailboxEntries;
        }

        long getProcessedMailboxPathEntries() {
            return this.processedMailboxPathEntries;
        }

        ImmutableList<String> getFixedInconsistencies() {
            return this.fixedInconsistencies;
        }

        ImmutableList<ConflictingEntry> getConflictingEntries() {
            return this.conflictingEntries;
        }

        long getErrors() {
            return this.errors;
        }
    }
}

