/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.droplists.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import jakarta.inject.Inject;
import jakarta.mail.internet.AddressException;
import java.util.List;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.droplists.api.DeniedEntityType;
import org.apache.james.droplists.api.DropList;
import org.apache.james.droplists.api.DropListEntry;
import org.apache.james.droplists.api.OwnerScope;
import org.apache.james.droplists.cassandra.tables.CassandraDropListTable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraDropListDAO {
    private final CassandraAsyncExecutor executor;
    private final PreparedStatement addDropListStatement;
    private final PreparedStatement removeDropListStatement;
    private final PreparedStatement getDropListStatement;
    private final PreparedStatement queryDropListStatement;
    private final PreparedStatement queryGlobalDropListStatement;

    @Inject
    public CassandraDropListDAO(CqlSession session) {
        this.executor = new CassandraAsyncExecutor(session);
        this.addDropListStatement = session.prepare(QueryBuilder.insertInto((String)"droplist").value(CassandraDropListTable.OWNER_SCOPE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDropListTable.OWNER_SCOPE)).value(CassandraDropListTable.OWNER, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDropListTable.OWNER)).value(CassandraDropListTable.DENIED_ENTITY, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDropListTable.DENIED_ENTITY)).value(CassandraDropListTable.DENIED_ENTITY_TYPE, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDropListTable.DENIED_ENTITY_TYPE)).ifNotExists().build());
        this.removeDropListStatement = session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"droplist").where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraDropListTable.OWNER_SCOPE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDropListTable.OWNER_SCOPE)), (Relation)Relation.column((CqlIdentifier)CassandraDropListTable.OWNER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDropListTable.OWNER)), (Relation)Relation.column((CqlIdentifier)CassandraDropListTable.DENIED_ENTITY).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDropListTable.DENIED_ENTITY))})).ifExists()).build());
        this.getDropListStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"droplist").all().where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraDropListTable.OWNER_SCOPE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDropListTable.OWNER_SCOPE)), (Relation)Relation.column((CqlIdentifier)CassandraDropListTable.OWNER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDropListTable.OWNER))})).allowFiltering().build());
        this.queryDropListStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"droplist").all().where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraDropListTable.OWNER_SCOPE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDropListTable.OWNER_SCOPE)), (Relation)Relation.column((CqlIdentifier)CassandraDropListTable.OWNER).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDropListTable.OWNER)), (Relation)Relation.column((CqlIdentifier)CassandraDropListTable.DENIED_ENTITY).in(QueryBuilder.bindMarker((CqlIdentifier)CassandraDropListTable.DENIED_ENTITY))})).build());
        this.queryGlobalDropListStatement = session.prepare(((Select)QueryBuilder.selectFrom((String)"droplist").all().where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraDropListTable.OWNER_SCOPE).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraDropListTable.OWNER_SCOPE)), (Relation)Relation.column((CqlIdentifier)CassandraDropListTable.DENIED_ENTITY).in(QueryBuilder.bindMarker((CqlIdentifier)CassandraDropListTable.DENIED_ENTITY))})).allowFiltering().build());
    }

    public Mono<Void> addDropList(DropListEntry dropListEntry) {
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)((BoundStatement)this.addDropListStatement.bind(new Object[0]).setString(CassandraDropListTable.OWNER_SCOPE, dropListEntry.getOwnerScope().name())).setString(CassandraDropListTable.OWNER, dropListEntry.getOwner())).setString(CassandraDropListTable.DENIED_ENTITY, dropListEntry.getDeniedEntity())).setString(CassandraDropListTable.DENIED_ENTITY_TYPE, dropListEntry.getDeniedEntityType().name()));
    }

    public Mono<Void> removeDropList(DropListEntry dropListEntry) {
        return this.executor.executeVoid((Statement)((BoundStatement)((BoundStatement)this.removeDropListStatement.bind(new Object[0]).setString(CassandraDropListTable.OWNER_SCOPE, dropListEntry.getOwnerScope().name())).setString(CassandraDropListTable.OWNER, dropListEntry.getOwner())).setString(CassandraDropListTable.DENIED_ENTITY, dropListEntry.getDeniedEntity()));
    }

    public Mono<DropList.Status> queryDropList(OwnerScope ownerScope, String owner, MailAddress sender) {
        if (ownerScope.equals((Object)OwnerScope.GLOBAL)) {
            return this.executor.executeReturnExists((Statement)((BoundStatement)this.queryGlobalDropListStatement.bind(new Object[0]).setString(CassandraDropListTable.OWNER_SCOPE, ownerScope.name())).setList(CassandraDropListTable.DENIED_ENTITY, List.of(sender.asString(), sender.getDomain().asString()), String.class)).map(isExist -> Boolean.TRUE.equals(isExist) ? DropList.Status.BLOCKED : DropList.Status.ALLOWED);
        }
        return this.executor.executeReturnExists((Statement)((BoundStatement)((BoundStatement)this.queryDropListStatement.bind(new Object[0]).setString(CassandraDropListTable.OWNER_SCOPE, ownerScope.name())).setString(CassandraDropListTable.OWNER, owner)).setList(CassandraDropListTable.DENIED_ENTITY, List.of(sender.asString(), sender.getDomain().asString()), String.class)).map(isExist -> Boolean.TRUE.equals(isExist) ? DropList.Status.BLOCKED : DropList.Status.ALLOWED);
    }

    public Flux<DropListEntry> getDropList(OwnerScope ownerScope, String owner) {
        return this.executor.executeRows((Statement)((BoundStatement)this.getDropListStatement.bind(new Object[0]).setString(CassandraDropListTable.OWNER_SCOPE, ownerScope.name())).setString(CassandraDropListTable.OWNER, owner)).map(row -> CassandraDropListDAO.mapRowToDropListEntry(ownerScope, row));
    }

    private static DropListEntry mapRowToDropListEntry(OwnerScope ownerScope, Row row) {
        String deniedEntity = row.getString(CassandraDropListTable.DENIED_ENTITY);
        String deniedEntityType = row.getString(CassandraDropListTable.DENIED_ENTITY_TYPE);
        try {
            DropListEntry.Builder builder = DropListEntry.builder();
            switch (ownerScope) {
                case USER: {
                    builder.userOwner(new MailAddress(row.getString(CassandraDropListTable.OWNER)));
                    break;
                }
                case DOMAIN: {
                    builder.domainOwner(Domain.of((String)row.getString(CassandraDropListTable.OWNER)));
                    break;
                }
                case GLOBAL: {
                    builder.forAll();
                }
            }
            if (DeniedEntityType.DOMAIN.name().equals(deniedEntityType)) {
                builder.denyDomain(Domain.of((String)deniedEntity));
            } else {
                builder.denyAddress(new MailAddress(deniedEntity));
            }
            return builder.build();
        }
        catch (AddressException e) {
            throw new IllegalArgumentException("Entity could not be parsed as a MailAddress", e);
        }
    }
}

