/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceException;
import java.util.Optional;
import org.apache.james.backends.jpa.EntityManagerUtils;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.UidProvider;

public class JPAUidProvider
implements UidProvider {
    private final EntityManagerFactory factory;

    @Inject
    public JPAUidProvider(EntityManagerFactory factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<MessageUid> lastUid(Mailbox mailbox) throws MailboxException {
        EntityManager manager = this.factory.createEntityManager();
        try {
            Optional<MessageUid> optional = this.lastUid(mailbox, manager);
            return optional;
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)manager);
        }
    }

    public Optional<MessageUid> lastUid(Mailbox mailbox, EntityManager manager) throws MailboxException {
        try {
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            long uid = (Long)manager.createNamedQuery("findLastUid").setParameter("idParam", (Object)mailboxId.getRawId()).getSingleResult();
            if (uid == 0L) {
                return Optional.empty();
            }
            return Optional.of(MessageUid.of((long)uid));
        }
        catch (PersistenceException e) {
            throw new MailboxException("Unable to get last uid for mailbox " + String.valueOf(mailbox), (Throwable)e);
        }
    }

    public MessageUid nextUid(Mailbox mailbox) throws MailboxException {
        return this.nextUid((JPAId)mailbox.getMailboxId());
    }

    public MessageUid nextUid(MailboxId mailboxId) throws MailboxException {
        return this.nextUid((JPAId)mailboxId);
    }

    private MessageUid nextUid(JPAId mailboxId) throws MailboxException {
        EntityManager manager = null;
        try {
            manager = this.factory.createEntityManager();
            manager.getTransaction().begin();
            JPAMailbox m = (JPAMailbox)manager.find(JPAMailbox.class, (Object)mailboxId.getRawId());
            long uid = m.consumeUid();
            manager.persist((Object)m);
            manager.getTransaction().commit();
            MessageUid messageUid = MessageUid.of((long)uid);
            return messageUid;
        }
        catch (PersistenceException e) {
            if (manager != null && manager.getTransaction().isActive()) {
                manager.getTransaction().rollback();
            }
            throw new MailboxException("Unable to save next uid for mailbox " + mailboxId.serialize(), (Throwable)e);
        }
        finally {
            EntityManagerUtils.safelyClose((EntityManager)manager);
        }
    }
}

