/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.Optional;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.MailboxStatusResponse;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.UidValidity;

public class MailboxStatusResponseEncoder
implements ImapConstants,
ImapResponseEncoder<MailboxStatusResponse> {
    @Override
    public Class<MailboxStatusResponse> acceptableMessages() {
        return MailboxStatusResponse.class;
    }

    @Override
    public void encode(MailboxStatusResponse response, ImapResponseComposer composer) throws IOException {
        Long messages = response.getMessages();
        Long recent = response.getRecent();
        Long size = response.getSize();
        Long deleted = response.getDeleted();
        Long deletedStorage = response.getDeletedStorage();
        Optional<Long> appendLimit = response.getAppendLimit();
        MessageUid uidNext = response.getUidNext();
        ModSeq highestModSeq = response.getHighestModSeq();
        UidValidity uidValidity = response.getUidValidity();
        Long unseen = response.getUnseen();
        MailboxId mailboxId = response.getMailboxId();
        String mailboxName = response.getMailbox();
        composer.untagged();
        composer.message(STATUS_COMMAND.getNameAsBytes());
        composer.mailbox(mailboxName);
        composer.openParen();
        if (appendLimit != null) {
            composer.message("APPENDLIMIT");
            composer.message(appendLimit.map(l -> Long.toString(l)).orElse("NIL"));
        }
        if (messages != null) {
            composer.message("MESSAGES");
            composer.message(messages);
        }
        if (size != null) {
            composer.message("SIZE");
            composer.message(size);
        }
        if (deleted != null) {
            composer.message("DELETED");
            composer.message(deleted);
        }
        if (deletedStorage != null) {
            composer.message("DELETED-STORAGE");
            composer.message(deletedStorage);
        }
        if (recent != null) {
            composer.message("RECENT");
            composer.message(recent);
        }
        if (uidNext != null) {
            composer.message("UIDNEXT");
            composer.message(uidNext.asLong());
        }
        if (highestModSeq != null) {
            composer.message("HIGHESTMODSEQ");
            composer.message(highestModSeq.asLong());
        }
        if (uidValidity != null) {
            composer.message("UIDVALIDITY");
            composer.message(uidValidity.asLong());
        }
        if (unseen != null) {
            composer.message("UNSEEN");
            composer.message(unseen);
        }
        if (mailboxId != null) {
            composer.message("MAILBOXID");
            composer.openParen();
            composer.message(mailboxId.serialize());
            composer.closeParen();
        }
        composer.closeParen();
        composer.end();
    }
}

