/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *   SPDX-License-Identifier: Apache-2.0
 */

package org.apache.jena.dboe.transaction.txn;

import org.apache.jena.dboe.base.file.BufferChannel;

/** StateManagement for a number of long values,
 *  state accessed by index.
 */
public final class StateMgrDataIdx extends StateMgrData {
    public StateMgrDataIdx(BufferChannel storage, long... initialData) {
        super(storage, initialData);
    }

    // Expose these operations as public

    @Override
    public long[] getData()              { return super.getData(); }

    @Override
    public void setData(long... newData) { super.setData(newData); }

    @Override
    public long get(int i)           { return super.get(i); }

    @Override
    public void set(int i, long v)   { super.set(i, v); }
}

