/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.axisChart.customRenderers.axisValue.renderers.ValueLabelPosition;
import org.jCharts.axisChart.customRenderers.axisValue.renderers.ValueLabelRenderer;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.DataSeries;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.ClusteredBarChartProperties;
import org.jCharts.properties.DataAxisProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.PropertyException;
import org.jCharts.properties.util.ChartStroke;
import org.jCharts.test.AxisChartTestBase;
import org.jCharts.test.ChartTestDriver;
import org.jCharts.test.TestDataGenerator;
import org.jCharts.types.ChartType;

class ClusteredBarTestDriver
extends AxisChartTestBase {
    ClusteredBarTestDriver() {
    }

    boolean supportsImageMap() {
        return true;
    }

    DataSeries getDataSeries() throws ChartDataException {
        int n = (int)TestDataGenerator.getRandomNumber(1.0, 10.0);
        int n2 = (int)TestDataGenerator.getRandomNumber(1.0, 4.0);
        DataSeries dataSeries = super.createDataSeries(n);
        ClusteredBarChartProperties clusteredBarChartProperties = new ClusteredBarChartProperties();
        AxisChartDataSet axisChartDataSet = super.createAxisChartDataSet(ChartType.BAR_CLUSTERED, clusteredBarChartProperties, n2, n, -5000, 5000);
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        return dataSeries;
    }

    public static void main(String[] stringArray) throws PropertyException, ChartDataException {
        ClusteredBarChartProperties clusteredBarChartProperties = new ClusteredBarChartProperties();
        ValueLabelRenderer valueLabelRenderer = new ValueLabelRenderer(false, true, true, -1);
        valueLabelRenderer.setValueLabelPosition(ValueLabelPosition.ON_TOP);
        valueLabelRenderer.useVerticalLabels(false);
        clusteredBarChartProperties.addPostRenderEventListener(valueLabelRenderer);
        double[][] dArrayArray = new double[][]{{280.0, 16.0, -150.0, 90.0}, {80.0, 216.0, -10.0, 30.0}};
        Paint[] paintArray = new Paint[]{Color.yellow, Color.blue};
        String[] stringArray2 = new String[]{"Test Legend Label", "other data"};
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet(dArrayArray, stringArray2, paintArray, ChartType.BAR_CLUSTERED, clusteredBarChartProperties);
        String[] stringArray3 = new String[]{"1900", "1950", "2000", "2050"};
        DataSeries dataSeries = new DataSeries(stringArray3, "Cookies", "Years", null);
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        ChartProperties chartProperties = new ChartProperties();
        AxisProperties axisProperties = new AxisProperties(true);
        axisProperties.getYAxisProperties().setShowGridLines(0);
        axisProperties.getYAxisProperties().setAxisStroke(new ChartStroke(new BasicStroke(1.5f), Color.red));
        DataAxisProperties dataAxisProperties = (DataAxisProperties)axisProperties.getXAxisProperties();
        dataAxisProperties.setRoundToNearest(1);
        LegendProperties legendProperties = null;
        AxisChart axisChart = new AxisChart(dataSeries, chartProperties, axisProperties, legendProperties, 500, 400);
        ChartTestDriver.exportImage(axisChart, "ClusteredBarChartTest.png");
    }
}

