/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.toolbar;

import com.github.weisj.darklaf.graphics.PaintUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JToolBar;
import javax.swing.JWindow;

public abstract class JDragWindow
extends JWindow {
    protected final JToolBar toolBar;
    protected int orientation;
    protected Color borderColor;
    protected Point offset;

    public JDragWindow(Window w, JToolBar toolBar) {
        super(w);
        this.toolBar = toolBar;
        this.orientation = toolBar.getOrientation();
    }

    public abstract void setOrientation(int var1);

    public Point getOffset() {
        return this.offset;
    }

    public void setOffset(Point p) {
        this.offset = p;
    }

    @Override
    public void paint(Graphics g) {
        this.paintDragWindow(g);
        super.paint(g);
    }

    @Override
    public Insets getInsets() {
        return new Insets(1, 1, 1, 1);
    }

    public void setBorderColor(Color c) {
        if (this.borderColor == c) {
            return;
        }
        this.borderColor = c;
        this.repaint();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    protected void paintDragWindow(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(this.getBackground());
        PaintUtil.fillRect(g, 0, 0, w, h);
        g.setColor(this.getBorderColor());
        PaintUtil.drawRect(g, 0, 0, w, h, 1);
    }
}

