/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.TransactionController;
import org.apache.jmeter.control.TransactionSampler;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.engine.util.ConfigMergabilityIndicator;
import org.apache.jmeter.engine.util.NoConfigMerge;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBeanHelper;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.SamplePackage;
import org.apache.jmeter.threads.TestCompilerHelper;
import org.apache.jmeter.timers.Timer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCompiler
implements HashTreeTraverser {
    private static final Logger log = LoggerFactory.getLogger(TestCompiler.class);
    private static final Set<ObjectPair> PAIRING = new HashSet<ObjectPair>();
    private final LinkedList<TestElement> stack = new LinkedList();
    private final IdentityHashMap<Sampler, SamplePackage> samplerConfigMap = new IdentityHashMap();
    private final IdentityHashMap<TransactionController, SamplePackage> transactionControllerConfigMap = new IdentityHashMap();
    private final HashTree testTree;

    public TestCompiler(HashTree testTree) {
        this.testTree = testTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        Set<ObjectPair> set = PAIRING;
        synchronized (set) {
            PAIRING.clear();
        }
    }

    public SamplePackage configureSampler(Sampler sampler) {
        SamplePackage pack = this.samplerConfigMap.get(sampler);
        pack.setSampler(sampler);
        TestCompiler.configureWithConfigElements(sampler, pack.getConfigs());
        return pack;
    }

    public SamplePackage configureTransactionSampler(TransactionSampler transactionSampler) {
        TransactionController controller = transactionSampler.getTransactionController();
        SamplePackage pack = this.transactionControllerConfigMap.get(controller);
        pack.setSampler(transactionSampler);
        return pack;
    }

    public void done(SamplePackage pack) {
        pack.recoverRunningVersion();
    }

    public void addNode(Object node, HashTree subTree) {
        this.stack.addLast((TestElement)node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtractNode() {
        if (log.isDebugEnabled()) {
            log.debug("Subtracting node, stack size = {}", (Object)this.stack.size());
        }
        TestElement child = this.stack.getLast();
        TestCompiler.trackIterationListeners(this.stack);
        if (child instanceof Sampler) {
            this.saveSamplerConfigs((Sampler)child);
        } else if (child instanceof TransactionController) {
            this.saveTransactionControllerConfigs((TransactionController)child);
        }
        this.stack.removeLast();
        if (!this.stack.isEmpty()) {
            TestElement parent = this.stack.getLast();
            boolean duplicate = false;
            if (parent instanceof Controller && (child instanceof Sampler || child instanceof Controller)) {
                if (parent instanceof TestCompilerHelper) {
                    TestCompilerHelper te = (TestCompilerHelper)((Object)parent);
                    duplicate = !te.addTestElementOnce(child);
                } else {
                    ObjectPair pair = new ObjectPair(child, parent);
                    Set<ObjectPair> set = PAIRING;
                    synchronized (set) {
                        if (!PAIRING.contains(pair)) {
                            parent.addTestElement(child);
                            PAIRING.add(pair);
                        } else {
                            duplicate = true;
                        }
                    }
                }
            }
            if (duplicate && log.isWarnEnabled()) {
                log.warn("Unexpected duplicate for {} and {}", parent.getClass(), child.getClass());
            }
        }
    }

    private static void trackIterationListeners(LinkedList<TestElement> pStack) {
        TestElement child = pStack.getLast();
        if (child instanceof LoopIterationListener) {
            ListIterator<TestElement> iter = pStack.listIterator(pStack.size());
            while (iter.hasPrevious()) {
                TestElement item = iter.previous();
                if (item == child || !(item instanceof Controller)) continue;
                TestBeanHelper.prepare(child);
                ((Controller)item).addIterationListener((LoopIterationListener)((Object)child));
                break;
            }
        }
    }

    public void processPath() {
    }

    private void saveSamplerConfigs(Sampler sam) {
        ArrayList<ConfigTestElement> configs = new ArrayList<ConfigTestElement>();
        ArrayList<Controller> controllers = new ArrayList<Controller>();
        ArrayList<SampleListener> listeners = new ArrayList<SampleListener>();
        ArrayList<Timer> timers = new ArrayList<Timer>();
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        ArrayList<PostProcessor> posts = new ArrayList<PostProcessor>();
        ArrayList<PreProcessor> pres = new ArrayList<PreProcessor>();
        for (int i = this.stack.size(); i > 0; --i) {
            TestCompiler.addDirectParentControllers(controllers, this.stack.get(i - 1));
            ArrayList<PreProcessor> tempPre = new ArrayList<PreProcessor>();
            ArrayList<PostProcessor> tempPost = new ArrayList<PostProcessor>();
            ArrayList<Assertion> tempAssertions = new ArrayList<Assertion>();
            for (Object item : this.testTree.list(this.stack.subList(0, i))) {
                if (item instanceof ConfigTestElement) {
                    configs.add((ConfigTestElement)item);
                }
                if (item instanceof SampleListener) {
                    listeners.add((SampleListener)item);
                }
                if (item instanceof Timer) {
                    timers.add((Timer)item);
                }
                if (item instanceof Assertion) {
                    tempAssertions.add((Assertion)item);
                }
                if (item instanceof PostProcessor) {
                    tempPost.add((PostProcessor)item);
                }
                if (!(item instanceof PreProcessor)) continue;
                tempPre.add((PreProcessor)item);
            }
            assertions.addAll(0, tempAssertions);
            pres.addAll(0, tempPre);
            posts.addAll(0, tempPost);
        }
        SamplePackage pack = new SamplePackage(configs, listeners, timers, assertions, posts, pres, controllers);
        pack.setSampler(sam);
        pack.setRunningVersion(true);
        this.samplerConfigMap.put(sam, pack);
    }

    private void saveTransactionControllerConfigs(TransactionController tc) {
        ArrayList<ConfigTestElement> configs = new ArrayList<ConfigTestElement>();
        ArrayList<Controller> controllers = new ArrayList<Controller>();
        ArrayList<SampleListener> listeners = new ArrayList<SampleListener>();
        ArrayList<Timer> timers = new ArrayList<Timer>();
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        ArrayList<PostProcessor> posts = new ArrayList<PostProcessor>();
        ArrayList<PreProcessor> pres = new ArrayList<PreProcessor>();
        for (int i = this.stack.size(); i > 0; --i) {
            TestCompiler.addDirectParentControllers(controllers, this.stack.get(i - 1));
            for (Object item : this.testTree.list(this.stack.subList(0, i))) {
                if (item instanceof SampleListener) {
                    listeners.add((SampleListener)item);
                }
                if (!(item instanceof Assertion)) continue;
                assertions.add((Assertion)item);
            }
        }
        SamplePackage pack = new SamplePackage(configs, listeners, timers, assertions, posts, pres, controllers);
        pack.setSampler(new TransactionSampler(tc, tc.getName()));
        pack.setRunningVersion(true);
        this.transactionControllerConfigMap.put(tc, pack);
    }

    private static void addDirectParentControllers(List<? super Controller> controllers, TestElement maybeController) {
        if (maybeController instanceof Controller) {
            log.debug("adding controller: {} to sampler config", (Object)maybeController);
            controllers.add((Controller)maybeController);
        }
    }

    private static void configureWithConfigElements(Sampler sam, List<? extends ConfigTestElement> configs) {
        sam.clearTestElementChildren();
        for (ConfigTestElement configTestElement : configs) {
            if (configTestElement instanceof NoConfigMerge) continue;
            if (sam instanceof ConfigMergabilityIndicator) {
                if (!((ConfigMergabilityIndicator)((Object)sam)).applies(configTestElement)) continue;
                sam.addTestElement(configTestElement);
                continue;
            }
            sam.addTestElement(configTestElement);
        }
    }

    private static class ObjectPair {
        private final TestElement child;
        private final TestElement parent;

        public ObjectPair(TestElement child, TestElement parent) {
            this.child = child;
            this.parent = parent;
        }

        public int hashCode() {
            return this.child.hashCode() + this.parent.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ObjectPair) {
                return this.child == ((ObjectPair)o).child && this.parent == ((ObjectPair)o).parent;
            }
            return false;
        }
    }
}

