/*
 * Decompiled with CFR 0.152.
 */
package jodd.props;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;

class PropertiesToProps {
    PropertiesToProps() {
    }

    void convertToWriter(Writer writer, Properties properties, Map<String, Properties> profiles) throws IOException {
        BufferedWriter bw = this.getBufferedWriter(writer);
        this.writeBaseAndProfileProperties(bw, properties, profiles);
        this.writeProfilePropertiesThatAreNotInTheBase(bw, properties, profiles);
        bw.flush();
    }

    private void writeProfilePropertiesThatAreNotInTheBase(BufferedWriter bw, Properties baseProperties, Map<String, Properties> profiles) throws IOException {
        for (Map.Entry<String, Properties> entry : profiles.entrySet()) {
            String profileName = entry.getKey();
            Properties profileProperties = entry.getValue();
            for (Object key : profileProperties.keySet()) {
                if (baseProperties.containsKey(key)) continue;
                String keyString = key.toString();
                this.writeProfileProperty(bw, profileName, keyString, profileProperties.getProperty(keyString));
            }
        }
    }

    private BufferedWriter getBufferedWriter(Writer writer) {
        BufferedWriter bw = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        return bw;
    }

    private void writeBaseAndProfileProperties(BufferedWriter bw, Properties baseProperties, Map<String, Properties> profiles) throws IOException {
        for (Object key : baseProperties.keySet()) {
            String keyString = key.toString();
            String value = baseProperties.getProperty(keyString);
            this.writeBaseProperty(bw, keyString, value);
            this.writeProfilePropertiesOfKey(bw, keyString, profiles);
        }
    }

    private void writeProfilePropertiesOfKey(BufferedWriter bw, String key, Map<String, Properties> profiles) throws IOException {
        for (Map.Entry<String, Properties> entry : profiles.entrySet()) {
            Properties profileProperties = entry.getValue();
            if (!profileProperties.containsKey(key)) continue;
            String profileName = entry.getKey();
            this.writeProfileProperty(bw, profileName, key, profileProperties.getProperty(key));
        }
    }

    private void writeProfileProperty(BufferedWriter bw, String profileName, String key, String value) throws IOException {
        bw.write(key + '<' + profileName + '>' + '=' + value);
        bw.newLine();
    }

    private void writeBaseProperty(BufferedWriter bw, String key, String value) throws IOException {
        bw.write(key + '=' + value);
        bw.newLine();
    }
}

