/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.websocket.internal.mapper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.apache.johnzon.mapper.Mapper;
import org.apache.johnzon.mapper.MapperBuilder;

@WebListener
public class MapperLocator
implements ServletContextListener {
    private static final Map<ClassLoader, Mapper> MAPPER_BY_LOADER = new ConcurrentHashMap<ClassLoader, Mapper>();
    private static final String ATTRIBUTE = MapperLocator.class.getName() + ".mapper";

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        Mapper build = MapperLocator.newMapper();
        MAPPER_BY_LOADER.put(servletContextEvent.getServletContext().getClassLoader(), build);
        servletContextEvent.getServletContext().setAttribute(ATTRIBUTE, (Object)build);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        MAPPER_BY_LOADER.remove(servletContextEvent.getServletContext().getClassLoader());
    }

    public static Mapper locate() {
        Mapper mapper;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = MapperLocator.class.getClassLoader();
        }
        if ((mapper = MAPPER_BY_LOADER.get(loader)) == null) {
            return MapperLocator.newMapper();
        }
        return mapper;
    }

    private static Mapper newMapper() {
        return new MapperBuilder().build();
    }
}

