/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.xpath;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.xml.xpath.SecuritySupport;
import javax.xml.xpath.XPathFactory;
import org.apache.servicemix.specs.locator.OsgiLocator;

final class XPathFactoryFinder {
    private static boolean debug = false;
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static Properties cacheProps;
    private static boolean firstTime;
    private final ClassLoader classLoader;
    private static final Class SERVICE_CLASS;
    private static final String SERVICE_ID;

    private static void debugPrintln(String msg) {
        if (debug) {
            System.err.println("JAXP: " + msg);
        }
    }

    public XPathFactoryFinder(ClassLoader loader) {
        this.classLoader = loader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == SecuritySupport.getContextClassLoader()) {
                XPathFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            XPathFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        XPathFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public XPathFactory newFactory(String uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        XPathFactory f = this._newFactory(uri);
        if (debug) {
            if (f != null) {
                XPathFactoryFinder.debugPrintln("factory '" + f.getClass().getName() + "' was found for " + uri);
            } else {
                XPathFactoryFinder.debugPrintln("unable to find a factory for " + uri);
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XPathFactory _newFactory(String uri) {
        Object f;
        XPathFactory sf;
        block31: {
            String propertyName;
            block30: {
                propertyName = SERVICE_CLASS.getName() + ":" + uri;
                try {
                    Class spiClass = OsgiLocator.locate(SERVICE_CLASS);
                    if (spiClass != null) {
                        return (XPathFactory)spiClass.newInstance();
                    }
                }
                catch (Throwable spiClass) {
                    // empty catch block
                }
                try {
                    String r;
                    if (debug) {
                        XPathFactoryFinder.debugPrintln("Looking up system property '" + propertyName + "'");
                    }
                    if ((r = SecuritySupport.getSystemProperty(propertyName)) != null) {
                        if (debug) {
                            XPathFactoryFinder.debugPrintln("The value is '" + r + "'");
                        }
                        if ((sf = this.createInstance(r)) != null) {
                            return sf;
                        }
                    } else if (debug) {
                        XPathFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (Throwable t) {
                    if (!debug) break block30;
                    XPathFactoryFinder.debugPrintln("failed to look up system property '" + propertyName + "'");
                    t.printStackTrace();
                }
            }
            String javah = SecuritySupport.getSystemProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "jaxp.properties";
            String factoryClassName = null;
            try {
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            f = new File(configFile);
                            firstTime = false;
                            if (SecuritySupport.doesFileExist((File)f)) {
                                if (debug) {
                                    XPathFactoryFinder.debugPrintln("Read properties file " + f);
                                }
                                cacheProps.load(SecuritySupport.getFileInputStream((File)f));
                            }
                        }
                    }
                }
                factoryClassName = cacheProps.getProperty(propertyName);
                if (debug) {
                    XPathFactoryFinder.debugPrintln("found " + factoryClassName + " in $java.home/jaxp.properties");
                }
                if (factoryClassName != null && (sf = this.createInstance(factoryClassName)) != null) {
                    return sf;
                }
            }
            catch (Exception ex) {
                if (!debug) break block31;
                ex.printStackTrace();
            }
        }
        Iterator sitr = this.createServiceFileIterator();
        while (sitr.hasNext()) {
            URL resource = (URL)sitr.next();
            if (debug) {
                XPathFactoryFinder.debugPrintln("looking into " + resource);
            }
            try {
                sf = this.loadFromServicesFile(uri, resource.toExternalForm(), SecuritySupport.getURLInputStream(resource));
                if (sf == null) continue;
                return sf;
            }
            catch (IOException e) {
                if (!debug) continue;
                XPathFactoryFinder.debugPrintln("failed to read " + resource);
                e.printStackTrace();
            }
        }
        if (uri.equals("http://java.sun.com/jaxp/xpath/dom")) {
            if (debug) {
                XPathFactoryFinder.debugPrintln("attempting to use the platform default W3C DOM XPath lib");
            }
            if ((f = this.createInstance("com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl")) == null) {
                f = this.createInstance("org.apache.xpath.jaxp.XPathFactoryImpl");
            }
            return f;
        }
        if (debug) {
            XPathFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        }
        return null;
    }

    private XPathFactory createInstance(String className) {
        block6: {
            try {
                Object o;
                if (debug) {
                    XPathFactoryFinder.debugPrintln("instanciating " + className);
                }
                Class<?> clazz = this.classLoader != null ? this.classLoader.loadClass(className) : Class.forName(className);
                if (debug) {
                    XPathFactoryFinder.debugPrintln("loaded it from " + XPathFactoryFinder.which(clazz));
                }
                if ((o = clazz.newInstance()) instanceof XPathFactory) {
                    return (XPathFactory)o;
                }
                if (debug) {
                    XPathFactoryFinder.debugPrintln(className + " is not assignable to " + SERVICE_CLASS.getName());
                }
            }
            catch (Throwable t) {
                if (!debug) break block6;
                XPathFactoryFinder.debugPrintln("failed to instanciate " + className);
                t.printStackTrace();
            }
        }
        return null;
    }

    private XPathFactory loadFromServicesFile(String uri, String resourceName, InputStream in) {
        BufferedReader rd;
        if (debug) {
            XPathFactoryFinder.debugPrintln("Reading " + resourceName);
        }
        try {
            rd = new BufferedReader(new InputStreamReader(in, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(in), 80);
        }
        String factoryClassName = null;
        XPathFactory resultFactory = null;
        while (true) {
            try {
                factoryClassName = rd.readLine();
            }
            catch (IOException x) {
                break;
            }
            if (factoryClassName == null) break;
            int hashIndex = factoryClassName.indexOf(35);
            if (hashIndex != -1) {
                factoryClassName = factoryClassName.substring(0, hashIndex);
            }
            if ((factoryClassName = factoryClassName.trim()).length() == 0) continue;
            try {
                XPathFactory foundFactory = this.createInstance(factoryClassName);
                if (!foundFactory.isObjectModelSupported(uri)) continue;
                resultFactory = foundFactory;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
        try {
            rd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resultFactory;
    }

    private Iterator createServiceFileIterator() {
        if (this.classLoader == null) {
            return new SingleIterator(){

                protected Object value() {
                    ClassLoader classLoader = XPathFactoryFinder.class.getClassLoader();
                    return SecuritySupport.getResourceAsURL(classLoader, SERVICE_ID);
                }
            };
        }
        try {
            final Enumeration e = SecuritySupport.getResources(this.classLoader, SERVICE_ID);
            if (debug && !e.hasMoreElements()) {
                XPathFactoryFinder.debugPrintln("no " + SERVICE_ID + " file was found");
            }
            return new Iterator(){

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public boolean hasNext() {
                    return e.hasMoreElements();
                }

                public Object next() {
                    return e.nextElement();
                }
            };
        }
        catch (IOException e) {
            if (debug) {
                XPathFactoryFinder.debugPrintln("failed to enumerate resources " + SERVICE_ID);
                e.printStackTrace();
            }
            return new ArrayList().iterator();
        }
    }

    private static String which(Class clazz) {
        return XPathFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String classname, ClassLoader loader) {
        URL it;
        String classnameAsResource = classname.replace('.', '/') + ".class";
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if ((it = SecuritySupport.getResourceAsURL(loader, classnameAsResource)) != null) {
            return it.toString();
        }
        return null;
    }

    static {
        try {
            String val = SecuritySupport.getSystemProperty("jaxp.debug");
            debug = val != null && !"false".equals(val);
        }
        catch (Exception _) {
            debug = false;
        }
        cacheProps = new Properties();
        firstTime = true;
        SERVICE_CLASS = XPathFactory.class;
        SERVICE_ID = "META-INF/services/" + SERVICE_CLASS.getName();
    }

    private static abstract class SingleIterator
    implements Iterator {
        private boolean seen = false;

        private SingleIterator() {
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public final boolean hasNext() {
            return !this.seen;
        }

        public final Object next() {
            if (this.seen) {
                throw new NoSuchElementException();
            }
            this.seen = true;
            return this.value();
        }

        protected abstract Object value();
    }
}

