/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import org.apache.karaf.bundle.core.BundleService;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.util.ShellUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@Command(scope="bundle", name="id", description="Gets the bundle ID.")
public class Id
extends OsgiCommandSupport {
    @Argument(index=0, name="name", description="The bundle name, name/version, or location", required=true, multiValued=false)
    String name;
    BundleService bundleService;
    BundleContext bundleContext;

    protected Object doExecute() throws Exception {
        return this.doExecute(true);
    }

    protected Object doExecute(boolean force) throws Exception {
        Bundle bundle = this.bundleService.getBundle(this.name, true);
        if (bundle == null) {
            for (int i = 0; i < this.bundleContext.getBundles().length; ++i) {
                Bundle b = this.bundleContext.getBundles()[i];
                if (!this.name.equals(b.getLocation())) continue;
                bundle = b;
                break;
            }
        }
        if (bundle != null) {
            if (force || !ShellUtil.isASystemBundle((BundleContext)this.bundleContext, (Bundle)bundle)) {
                return bundle.getBundleId();
            }
            System.err.println("Access to system bundle " + this.name + " is discouraged. You may override with -f");
        } else {
            System.err.println("Bundle " + this.name + " is not found");
        }
        return null;
    }

    public void setBundleService(BundleService bundleService) {
        this.bundleService = bundleService;
    }
}

