/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.mvn.internal.wagon;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import shaded.org.apache.http.HttpException;
import shaded.org.apache.http.HttpHost;
import shaded.org.apache.http.auth.AuthScope;
import shaded.org.apache.http.auth.Credentials;
import shaded.org.apache.http.auth.NTCredentials;
import shaded.org.apache.http.auth.UsernamePasswordCredentials;
import shaded.org.apache.http.client.AuthCache;
import shaded.org.apache.http.client.CredentialsProvider;
import shaded.org.apache.http.client.config.RequestConfig;
import shaded.org.apache.http.client.methods.CloseableHttpResponse;
import shaded.org.apache.http.client.methods.HttpUriRequest;
import shaded.org.apache.http.client.protocol.HttpClientContext;
import shaded.org.apache.http.impl.auth.BasicScheme;
import shaded.org.apache.http.impl.client.CloseableHttpClient;
import shaded.org.apache.http.message.BasicHeader;
import shaded.org.apache.maven.wagon.ConnectionException;
import shaded.org.apache.maven.wagon.authentication.AuthenticationException;
import shaded.org.apache.maven.wagon.authentication.AuthenticationInfo;
import shaded.org.apache.maven.wagon.providers.http.AbstractHttpClientWagon;
import shaded.org.apache.maven.wagon.providers.http.HttpMethodConfiguration;
import shaded.org.apache.maven.wagon.providers.http.HttpWagon;
import shaded.org.apache.maven.wagon.proxy.ProxyInfo;
import shaded.org.apache.maven.wagon.proxy.ProxyInfoProvider;
import shaded.org.apache.maven.wagon.repository.Repository;
import shaded.org.ops4j.net.URLUtils;

public class ConfigurableHttpWagon
extends HttpWagon {
    private final CloseableHttpClient client;

    public ConfigurableHttpWagon(CloseableHttpClient client, int timeout) {
        this.client = client;
        this.setTimeout(timeout);
    }

    @Override
    protected CloseableHttpResponse execute(HttpUriRequest httpMethod) throws HttpException, IOException {
        HttpMethodConfiguration config;
        this.setHeaders(httpMethod);
        String userAgent = this.getUserAgent(httpMethod);
        if (userAgent != null) {
            httpMethod.setHeader("User-Agent", userAgent);
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setCookieSpec("compatibility");
        Repository repo = this.getRepository();
        ProxyInfo proxyInfo = this.getProxyInfo(repo.getProtocol(), repo.getHost());
        if (proxyInfo != null) {
            HttpHost proxy = new HttpHost(proxyInfo.getHost(), proxyInfo.getPort());
            requestConfigBuilder.setProxy(proxy);
        }
        HttpMethodConfiguration httpMethodConfiguration = config = this.getHttpConfiguration() == null ? null : this.getHttpConfiguration().getMethodConfiguration(httpMethod);
        if (config != null) {
            this.copyConfig(config, requestConfigBuilder);
        } else {
            requestConfigBuilder.setSocketTimeout(this.getReadTimeout());
        }
        this.getLocalContext().setRequestConfig(requestConfigBuilder.build());
        if (config != null && config.isUsePreemptive()) {
            HttpHost targetHost = new HttpHost(repo.getHost(), repo.getPort(), repo.getProtocol());
            AuthScope targetScope = this.getBasicAuthScope().getScope(targetHost);
            if (this.getCredentialsProvider().getCredentials(targetScope) != null) {
                BasicScheme targetAuth = new BasicScheme();
                targetAuth.processChallenge(new BasicHeader("WWW-Authenticate", "BASIC preemptive"));
                this.getAuthCache().put(targetHost, targetAuth);
            }
        }
        if (proxyInfo != null && proxyInfo.getHost() != null) {
            HttpHost proxyHost = new HttpHost(proxyInfo.getHost(), proxyInfo.getPort());
            AuthScope proxyScope = this.getProxyBasicAuthScope().getScope(proxyHost);
            String proxyUsername = proxyInfo.getUserName();
            String proxyPassword = proxyInfo.getPassword();
            String proxyNtlmHost = proxyInfo.getNtlmHost();
            String proxyNtlmDomain = proxyInfo.getNtlmDomain();
            if (proxyUsername != null && proxyPassword != null) {
                Credentials creds = proxyNtlmHost != null || proxyNtlmDomain != null ? new NTCredentials(proxyUsername, proxyPassword, proxyNtlmHost, proxyNtlmDomain) : new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                this.getCredentialsProvider().setCredentials(proxyScope, creds);
                BasicScheme proxyAuth = new BasicScheme();
                proxyAuth.processChallenge(new BasicHeader("Proxy-Authenticate", "BASIC preemptive"));
                this.getAuthCache().put(proxyHost, proxyAuth);
            }
        }
        return this.client.execute(httpMethod, this.getLocalContext());
    }

    @Override
    public void connect(Repository repository, AuthenticationInfo authenticationInfo, ProxyInfoProvider proxyInfoProvider) throws ConnectionException, AuthenticationException {
        if (repository == null) {
            throw new IllegalStateException("The repository specified cannot be null.");
        }
        if (authenticationInfo == null) {
            authenticationInfo = new AuthenticationInfo();
        }
        if (authenticationInfo.getUserName() == null && repository.getUsername() != null) {
            authenticationInfo.setUserName(URLUtils.decode(repository.getUsername()));
            if (repository.getPassword() != null && authenticationInfo.getPassword() == null) {
                authenticationInfo.setPassword(URLUtils.decode(repository.getPassword()));
            }
        }
        super.connect(repository, authenticationInfo, proxyInfoProvider);
    }

    private AuthCache getAuthCache() {
        return this.getField(AuthCache.class, "authCache");
    }

    private CredentialsProvider getCredentialsProvider() {
        return this.getField(CredentialsProvider.class, "credentialsProvider");
    }

    private HttpClientContext getLocalContext() {
        return this.getField(HttpClientContext.class, "localContext");
    }

    private <T> T getField(Class<T> clazz, String name) {
        try {
            Field field = AbstractHttpClientWagon.class.getDeclaredField(name);
            field.setAccessible(true);
            return clazz.cast(field.get(this));
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Unable to retrieve field " + name, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to retrieve field " + name, e);
        }
    }

    private void copyConfig(HttpMethodConfiguration config, RequestConfig.Builder builder) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("shaded.org.apache.maven.wagon.providers.http.ConfigurationUtils");
            Method method = clazz.getMethod("copyConfig", HttpMethodConfiguration.class, RequestConfig.Builder.class);
            method.invoke(null, config, builder);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to call copyConfig", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Unable to call copyConfig", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to call copyConfig", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to call copyConfig", e);
        }
    }
}

