/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.jdbc;

import javax.naming.InitialContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class JDBCUtils {
    public static final String DATASOURCE = "datasource";
    public static final String JNDI = "jndi:";
    public static final String OSGI = "osgi:";

    private JDBCUtils() {
    }

    public static Object createDatasource(BundleContext bc, String url) throws Exception {
        if (url == null) {
            throw new Exception("Illegal datasource url format. Datasource URL cannot be null.");
        }
        if (url.trim().length() == 0) {
            throw new Exception("Illegal datasource url format. Datasource URL cannot be empty.");
        }
        if (url.startsWith(JNDI)) {
            String jndiName = url.substring(JNDI.length());
            InitialContext ic = new InitialContext();
            return ic.lookup(jndiName);
        }
        if (url.startsWith(OSGI)) {
            ServiceReference[] references;
            String osgiFilter = url.substring(OSGI.length());
            String clazz = null;
            String filter = null;
            String[] tokens = osgiFilter.split("/", 2);
            if (tokens != null) {
                if (tokens.length > 0) {
                    clazz = tokens[0];
                }
                if (tokens.length > 1) {
                    filter = tokens[1];
                }
            }
            if ((references = bc.getServiceReferences(clazz, filter)) != null) {
                ServiceReference ref = references[0];
                Object ds = bc.getService(ref);
                bc.ungetService(ref);
                return ds;
            }
            throw new Exception("Unable to find service reference for datasource: " + clazz + "/" + filter);
        }
        throw new Exception("Illegal datasource url format");
    }
}

