/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Conditional;
import org.apache.karaf.features.Dependency;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeatureEvent;
import org.apache.karaf.features.FeaturesListener;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.RepositoryEvent;
import org.apache.karaf.features.Resolver;
import org.apache.karaf.features.internal.BundleManager;
import org.apache.karaf.features.internal.EventAdminListener;
import org.apache.karaf.features.internal.FeatureConfigInstaller;
import org.apache.karaf.features.internal.FeatureValidationUtil;
import org.apache.karaf.features.internal.InstallationState;
import org.apache.karaf.features.internal.Overrides;
import org.apache.karaf.features.internal.RepositoryImpl;
import org.apache.karaf.util.collections.CopyOnWriteArrayIdentityList;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesServiceImpl
implements FeaturesService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturesServiceImpl.class);
    private static Pattern NON_REGEXP_EXPRESSION = Pattern.compile("^[a-zA-Z0-9_\\-]*$");
    private static final int KARAF_BUNDLE_START_LEVEL = Integer.parseInt(System.getProperty("karaf.startlevel.bundle", "80"));
    private final BundleManager bundleManager;
    private final FeatureConfigInstaller configManager;
    private final AtomicBoolean stopped = new AtomicBoolean();
    private boolean respectStartLvlDuringFeatureStartup;
    private boolean respectStartLvlDuringFeatureUninstall;
    private long resolverTimeout = 5000L;
    private Set<URI> uris;
    private Map<URI, Repository> repositories = new ConcurrentHashMap<URI, Repository>();
    private Map<String, Map<String, Feature>> features;
    private Map<Feature, Set<Long>> installed = new HashMap<Feature, Set<Long>>();
    private List<FeaturesListener> listeners = new CopyOnWriteArrayIdentityList<FeaturesListener>();
    private ThreadLocal<Repository> repo = new ThreadLocal();
    private EventAdminListener eventAdminListener;
    private String overrides;
    static Pattern fuzzyVersion = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?", 32);
    static Pattern fuzzyModifier = Pattern.compile("(\\d+[.-])*(.*)", 32);

    public FeaturesServiceImpl(BundleManager bundleManager) {
        this(bundleManager, null);
    }

    public FeaturesServiceImpl(BundleManager bundleManager, FeatureConfigInstaller configManager) {
        BundleContext bundleContext;
        this.bundleManager = bundleManager;
        this.configManager = configManager;
        HashSet<Long> startupBundleSet = new HashSet<Long>();
        if (bundleManager != null && (bundleContext = bundleManager.getBundleContext()) != null && bundleContext.getBundles() != null && this.installed.size() == 0) {
            for (Bundle startupBundle : bundleContext.getBundles()) {
                startupBundleSet.add(startupBundle.getBundleId());
            }
            this.installed.put(new org.apache.karaf.features.internal.model.Feature("startup"), startupBundleSet);
        }
    }

    public long getResolverTimeout() {
        return this.resolverTimeout;
    }

    public void setResolverTimeout(long resolverTimeout) {
        this.resolverTimeout = resolverTimeout;
    }

    public void setRespectStartLvlDuringFeatureStartup(boolean respectStartLvlDuringFeatureStartup) {
        this.respectStartLvlDuringFeatureStartup = respectStartLvlDuringFeatureStartup;
    }

    public String getOverrides() {
        return this.overrides;
    }

    public void setOverrides(String overrides) {
        this.overrides = overrides;
    }

    @Override
    public void registerListener(FeaturesListener listener) {
        this.listeners.add(listener);
        for (Repository repository : this.listRepositories()) {
            listener.repositoryEvent(new RepositoryEvent(repository, RepositoryEvent.EventType.RepositoryAdded, true));
        }
        for (Feature feature : this.listInstalledFeatures()) {
            listener.featureEvent(new FeatureEvent(feature, FeatureEvent.EventType.FeatureInstalled, true));
        }
    }

    @Override
    public void unregisterListener(FeaturesListener listener) {
        this.listeners.remove(listener);
    }

    public void setUrls(String uris) throws URISyntaxException {
        String[] s = uris.split(",");
        this.uris = new HashSet<URI>();
        for (String value : s) {
            value = value.trim();
            if ((value = InterpolationHelper.substVars(value, "featuresRepositories", null, null)).isEmpty()) continue;
            this.uris.add(new URI(value));
        }
    }

    @Override
    public void validateRepository(URI uri) throws Exception {
        FeatureValidationUtil.validate(uri);
    }

    @Override
    public void addRepository(URI uri) throws Exception {
        this.addRepository(uri, false);
    }

    @Override
    public void addRepository(URI uri, boolean install) throws Exception {
        if (!this.repositories.containsKey(uri)) {
            Repository repositoryImpl = this.internalAddRepository(uri);
            this.saveState();
            if (install) {
                for (Feature feature : repositoryImpl.getFeatures()) {
                    this.installFeature(feature, EnumSet.noneOf(FeaturesService.Option.class));
                }
            }
        } else {
            this.refreshRepository(uri, install);
        }
    }

    @Override
    public void refreshRepository(URI uri) throws Exception {
        this.refreshRepository(uri, false);
    }

    protected void refreshRepository(URI uri, boolean install) throws Exception {
        try {
            this.removeRepository(uri, install);
            this.addRepository(uri, install);
        }
        catch (Exception e) {
            this.restoreRepository(uri);
            throw new Exception("Unable to refresh features repository " + uri, e);
        }
    }

    protected Repository internalAddRepository(URI uri) throws Exception {
        this.validateRepository(uri);
        RepositoryImpl repo = new RepositoryImpl(uri);
        this.repositories.put(uri, repo);
        repo.load();
        this.callListeners(new RepositoryEvent(repo, RepositoryEvent.EventType.RepositoryAdded, false));
        this.features = null;
        return repo;
    }

    @Override
    public void removeRepository(URI uri) throws Exception {
        this.removeRepository(uri, false);
    }

    @Override
    public void removeRepository(URI uri, boolean uninstall) throws Exception {
        if (this.repositories.containsKey(uri)) {
            if (uninstall) {
                Repository repositoryImpl = this.repositories.get(uri);
                for (Feature feature : repositoryImpl.getFeatures()) {
                    this.uninstallFeature(feature.getName(), feature.getVersion());
                }
            }
            this.internalRemoveRepository(uri);
            this.saveState();
        }
    }

    protected void internalRemoveRepository(URI uri) {
        Repository repo = this.repositories.remove(uri);
        this.repo.set(repo);
        this.callListeners(new RepositoryEvent(repo, RepositoryEvent.EventType.RepositoryRemoved, false));
        this.features = null;
    }

    @Override
    public void restoreRepository(URI uri) throws Exception {
        this.repositories.put(uri, this.repo.get());
        this.callListeners(new RepositoryEvent(this.repo.get(), RepositoryEvent.EventType.RepositoryAdded, false));
        this.features = null;
    }

    @Override
    public Repository[] listRepositories() {
        ArrayList<Repository> repos = new ArrayList<Repository>(this.repositories.values());
        return repos.toArray(new Repository[repos.size()]);
    }

    @Override
    public Repository getRepository(String repoName) {
        for (Repository repo : this.repositories.values()) {
            if (!repoName.equals(repo.getName())) continue;
            return repo;
        }
        return null;
    }

    @Override
    public Repository getRepository(URI uri) {
        if (this.repositories.get(uri) != null) {
            return this.repositories.get(uri);
        }
        return null;
    }

    @Override
    public String getRepositoryName(URI uri) {
        return this.repositories.get(uri).getName();
    }

    @Override
    public void installFeature(String name) throws Exception {
        this.installFeature(name, org.apache.karaf.features.internal.model.Feature.DEFAULT_VERSION);
    }

    @Override
    public void installFeature(String name, EnumSet<FeaturesService.Option> options) throws Exception {
        this.installFeature(name, org.apache.karaf.features.internal.model.Feature.DEFAULT_VERSION, options);
    }

    @Override
    public void installFeature(String name, String version) throws Exception {
        this.installFeature(name, version, EnumSet.noneOf(FeaturesService.Option.class));
    }

    @Override
    public void installFeature(String name, String version, EnumSet<FeaturesService.Option> options) throws Exception {
        Feature[] features = this.getFeatures(name, version);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        if (features.length < 1) {
            throw new IllegalStateException("No feature matching " + name + "/" + version);
        }
        for (Feature feature : features) {
            try {
                this.installFeature(feature, options);
            }
            catch (Exception e) {
                exceptions.add(e);
                if (!options.contains((Object)FeaturesService.Option.PrintExecptionPerFeature)) continue;
                LOGGER.warn("Error when installing feature {}: {}", (Object)feature.getName(), (Object)e);
            }
        }
        if (!exceptions.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Exception exception : exceptions) {
                builder.append("\t\n").append(exception.getMessage());
            }
            throw new IllegalStateException("Can't install feature " + name + "/" + version + ": " + builder.toString());
        }
    }

    @Override
    public void installFeature(Feature feature, EnumSet<FeaturesService.Option> options) throws Exception {
        this.installFeatures(Collections.singleton(feature), options);
    }

    @Override
    public void installFeatures(Set<Feature> features, EnumSet<FeaturesService.Option> options) throws Exception {
        final InstallationState state = new InstallationState();
        InstallationState failure = new InstallationState();
        boolean verbose = options.contains((Object)FeaturesService.Option.Verbose);
        try {
            for (Feature f : features) {
                InstallationState installationState = new InstallationState();
                try {
                    this.doInstallFeature(installationState, f, verbose);
                    this.doInstallFeatureConditionals(installationState, f, verbose);
                    for (Feature installedFeature : this.listInstalledFeatures()) {
                        this.doInstallFeatureConditionals(installationState, installedFeature, verbose);
                    }
                    for (Feature installedFeature : state.features.keySet()) {
                        this.doInstallFeatureConditionals(installationState, installedFeature, verbose);
                    }
                    state.bundleInfos.putAll(installationState.bundleInfos);
                    state.bundles.addAll(installationState.bundles);
                    state.features.putAll(installationState.features);
                    state.installed.addAll(installationState.installed);
                    state.bundleStartLevels.putAll(installationState.bundleStartLevels);
                }
                catch (Exception e) {
                    failure.bundles.addAll(installationState.bundles);
                    failure.features.putAll(installationState.features);
                    failure.installed.addAll(installationState.installed);
                    if (options.contains((Object)FeaturesService.Option.ContinueBatchOnFailure)) {
                        LOGGER.warn("Error when installing feature {}: {}", (Object)f.getName(), (Object)e);
                        continue;
                    }
                    throw e;
                }
            }
            this.bundleManager.refreshBundles(state.bundles, state.installed, options);
            ArrayList<Bundle> bundlesSortedByStartLvl = new ArrayList<Bundle>(state.bundles);
            if (this.respectStartLvlDuringFeatureStartup) {
                Collections.sort(bundlesSortedByStartLvl, new Comparator<Bundle>(){

                    @Override
                    public int compare(Bundle bundle, Bundle bundle1) {
                        return state.bundleStartLevels.get(bundle) - state.bundleStartLevels.get(bundle1);
                    }
                });
            }
            for (Bundle bundle : bundlesSortedByStartLvl) {
                LOGGER.debug("Starting bundle: {}", (Object)bundle.getSymbolicName());
                if (options.contains((Object)FeaturesService.Option.NoAutoStartBundles)) continue;
                this.startBundle(state, bundle);
            }
            if (!options.contains((Object)FeaturesService.Option.NoCleanIfFailure)) {
                failure.installed.removeAll(state.bundles);
                if (failure.installed.size() > 0) {
                    this.bundleManager.uninstall(failure.installed);
                }
            }
            for (Feature feature : features) {
                this.callListeners(new FeatureEvent(feature, FeatureEvent.EventType.FeatureInstalled, false));
            }
            for (Map.Entry entry : state.features.entrySet()) {
                this.installed.put((Feature)entry.getKey(), (Set<Long>)entry.getValue());
            }
            this.saveState();
        }
        catch (Exception e) {
            boolean noCleanIfFailure = options.contains((Object)FeaturesService.Option.NoCleanIfFailure);
            this.cleanUpOnFailure(state, failure, noCleanIfFailure);
            throw e;
        }
    }

    private void startBundle(InstallationState state, Bundle bundle) throws Exception {
        Long bundleId;
        BundleInfo bundleInfo;
        if (!this.isFragment(bundle) && (state.installed.contains(bundle) || bundle.getState() != 8 && bundle.getState() != 32 && ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).isPersistentlyStarted()) && ((bundleInfo = state.bundleInfos.get(bundleId = Long.valueOf(bundle.getBundleId()))) == null || bundleInfo.isStart())) {
            try {
                bundle.start();
            }
            catch (BundleException be) {
                String msg = String.format("Could not start bundle %s in feature(s) %s: %s", bundle.getLocation(), this.getFeaturesContainingBundleList(bundle), be.getMessage());
                throw new Exception(msg, be);
            }
        }
    }

    private boolean isFragment(Bundle b) {
        Dictionary d = b.getHeaders();
        String fragmentHostHeader = (String)d.get("Fragment-Host");
        return fragmentHostHeader != null && fragmentHostHeader.trim().length() > 0;
    }

    private void cleanUpOnFailure(InstallationState state, InstallationState failure, boolean noCleanIfFailure) {
        if (!noCleanIfFailure) {
            HashSet<Bundle> uninstall = new HashSet<Bundle>();
            uninstall.addAll(state.installed);
            uninstall.addAll(failure.installed);
            if (uninstall.size() > 0) {
                this.bundleManager.uninstall(uninstall);
            }
        } else {
            for (Bundle b : state.installed) {
                try {
                    BundleInfo info = state.bundleInfos.get(b.getBundleId());
                    if (!info.isStart()) continue;
                    b.start();
                }
                catch (Exception e2) {}
            }
        }
    }

    protected void doInstallFeature(InstallationState state, Feature feature, boolean verbose) throws Exception {
        if (feature != null) {
            if (this.isInstalled(feature)) {
                String msg = "Found installed feature " + feature.getName() + " " + feature.getVersion();
                LOGGER.info(msg);
                if (verbose) {
                    System.out.println(msg);
                }
                return;
            }
            String msg = "Installing feature " + feature.getName() + " " + feature.getVersion();
            LOGGER.info(msg);
            if (verbose) {
                System.out.println(msg);
            }
            for (Dependency dependency : feature.getDependencies()) {
                this.installFeatureDependency(dependency, state, verbose);
            }
            if (this.configManager != null) {
                this.configManager.installFeatureConfigs(feature, verbose);
            }
            TreeSet<Long> bundles = new TreeSet<Long>();
            for (BundleInfo bInfo : Overrides.override(this.resolve(feature), this.overrides)) {
                int startLevel = this.getBundleStartLevel(bInfo.getStartLevel(), feature.getStartLevel());
                BundleManager.BundleInstallerResult result = this.bundleManager.installBundleIfNeeded(bInfo.getLocation(), startLevel, feature.getRegion());
                state.bundles.add(result.bundle);
                state.bundleStartLevels.put(result.bundle, this.getBundleStartLevelForOrdering(startLevel));
                if (result.isNew) {
                    state.installed.add(result.bundle);
                }
                String msg2 = !result.isNew ? "Found installed bundle: " + result.bundle : "Installing bundle " + bInfo.getLocation();
                LOGGER.debug(msg2);
                if (verbose) {
                    System.out.println(msg2);
                }
                if (!result.isNew) continue;
                bundles.add(result.bundle.getBundleId());
                state.bundleInfos.put(result.bundle.getBundleId(), bInfo);
            }
            for (BundleInfo bInfo : feature.getBundles()) {
                Bundle bundle = this.bundleManager.isBundleInstalled(bInfo.getLocation());
                if (bundle == null || bundles.contains(bundle.getBundleId())) continue;
                bundles.add(bundle.getBundleId());
            }
            state.features.put(feature, bundles);
        }
    }

    private int getBundleStartLevel(int bundleStartLevel, int featureStartLevel) {
        return bundleStartLevel > 0 ? bundleStartLevel : featureStartLevel;
    }

    private int getBundleStartLevelForOrdering(int startLevel) {
        return startLevel == 0 ? KARAF_BUNDLE_START_LEVEL : startLevel;
    }

    protected void doInstallFeatureConditionals(InstallationState state, Feature feature, boolean verbose) throws Exception {
        if ((feature = this.getFeature(feature.getName(), feature.getVersion())) != null) {
            for (Conditional conditional : feature.getConditional()) {
                if (!this.dependenciesSatisfied(conditional.getCondition(), state)) continue;
                InstallationState s = new InstallationState();
                this.doInstallFeature(s, conditional.asFeature(feature.getName(), feature.getVersion()), verbose);
                state.bundleInfos.putAll(s.bundleInfos);
                state.bundles.addAll(s.bundles);
                state.features.putAll(s.features);
                state.installed.addAll(s.installed);
                state.bundleStartLevels.putAll(s.bundleStartLevels);
            }
        }
    }

    private void installFeatureDependency(Dependency dependency, InstallationState state, boolean verbose) throws Exception {
        Feature fi = this.getFeatureForDependency(dependency);
        if (fi == null) {
            throw new Exception("No feature named '" + dependency.getName() + "' with version '" + dependency.getVersion() + "' available");
        }
        if (state.features.containsKey(fi)) {
            LOGGER.debug("Feature {} with version {} is already being installed", (Object)fi.getName(), (Object)fi.getVersion());
        } else {
            this.doInstallFeature(state, fi, verbose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<BundleInfo> resolve(Feature feature) throws Exception {
        ServiceTracker tracker;
        String resolver = feature.getResolver();
        if (resolver == null || resolver.length() == 0) {
            return feature.getBundles();
        }
        boolean optional = false;
        if (resolver.startsWith("(") && resolver.endsWith(")")) {
            resolver = resolver.substring(1, resolver.length() - 1);
            optional = true;
        }
        if ((tracker = this.bundleManager.createServiceTrackerForResolverName(resolver)) == null) {
            return feature.getBundles();
        }
        tracker.open();
        try {
            if (optional) {
                Resolver r = (Resolver)tracker.getService();
                if (r != null) {
                    List<BundleInfo> list = r.resolve(feature);
                    return list;
                }
                LOGGER.debug("Optional resolver '" + resolver + "' not found, using the default resolver");
                List<BundleInfo> list = feature.getBundles();
                return list;
            }
            Resolver r = (Resolver)tracker.waitForService(this.resolverTimeout);
            if (r == null) {
                throw new Exception("Unable to find required resolver '" + resolver + "'");
            }
            List<BundleInfo> list = r.resolve(feature);
            return list;
        }
        finally {
            tracker.close();
        }
    }

    @Override
    public void uninstallFeature(String name) throws Exception {
        this.uninstallFeature(name, EnumSet.noneOf(FeaturesService.Option.class));
    }

    @Override
    public void uninstallFeature(String name, EnumSet<FeaturesService.Option> options) throws Exception {
        Pattern pattern = Pattern.compile(name);
        ArrayList<Feature> toRemove = new ArrayList<Feature>();
        for (Feature f : this.installed.keySet()) {
            Matcher matcher = pattern.matcher(f.getName());
            if (!matcher.matches()) continue;
            toRemove.add(f);
        }
        if (toRemove.isEmpty()) {
            throw new IllegalStateException("No installed feature matching " + name);
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Feature f : toRemove) {
            try {
                this.uninstallFeature(f.getName(), f.getVersion(), options);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Exception exception : exceptions) {
                builder.append("\t\n").append(exception);
            }
            throw new IllegalStateException("Can't uninstall feature " + name + ": " + builder.toString());
        }
    }

    @Override
    public void uninstallFeature(String name, String version) throws Exception {
        this.uninstallFeature(name, version, EnumSet.noneOf(FeaturesService.Option.class));
    }

    private void recursiveFeatures(Feature feature, ArrayList<Feature> dependencyFeatures) throws Exception {
        for (Dependency dependency : feature.getDependencies()) {
            Feature inner = this.getFeature(dependency.getName(), dependency.getVersion());
            dependencyFeatures.add(inner);
            this.recursiveFeatures(inner, dependencyFeatures);
        }
    }

    @Override
    public void uninstallFeature(String name, String version, EnumSet<FeaturesService.Option> options) throws Exception {
        ArrayList<Feature> features = new ArrayList<Feature>(Arrays.asList(this.getFeatures(name, version)));
        ArrayList<Feature> featuresToUninstall = new ArrayList<Feature>();
        featuresToUninstall.addAll(features);
        if (options.contains((Object)FeaturesService.Option.Recursive)) {
            for (Feature feature : features) {
                this.recursiveFeatures(feature, featuresToUninstall);
            }
        }
        for (Feature feature : featuresToUninstall) {
            if (!this.installed.containsKey(feature)) continue;
            boolean verbose = options != null && options.contains((Object)FeaturesService.Option.Verbose);
            boolean refresh = options == null || !options.contains((Object)FeaturesService.Option.NoAutoRefreshBundles);
            String msg = "Uninstalling feature " + feature.getName() + " " + feature.getVersion();
            LOGGER.info(msg);
            if (verbose) {
                System.out.println(msg);
            }
            Set<Long> bundles = this.installed.remove(feature);
            for (Conditional conditional : feature.getConditional()) {
                Feature conditionalFeature = conditional.asFeature(feature.getName(), feature.getVersion());
                if (this.installed.containsKey(conditionalFeature)) {
                    msg = "Uninstalling feature " + conditionalFeature.getName() + " " + conditionalFeature.getVersion();
                    LOGGER.info(msg);
                    if (verbose) {
                        System.out.println(msg);
                    }
                    bundles.addAll((Collection<Long>)this.installed.remove(conditionalFeature));
                    continue;
                }
                LOGGER.info("Conditional feature {}, hasn't been installed!");
            }
            for (Feature feature2 : new HashSet<Feature>(this.installed.keySet())) {
                Feature feature3 = this.getFeature(feature2.getName(), feature2.getVersion());
                if (feature3 == null) continue;
                for (Conditional conditional : feature3.getConditional()) {
                    Feature conditionalFeature;
                    boolean satisfied = true;
                    for (Dependency dependency : conditional.getCondition()) {
                        Feature df = this.getFeatureForDependency(dependency);
                        satisfied &= this.installed.containsKey(df);
                    }
                    if (satisfied || !this.installed.containsKey(conditionalFeature = conditional.asFeature(feature3.getName(), feature3.getVersion()))) continue;
                    msg = "Uninstalling feature " + conditionalFeature.getName() + " " + conditionalFeature.getVersion();
                    LOGGER.info(msg);
                    if (verbose) {
                        System.out.println(msg);
                    }
                    bundles.addAll((Collection<Long>)this.installed.remove(conditionalFeature));
                }
            }
            for (Set set : this.installed.values()) {
                bundles.removeAll(set);
            }
            ArrayList<Bundle> bundlesDescendSortedByStartLvl = new ArrayList<Bundle>();
            for (long bundleId : bundles) {
                Bundle b = this.bundleManager.getBundleContext().getBundle(bundleId);
                if (b == null) continue;
                bundlesDescendSortedByStartLvl.add(b);
            }
            if (this.isRespectStartLvlDuringFeatureUninstall()) {
                Collections.sort(bundlesDescendSortedByStartLvl, new Comparator<Bundle>(){

                    @Override
                    public int compare(Bundle bundle, Bundle bundle1) {
                        return ((BundleStartLevel)bundle1.adapt(BundleStartLevel.class)).getStartLevel() - ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
                    }
                });
            }
            this.bundleManager.uninstall(bundlesDescendSortedByStartLvl, refresh);
            this.callListeners(new FeatureEvent(feature, FeatureEvent.EventType.FeatureUninstalled, false));
            this.saveState();
        }
    }

    @Override
    public Feature[] listFeatures() throws Exception {
        ArrayList<Feature> features = new ArrayList<Feature>();
        for (Map<String, Feature> featureWithDifferentVersion : this.getFeatures().values()) {
            for (Feature f : featureWithDifferentVersion.values()) {
                features.add(f);
            }
        }
        return features.toArray(new Feature[features.size()]);
    }

    @Override
    public Feature[] listInstalledFeatures() {
        Set<Feature> result = this.installed.keySet();
        return result.toArray(new Feature[result.size()]);
    }

    @Override
    public boolean isInstalled(Feature f) {
        return this.installed.containsKey(f);
    }

    @Override
    public Feature[] getFeatures(String name, String version) throws Exception {
        Matcher simpleFeatureName;
        if (version != null) {
            version = version.trim();
        }
        if ((simpleFeatureName = NON_REGEXP_EXPRESSION.matcher(name)).matches()) {
            Map<String, Feature> versions = this.getFeatures().get(name);
            Feature feature = FeaturesServiceImpl.selectFeatureVersion(versions, version);
            return new Feature[]{feature};
        }
        ArrayList<Feature> features = new ArrayList<Feature>();
        Pattern pattern = Pattern.compile(name);
        for (String featureName : this.getFeatures().keySet()) {
            Map<String, Feature> versions;
            Feature feature;
            Matcher matcher = pattern.matcher(featureName);
            if (!matcher.matches() || (feature = FeaturesServiceImpl.selectFeatureVersion(versions = this.getFeatures().get(featureName), version)) == null) continue;
            features.add(feature);
        }
        return features.toArray(new Feature[features.size()]);
    }

    private static Feature selectFeatureVersion(Map<String, Feature> versions, String version) {
        if (versions != null && !versions.isEmpty()) {
            Feature feature = versions.get(version);
            if (feature == null) {
                if (org.apache.karaf.features.internal.model.Feature.DEFAULT_VERSION.equals(version)) {
                    Version latest = new Version(FeaturesServiceImpl.cleanupVersion(version));
                    for (String available : versions.keySet()) {
                        Version availableVersion = new Version(FeaturesServiceImpl.cleanupVersion(available));
                        if (availableVersion.compareTo(latest) <= 0) continue;
                        feature = versions.get(available);
                        latest = availableVersion;
                    }
                } else {
                    Version latest = new Version(FeaturesServiceImpl.cleanupVersion(org.apache.karaf.features.internal.model.Feature.DEFAULT_VERSION));
                    VersionRange versionRange = new VersionRange(version, true, true);
                    for (String available : versions.keySet()) {
                        Version availableVersion = new Version(FeaturesServiceImpl.cleanupVersion(available));
                        if (availableVersion.compareTo(latest) <= 0 || !versionRange.contains(availableVersion)) continue;
                        feature = versions.get(available);
                        latest = availableVersion;
                    }
                }
            }
            return feature;
        }
        return null;
    }

    @Override
    public Feature[] getFeatures(String name) throws Exception {
        return this.getFeatures(name, org.apache.karaf.features.internal.model.Feature.DEFAULT_VERSION);
    }

    @Override
    public Feature getFeature(String name) throws Exception {
        return this.getFeature(name, org.apache.karaf.features.internal.model.Feature.DEFAULT_VERSION);
    }

    @Override
    public Feature getFeature(String name, String version) throws Exception {
        if (this.getFeatures(name, version).length < 1) {
            return null;
        }
        return this.getFeatures(name, version)[0];
    }

    protected Map<String, Map<String, Feature>> getFeatures() throws Exception {
        if (this.features == null) {
            boolean newRepo;
            HashMap<String, Map<String, Feature>> map = new HashMap<String, Map<String, Feature>>();
            do {
                newRepo = false;
                for (Repository repo : this.listRepositories()) {
                    for (URI uri : repo.getRepositories()) {
                        if (this.repositories.containsKey(uri)) continue;
                        this.internalAddRepository(uri);
                        newRepo = true;
                    }
                }
            } while (newRepo);
            for (Repository repo : this.repositories.values()) {
                for (Feature f : repo.getFeatures()) {
                    if (map.get(f.getName()) == null) {
                        HashMap<String, Feature> versionMap = new HashMap<String, Feature>();
                        versionMap.put(f.getVersion(), f);
                        map.put(f.getName(), versionMap);
                        continue;
                    }
                    ((Map)map.get(f.getName())).put(f.getVersion(), f);
                }
            }
            this.features = map;
        }
        return this.features;
    }

    private void initState() {
        if (!this.loadState()) {
            if (this.uris != null) {
                for (URI uri : this.uris) {
                    try {
                        this.internalAddRepository(uri);
                    }
                    catch (Exception e) {
                        LOGGER.warn(String.format("Unable to add features repository %s at startup", uri), (Throwable)e);
                    }
                }
            }
            this.saveState();
        }
    }

    public void start() throws Exception {
        this.eventAdminListener = this.bundleManager.createAndRegisterEventAdminListener();
        this.initState();
    }

    public void stop() throws Exception {
        this.stopped.set(true);
        this.uris = new HashSet<URI>(this.repositories.keySet());
        while (!this.repositories.isEmpty()) {
            this.internalRemoveRepository(this.repositories.keySet().iterator().next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveState() {
        if (this.stopped.get()) {
            return;
        }
        FileOutputStream os = null;
        try {
            File file = this.bundleManager.getDataFile("FeaturesServiceState.properties");
            Properties props = new Properties();
            this.saveSet(props, "repositories.", this.repositories.keySet());
            this.saveMap(props, "features.", this.installed);
            os = new FileOutputStream(file);
            props.store(new FileOutputStream(file), "FeaturesService State");
            this.close(os);
        }
        catch (Exception e) {
            LOGGER.error("Error persisting FeaturesService state", (Throwable)e);
        }
        finally {
            this.close(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadState() {
        try {
            File file = this.bundleManager.getDataFile("FeaturesServiceState.properties");
            if (!file.exists()) {
                return false;
            }
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(file);
            try {
                props.load(is);
            }
            finally {
                this.close(is);
            }
            Set<URI> repositories = this.loadSet(props, "repositories.");
            for (URI repo : repositories) {
                try {
                    this.internalAddRepository(repo);
                }
                catch (Exception e) {
                    LOGGER.warn(String.format("Unable to add features repository %s at startup", repo), (Throwable)e);
                }
            }
            this.installed = this.loadMap(props, "features.");
            for (Feature f : this.installed.keySet()) {
                this.callListeners(new FeatureEvent(f, FeatureEvent.EventType.FeatureInstalled, true));
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Error loading FeaturesService state", (Throwable)e);
            return false;
        }
    }

    private void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void saveSet(Properties props, String prefix, Set<URI> set) {
        ArrayList<URI> l = new ArrayList<URI>(set);
        props.clear();
        props.put(prefix + "count", Integer.toString(l.size()));
        for (int i = 0; i < l.size(); ++i) {
            props.put(prefix + "item." + i, ((URI)l.get(i)).toString());
        }
    }

    protected Set<URI> loadSet(Properties props, String prefix) {
        HashSet<URI> l = new HashSet<URI>();
        String countStr = (String)props.get(prefix + "count");
        if (countStr != null) {
            int count = Integer.parseInt(countStr);
            for (int i = 0; i < count; ++i) {
                l.add(URI.create((String)props.get(prefix + "item." + i)));
            }
        }
        return l;
    }

    protected void saveMap(Properties props, String prefix, Map<Feature, Set<Long>> map) {
        for (Map.Entry<Feature, Set<Long>> entry : map.entrySet()) {
            Feature key = entry.getKey();
            String val = this.createValue(entry.getValue());
            props.put(prefix + key.toString(), val);
        }
    }

    protected Map<Feature, Set<Long>> loadMap(Properties props, String prefix) {
        HashMap<Feature, Set<Long>> map = new HashMap<Feature, Set<Long>>();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(prefix)) continue;
            String val = (String)props.get(key);
            Set<Long> set = this.readValue(val);
            map.put(org.apache.karaf.features.internal.model.Feature.valueOf(key.substring(prefix.length())), set);
        }
        return map;
    }

    protected String createValue(Set<Long> set) {
        StringBuilder sb = new StringBuilder();
        for (long i : set) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(i);
        }
        return sb.toString();
    }

    protected Set<Long> readValue(String val) {
        HashSet<Long> set = new HashSet<Long>();
        if (val != null && val.length() != 0) {
            for (String str : val.split(",")) {
                set.add(Long.parseLong(str));
            }
        }
        return set;
    }

    protected void callListeners(FeatureEvent event) {
        if (this.eventAdminListener != null) {
            this.eventAdminListener.featureEvent(event);
        }
        for (FeaturesListener listener : this.listeners) {
            listener.featureEvent(event);
        }
    }

    protected void callListeners(RepositoryEvent event) {
        if (this.eventAdminListener != null) {
            this.eventAdminListener.repositoryEvent(event);
        }
        for (FeaturesListener listener : this.listeners) {
            listener.repositoryEvent(event);
        }
    }

    public static String cleanupVersion(String version) {
        Matcher m = fuzzyVersion.matcher(version);
        if (m.matches()) {
            StringBuffer result = new StringBuffer();
            String d1 = m.group(1);
            String d2 = m.group(3);
            String d3 = m.group(5);
            String qualifier = m.group(7);
            if (d1 != null) {
                result.append(d1);
                if (d2 != null) {
                    result.append(".");
                    result.append(d2);
                    if (d3 != null) {
                        result.append(".");
                        result.append(d3);
                        if (qualifier != null) {
                            result.append(".");
                            FeaturesServiceImpl.cleanupModifier(result, qualifier);
                        }
                    } else if (qualifier != null) {
                        result.append(".0.");
                        FeaturesServiceImpl.cleanupModifier(result, qualifier);
                    }
                } else if (qualifier != null) {
                    result.append(".0.0.");
                    FeaturesServiceImpl.cleanupModifier(result, qualifier);
                }
                return result.toString();
            }
        }
        return version;
    }

    static void cleanupModifier(StringBuffer result, String modifier) {
        Matcher m = fuzzyModifier.matcher(modifier);
        if (m.matches()) {
            modifier = m.group(2);
        }
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') && c != '-') continue;
            result.append(c);
        }
    }

    public Set<Feature> getFeaturesContainingBundle(Bundle bundle) throws Exception {
        HashSet<Feature> features = new HashSet<Feature>();
        for (Map<String, Feature> featureMap : this.getFeatures().values()) {
            block1: for (Feature f : featureMap.values()) {
                for (BundleInfo bi : f.getBundles()) {
                    if (!bi.getLocation().equals(bundle.getLocation())) continue;
                    features.add(f);
                    continue block1;
                }
            }
        }
        return features;
    }

    private String getFeaturesContainingBundleList(Bundle bundle) throws Exception {
        Set<Feature> features = this.getFeaturesContainingBundle(bundle);
        StringBuilder buffer = new StringBuilder();
        Iterator<Feature> iter = features.iterator();
        while (iter.hasNext()) {
            Feature feature = iter.next();
            buffer.append(feature.getId());
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    private Feature getFeatureForDependency(Dependency dependency) throws Exception {
        Map<String, Feature> avail;
        VersionRange range = org.apache.karaf.features.internal.model.Feature.DEFAULT_VERSION.equals(dependency.getVersion()) ? VersionRange.ANY_VERSION : new VersionRange(dependency.getVersion(), true, true);
        Feature fi = null;
        for (Feature f : this.installed.keySet()) {
            Version v;
            if (!f.getName().equals(dependency.getName()) || !range.contains(v = VersionTable.getVersion(f.getVersion())) || fi != null && VersionTable.getVersion(fi.getVersion()).compareTo(v) >= 0) continue;
            fi = f;
        }
        if (fi == null && (avail = this.getFeatures().get(dependency.getName())) != null) {
            for (Feature f : avail.values()) {
                Version v = VersionTable.getVersion(f.getVersion());
                if (!range.contains(v) || fi != null && VersionTable.getVersion(fi.getVersion()).compareTo(v) >= 0) continue;
                fi = f;
            }
        }
        return fi;
    }

    private boolean dependenciesSatisfied(List<? extends Dependency> dependencies, InstallationState state) throws Exception {
        boolean satisfied = true;
        for (Dependency dependency : dependencies) {
            Feature f = this.getFeatureForDependency(dependency);
            if (f == null || this.isInstalled(f) || state == null || state.features.keySet().contains(f)) continue;
            satisfied = false;
        }
        return satisfied;
    }

    public boolean isRespectStartLvlDuringFeatureUninstall() {
        return this.respectStartLvlDuringFeatureUninstall;
    }

    public void setRespectStartLvlDuringFeatureUninstall(boolean respectStartLvlDuringFeatureUninstall) {
        this.respectStartLvlDuringFeatureUninstall = respectStartLvlDuringFeatureUninstall;
    }
}

