/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.support.table;

import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.gogo.runtime.threadio.ThreadPrintStream;
import org.apache.karaf.shell.support.table.Col;
import org.apache.karaf.shell.support.table.Row;

public class ShellTable {
    private static final char SEP_HORIZONTAL = '\u2500';
    private static final char SEP_VERTICAL = '\u2502';
    private static final char SEP_CROSS = '\u253c';
    private static final char SEP_HORIZONTAL_ASCII = '-';
    private static final char SEP_VERTICAL_ASCII = '|';
    private static final char SEP_CROSS_ASCII = '+';
    private static final String DEFAULT_SEPARATOR = " \u2502 ";
    private static final String DEFAULT_SEPARATOR_ASCII = " | ";
    private static final String DEFAULT_SEPARATOR_NO_FORMAT = "\t";
    private List<Col> cols = new ArrayList<Col>();
    private List<Row> rows = new ArrayList<Row>();
    private boolean showHeaders = true;
    private String separator = " \u2502 ";
    private int size;
    private String emptyTableText;
    private boolean forceAscii;

    public ShellTable noHeaders() {
        this.showHeaders = false;
        return this;
    }

    public ShellTable separator(String separator) {
        this.separator = separator;
        return this;
    }

    public ShellTable size(int size) {
        this.size = size;
        return this;
    }

    public ShellTable column(Col colunmn) {
        this.cols.add(colunmn);
        return this;
    }

    public Col column(String header) {
        Col col = new Col(header);
        this.cols.add(col);
        return col;
    }

    public Row addRow() {
        Row row = new Row();
        this.rows.add(row);
        return row;
    }

    public ShellTable forceAscii() {
        this.forceAscii = true;
        return this;
    }

    public ShellTable emptyTableText(String text) {
        this.emptyTableText = text;
        return this;
    }

    public void print(PrintStream out) {
        this.print(out, true);
    }

    public void print(PrintStream out, boolean format) {
        boolean unicode = this.supportsUnicode(out);
        String separator = unicode ? this.separator : DEFAULT_SEPARATOR_ASCII;
        Row headerRow = new Row(this.cols);
        headerRow.formatContent(this.cols);
        for (Row row : this.rows) {
            row.formatContent(this.cols);
        }
        if (this.size > 0) {
            this.adjustSize();
        }
        if (format && this.showHeaders) {
            String headerLine = headerRow.getContent(this.cols, separator);
            out.println(headerLine);
            int iCol = 0;
            for (Col col : this.cols) {
                if (iCol++ == 0) {
                    out.print(this.underline(col.getSize(), false, unicode));
                } else {
                    out.print(this.underline(col.getSize() + 3, true, unicode));
                }
                ++iCol;
            }
            out.println();
        }
        for (Row row : this.rows) {
            if (!format) {
                if (separator == null || separator.equals(DEFAULT_SEPARATOR)) {
                    out.println(row.getContent(this.cols, DEFAULT_SEPARATOR_NO_FORMAT));
                    continue;
                }
                out.println(row.getContent(this.cols, separator));
                continue;
            }
            out.println(row.getContent(this.cols, separator));
        }
        if (format && this.rows.size() == 0 && this.emptyTableText != null) {
            out.println(this.emptyTableText);
        }
    }

    private boolean supportsUnicode(PrintStream out) {
        if (this.forceAscii) {
            return false;
        }
        String encoding = this.getEncoding(out);
        if (encoding == null) {
            return false;
        }
        CharsetEncoder encoder = Charset.forName(encoding).newEncoder();
        return encoder.canEncode(this.separator) && encoder.canEncode('\u2500') && encoder.canEncode('\u253c');
    }

    private String getEncoding(PrintStream ps) {
        if (ps.getClass() == ThreadPrintStream.class) {
            try {
                ps = (PrintStream)ps.getClass().getMethod("getCurrent", new Class[0]).invoke((Object)ps, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            Field f = ps.getClass().getDeclaredField("charOut");
            f.setAccessible(true);
            OutputStreamWriter osw = (OutputStreamWriter)f.get(ps);
            return osw.getEncoding();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void adjustSize() {
        int currentSize = 0;
        for (Col col : this.cols) {
            currentSize += col.size + this.separator.length();
        }
        int sizeToGrow = this.size - (currentSize -= this.separator.length());
        for (int i = this.cols.size() - 1; i >= 0; --i) {
            Col col = this.cols.get(i);
            if (col.maxSize != -1) continue;
            col.size = Math.max(0, col.size + sizeToGrow);
            return;
        }
    }

    private String underline(int length, boolean crossAtBeg, boolean supported) {
        char[] exmarks = new char[length];
        Arrays.fill(exmarks, supported ? (char)'\u2500' : '-');
        if (crossAtBeg) {
            exmarks[1] = supported ? 9532 : 43;
        }
        return new String(exmarks);
    }
}

