/**
  * Licensed to the Apache Software Foundation (ASF) under one
  * or more contributor license agreements. See the NOTICE file
  * distributed with this work for additional information
  * regarding copyright ownership. The ASF licenses this file
  * to you under the Apache License, Version 2.0 (the
  * "License"); you may not use this file except in compliance
  * with the License. You may obtain a copy of the License at
  *
  * http://www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing,
  * software distributed under the License is distributed on an
  * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  * KIND, either express or implied. See the License for the
  * specific language governing permissions and limitations
  * under the License.
  */

package org.apache.mahout.math.algorithms.preprocessing

import org.apache.mahout.math.algorithms.{UnsupervisedFitter, UnsupervisedModel}
import org.apache.mahout.math.drm.DrmLike

trait PreprocessorModel extends UnsupervisedModel {

  /**
    * A convenience method for returning transformed data back to original
    * @param input
    * @tparam K
    * @return
    */
  def invTransform[K](input: DrmLike[K]): DrmLike[K]

  /**
    * Transform given Drm given the feature set
    * @param input

    */
  def transform[K](input: DrmLike[K]): DrmLike[K]

}

trait PreprocessorFitter extends UnsupervisedFitter {

  def fit[K](input: DrmLike[K],
             hyperparameters: (Symbol, Any)*): PreprocessorModel

  def fitTransform[K](input: DrmLike[K],
                      hyperparameters: (Symbol, Any)*): DrmLike[K] = {
    model = this.fit(input, hyperparameters:_*)
    model.transform(input)

  }

  // used to store the model if `fitTransform` method called
  var model: PreprocessorModel = _
}