/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler;

import org.apache.vysper.xml.fragment.XMLElement;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.PubSubServiceConfiguration;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.handler.AbstractPubSubGeneralHandler;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.CollectionNode;
import org.apache.vysper.xmpp.modules.extension.xep0060_pubsub.model.LeafNode;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaBuilder;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

public class PubSubSubscribeHandler
extends AbstractPubSubGeneralHandler {
    public PubSubSubscribeHandler(PubSubServiceConfiguration serviceConfiguration) {
        super(serviceConfiguration);
    }

    protected String getWorkerElement() {
        return "subscribe";
    }

    protected Stanza handleSet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        Entity serverJID = this.serviceConfiguration.getDomainJID();
        CollectionNode root = this.serviceConfiguration.getRootNode();
        Entity sender = PubSubSubscribeHandler.extractSenderJID((XMPPCoreStanza)stanza, (SessionContext)sessionContext);
        EntityImpl subJID = null;
        StanzaBuilder sb = StanzaBuilder.createDirectReply((XMPPCoreStanza)stanza, (boolean)false, (IQStanzaType)IQStanzaType.RESULT);
        sb.startInnerElement("pubsub", "http://jabber.org/protocol/pubsub");
        XMLElement sub = stanza.getFirstInnerElement().getFirstInnerElement();
        String strSubJID = sub.getAttributeValue("jid");
        try {
            subJID = EntityImpl.parse((String)strSubJID);
        }
        catch (EntityFormatException e) {
            return this.errorStanzaGenerator.generateJIDMalformedErrorStanza(sender, serverJID, stanza);
        }
        if (!sender.getBareJID().equals(subJID.getBareJID())) {
            return this.errorStanzaGenerator.generateJIDDontMatchErrorStanza(sender, serverJID, stanza);
        }
        String nodeName = this.extractNodeName(stanza);
        LeafNode node = root.find(nodeName);
        if (node == null) {
            return this.errorStanzaGenerator.generateNoNodeErrorStanza(sender, serverJID, stanza);
        }
        String id = this.idGenerator.create();
        node.subscribe(id, (Entity)subJID);
        this.buildSuccessStanza(sb, nodeName, strSubJID, id);
        sb.endInnerElement();
        return new IQStanza((Stanza)sb.build());
    }

    private void buildSuccessStanza(StanzaBuilder sb, String nodeName, String jid, String subid) {
        sb.startInnerElement("subscription", "http://jabber.org/protocol/pubsub");
        sb.addAttribute("node", nodeName);
        sb.addAttribute("jid", jid);
        sb.addAttribute("subid", subid);
        sb.addAttribute("subscription", "subscribed");
        sb.endInnerElement();
    }
}

