/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.core.base.handler;

import org.apache.vysper.xmpp.modules.core.base.handler.IQHandler;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.IQStanza;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;
import org.apache.vysper.xmpp.writer.DenseStanzaLogRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultIQHandler
extends IQHandler {
    final Logger logger = LoggerFactory.getLogger(DefaultIQHandler.class);

    public boolean verify(Stanza stanza) {
        return super.verify(stanza) && this.verifyInnerElement(stanza);
    }

    protected boolean verifyInnerElement(Stanza stanza) {
        return true;
    }

    protected boolean verifyInnerElementWorker(Stanza stanza, String firstInnerElement) {
        return stanza != null && stanza.getVerifier().subElementsPresentExact(1) && stanza.getVerifier().subElementPresent(firstInnerElement);
    }

    protected abstract boolean verifyNamespace(Stanza var1);

    protected Stanza executeIQLogic(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, boolean outboundStanza, SessionContext sessionContext) {
        switch (stanza.getIQType()) {
            case ERROR: {
                this.handleError(stanza, serverRuntimeContext, sessionContext);
                return null;
            }
            case GET: {
                return this.handleGet(stanza, serverRuntimeContext, sessionContext);
            }
            case RESULT: {
                return this.handleResult(stanza, serverRuntimeContext, sessionContext);
            }
            case SET: {
                return this.handleSet(stanza, serverRuntimeContext, sessionContext);
            }
        }
        throw new RuntimeException("iq stanza type not supported: " + stanza.getIQType().value());
    }

    protected Stanza handleResult(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        this.logger.warn("IQ 'result' stanza not handled by {}: {}", (Object)this.getClass().getCanonicalName(), (Object)DenseStanzaLogRenderer.render(stanza));
        return ServerErrorResponses.getStanzaError(StanzaErrorCondition.FEATURE_NOT_IMPLEMENTED, stanza, StanzaErrorType.CANCEL, "iq stanza of type 'result' is not handled for this namespace", this.getErrorLanguage(serverRuntimeContext, sessionContext), null);
    }

    protected Stanza handleGet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        this.logger.warn("IQ 'get' stanza not handled by {}: {}", (Object)this.getClass().getCanonicalName(), (Object)DenseStanzaLogRenderer.render(stanza));
        return ServerErrorResponses.getStanzaError(StanzaErrorCondition.FEATURE_NOT_IMPLEMENTED, stanza, StanzaErrorType.CANCEL, "iq stanza of type 'get' is not handled for this namespace", this.getErrorLanguage(serverRuntimeContext, sessionContext), null);
    }

    protected void handleError(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        this.logger.warn("IQ 'error' stanza not handled by {}: {}", (Object)this.getClass().getCanonicalName(), (Object)DenseStanzaLogRenderer.render(stanza));
        throw new RuntimeException("iq stanza type ERROR not yet handled");
    }

    protected Stanza handleSet(IQStanza stanza, ServerRuntimeContext serverRuntimeContext, SessionContext sessionContext) {
        this.logger.warn("IQ 'set' stanza not handled by {}: {}", (Object)this.getClass().getCanonicalName(), (Object)DenseStanzaLogRenderer.render(stanza));
        return ServerErrorResponses.getStanzaError(StanzaErrorCondition.FEATURE_NOT_IMPLEMENTED, stanza, StanzaErrorType.CANCEL, "iq stanza of type 'set' is not handled for this namespace", this.getErrorLanguage(serverRuntimeContext, sessionContext), null);
    }
}

