/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.protocol.worker;

import org.apache.vysper.xmpp.protocol.ProtocolException;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainer;
import org.apache.vysper.xmpp.protocol.ResponseWriter;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.protocol.StateAwareProtocolWorker;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.stanza.Stanza;

public abstract class AbstractStateAwareProtocolWorker
implements StateAwareProtocolWorker {
    public abstract SessionState getHandledState();

    public void processStanza(SessionContext sessionContext, SessionStateHolder sessionStateHolder, Stanza stanza, StanzaHandler stanzaHandler) {
        boolean proceed = this.checkState(sessionContext, sessionStateHolder, stanza, stanzaHandler);
        if (!proceed) {
            return;
        }
        ResponseStanzaContainer responseStanzaContainer = this.executeHandler(sessionContext, sessionStateHolder, stanza, stanzaHandler);
        this.writeResponse(sessionContext, responseStanzaContainer);
    }

    protected boolean checkState(SessionContext sessionContext, SessionStateHolder sessionStateHolder, Stanza stanza, StanzaHandler stanzaHandler) {
        return 0 == this.getHandledState().compareTo(sessionContext.getState());
    }

    protected void writeResponse(SessionContext sessionContext, ResponseStanzaContainer responseStanzaContainer) {
        if (responseStanzaContainer != null && responseStanzaContainer.getResponseStanza() != null) {
            if (sessionContext == null) {
                throw new IllegalStateException("no session context to write stanza to: " + (Object)((Object)responseStanzaContainer.getResponseStanza()));
            }
            ResponseWriter.writeResponse(sessionContext, responseStanzaContainer);
        }
    }

    protected ResponseStanzaContainer executeHandler(SessionContext sessionContext, SessionStateHolder sessionStateHolder, Stanza stanza, StanzaHandler stanzaHandler) {
        ResponseStanzaContainer responseStanzaContainer = null;
        try {
            responseStanzaContainer = stanzaHandler.execute(stanza, sessionContext.getServerRuntimeContext(), this.isProcessingOutboundStanzas(), sessionContext, sessionStateHolder);
        }
        catch (ProtocolException e) {
            ResponseWriter.handleProtocolError(e, sessionContext, stanza);
            return null;
        }
        return responseStanzaContainer;
    }

    protected boolean isProcessingOutboundStanzas() {
        return true;
    }
}

