/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;

public abstract class AbstractSessionManager
extends AbstractLifeCycle
implements SessionManager {
    public static final int __distantFuture = 628992000;
    private static final HttpSessionContext __nullSessionContext = new NullSessionContext();
    private boolean _usingCookies = true;
    protected int _dftMaxIdleSecs = -1;
    protected SessionHandler _sessionHandler;
    protected boolean _httpOnly = false;
    protected SessionIdManager _sessionIdManager;
    protected boolean _secureCookies = false;
    protected Object _sessionAttributeListeners;
    protected Object _sessionListeners;
    protected ClassLoader _loader;
    protected ContextHandler.Context _context;
    protected String _sessionCookie = "JSESSIONID";
    protected String _sessionIdPathParameterName = "jsessionid";
    protected String _sessionIdPathParameterNamePrefix = ";" + this._sessionIdPathParameterName + "=";
    protected String _sessionDomain;
    protected String _sessionPath;
    protected int _maxCookieAge = -1;
    protected int _refreshCookieAge;
    protected boolean _nodeIdInSessionId;
    protected boolean _checkingRemoteSessionIdEncoding;
    protected final CounterStatistic _sessionsStats = new CounterStatistic();
    protected final SampleStatistic _sessionTimeStats = new SampleStatistic();

    public HttpCookie access(HttpSession session, boolean secure) {
        long now = System.currentTimeMillis();
        Session s = ((SessionIf)session).getSession();
        s.access(now);
        if (this.isUsingCookies() && (s.isIdChanged() || this.getMaxCookieAge() > 0 && this.getRefreshCookieAge() > 0 && (now - s.getCookieSetTime()) / 1000L > (long)this.getRefreshCookieAge())) {
            HttpCookie cookie = this.getSessionCookie(session, this._context == null ? "/" : this._context.getContextPath(), secure);
            s.cookieSet();
            s.setIdChanged(false);
            return cookie;
        }
        return null;
    }

    public void addEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners = LazyList.add((Object)this._sessionAttributeListeners, (Object)listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners = LazyList.add((Object)this._sessionListeners, (Object)listener);
        }
    }

    public void clearEventListeners() {
        this._sessionAttributeListeners = null;
        this._sessionListeners = null;
    }

    public void complete(HttpSession session) {
        Session s = ((SessionIf)session).getSession();
        s.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws Exception {
        this._context = ContextHandler.getCurrentContext();
        this._loader = Thread.currentThread().getContextClassLoader();
        if (this._sessionIdManager == null) {
            Server server;
            Server server2 = server = this.getSessionHandler().getServer();
            synchronized (server2) {
                this._sessionIdManager = server.getSessionIdManager();
                if (this._sessionIdManager == null) {
                    this._sessionIdManager = new HashSessionIdManager();
                    server.setSessionIdManager(this._sessionIdManager);
                }
            }
        }
        if (!this._sessionIdManager.isStarted()) {
            this._sessionIdManager.start();
        }
        if (this._context != null) {
            String tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionCookie");
            if (tmp != null) {
                this._sessionCookie = tmp;
            }
            if ((tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionIdPathParameterName")) != null) {
                this.setSessionIdPathParameterName(tmp);
            }
            if (this._maxCookieAge == -1 && (tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.MaxAge")) != null) {
                this._maxCookieAge = Integer.parseInt(tmp.trim());
            }
            if (this._sessionDomain == null) {
                this._sessionDomain = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionDomain");
            }
            if (this._sessionPath == null) {
                this._sessionPath = this._context.getInitParameter("org.eclipse.jetty.servlet.SessionPath");
            }
            if ((tmp = this._context.getInitParameter("org.eclipse.jetty.servlet.CheckingRemoteSessionIdEncoding")) != null) {
                this._checkingRemoteSessionIdEncoding = Boolean.parseBoolean(tmp);
            }
        }
        super.doStart();
    }

    public void doStop() throws Exception {
        super.doStop();
        this.invalidateSessions();
        this._loader = null;
    }

    public boolean getHttpOnly() {
        return this._httpOnly;
    }

    public HttpSession getHttpSession(String nodeId) {
        String cluster_id = this.getIdManager().getClusterId(nodeId);
        Session session = this.getSession(cluster_id);
        if (session != null && !session.getNodeId().equals(nodeId)) {
            session.setIdChanged(true);
        }
        return session;
    }

    public SessionIdManager getIdManager() {
        return this._sessionIdManager;
    }

    public int getMaxCookieAge() {
        return this._maxCookieAge;
    }

    public int getMaxInactiveInterval() {
        return this._dftMaxIdleSecs;
    }

    @Deprecated
    public int getMaxSessions() {
        return this.getSessionsMax();
    }

    public int getSessionsMax() {
        return (int)this._sessionsStats.getMax();
    }

    public int getSessionsTotal() {
        return (int)this._sessionsStats.getTotal();
    }

    @Deprecated
    public SessionIdManager getMetaManager() {
        return this.getIdManager();
    }

    @Deprecated
    public int getMinSessions() {
        return 0;
    }

    public int getRefreshCookieAge() {
        return this._refreshCookieAge;
    }

    public boolean getSecureCookies() {
        return this._secureCookies;
    }

    public String getSessionCookie() {
        return this._sessionCookie;
    }

    public HttpCookie getSessionCookie(HttpSession session, String contextPath, boolean requestIsSecure) {
        if (this.isUsingCookies()) {
            String sessionPath = this._sessionPath == null ? contextPath : this._sessionPath;
            sessionPath = sessionPath == null || sessionPath.length() == 0 ? "/" : sessionPath;
            String id = this.getNodeId(session);
            HttpCookie cookie = new HttpCookie(this._sessionCookie, id, this._sessionDomain, sessionPath, this.getMaxCookieAge(), this.getHttpOnly(), requestIsSecure && this.getSecureCookies());
            return cookie;
        }
        return null;
    }

    public String getSessionDomain() {
        return this._sessionDomain;
    }

    public SessionHandler getSessionHandler() {
        return this._sessionHandler;
    }

    public abstract Map getSessionMap();

    public String getSessionPath() {
        return this._sessionPath;
    }

    public int getSessions() {
        return (int)this._sessionsStats.getCurrent();
    }

    public String getSessionIdPathParameterName() {
        return this._sessionIdPathParameterName;
    }

    public String getSessionIdPathParameterNamePrefix() {
        return this._sessionIdPathParameterNamePrefix;
    }

    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    public boolean isValid(HttpSession session) {
        Session s = ((SessionIf)session).getSession();
        return s.isValid();
    }

    public String getClusterId(HttpSession session) {
        Session s = ((SessionIf)session).getSession();
        return s.getClusterId();
    }

    public String getNodeId(HttpSession session) {
        Session s = ((SessionIf)session).getSession();
        return s.getNodeId();
    }

    public HttpSession newHttpSession(HttpServletRequest request) {
        Session session = this.newSession(request);
        session.setMaxInactiveInterval(this._dftMaxIdleSecs);
        this.addSession(session, true);
        return session;
    }

    public void removeEventListener(EventListener listener) {
        if (listener instanceof HttpSessionAttributeListener) {
            this._sessionAttributeListeners = LazyList.remove((Object)this._sessionAttributeListeners, (Object)listener);
        }
        if (listener instanceof HttpSessionListener) {
            this._sessionListeners = LazyList.remove((Object)this._sessionListeners, (Object)listener);
        }
    }

    @Deprecated
    public void resetStats() {
        this.statsReset();
    }

    public void statsReset() {
        this._sessionsStats.reset((long)this.getSessions());
        this._sessionTimeStats.reset();
    }

    public void setHttpOnly(boolean httpOnly) {
        this._httpOnly = httpOnly;
    }

    public void setIdManager(SessionIdManager metaManager) {
        this._sessionIdManager = metaManager;
    }

    public void setMaxCookieAge(int maxCookieAgeInSeconds) {
        this._maxCookieAge = maxCookieAgeInSeconds;
        if (this._maxCookieAge > 0 && this._refreshCookieAge == 0) {
            this._refreshCookieAge = this._maxCookieAge / 3;
        }
    }

    public void setMaxInactiveInterval(int seconds) {
        this._dftMaxIdleSecs = seconds;
    }

    @Deprecated
    public void setMetaManager(SessionIdManager metaManager) {
        this.setIdManager(metaManager);
    }

    public void setRefreshCookieAge(int ageInSeconds) {
        this._refreshCookieAge = ageInSeconds;
    }

    public void setSecureCookies(boolean secureCookies) {
        this._secureCookies = secureCookies;
    }

    public void setSessionCookie(String cookieName) {
        this._sessionCookie = cookieName;
    }

    public void setSessionDomain(String domain) {
        this._sessionDomain = domain;
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this._sessionHandler = sessionHandler;
    }

    public void setSessionPath(String path) {
        this._sessionPath = path;
    }

    public void setSessionIdPathParameterName(String param) {
        this._sessionIdPathParameterName = param == null || "none".equals(param) ? null : param;
        this._sessionIdPathParameterNamePrefix = param == null || "none".equals(param) ? null : ";" + this._sessionIdPathParameterName + "=";
    }

    public void setUsingCookies(boolean usingCookies) {
        this._usingCookies = usingCookies;
    }

    protected abstract void addSession(Session var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSession(Session session, boolean created) {
        SessionIdManager sessionIdManager = this._sessionIdManager;
        synchronized (sessionIdManager) {
            this._sessionIdManager.addSession(session);
            this.addSession(session);
        }
        if (created) {
            this._sessionsStats.increment();
            if (this._sessionListeners != null) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                for (int i = 0; i < LazyList.size((Object)this._sessionListeners); ++i) {
                    ((HttpSessionListener)LazyList.get((Object)this._sessionListeners, (int)i)).sessionCreated(event);
                }
            }
        }
    }

    public abstract Session getSession(String var1);

    protected abstract void invalidateSessions();

    protected abstract Session newSession(HttpServletRequest var1);

    public boolean isNodeIdInSessionId() {
        return this._nodeIdInSessionId;
    }

    public void setNodeIdInSessionId(boolean nodeIdInSessionId) {
        this._nodeIdInSessionId = nodeIdInSessionId;
    }

    public void removeSession(HttpSession session, boolean invalidate) {
        Session s = ((SessionIf)session).getSession();
        this.removeSession(s, invalidate);
    }

    public void removeSession(Session session, boolean invalidate) {
        boolean removed = this.removeSession(session.getClusterId());
        if (removed) {
            this._sessionsStats.decrement();
            this._sessionTimeStats.set(Math.round((double)(System.currentTimeMillis() - session.getCreationTime()) / 1000.0));
            this._sessionIdManager.removeSession(session);
            if (invalidate) {
                this._sessionIdManager.invalidateAll(session.getClusterId());
            }
            if (invalidate && this._sessionListeners != null) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                int i = LazyList.size((Object)this._sessionListeners);
                while (i-- > 0) {
                    ((HttpSessionListener)LazyList.get((Object)this._sessionListeners, (int)i)).sessionDestroyed(event);
                }
            }
        }
    }

    protected abstract boolean removeSession(String var1);

    public long getSessionTimeMax() {
        return this._sessionTimeStats.getMax();
    }

    public long getSessionTimeTotal() {
        return this._sessionTimeStats.getTotal();
    }

    public double getSessionTimeMean() {
        return this._sessionTimeStats.getMean();
    }

    public double getSessionTimeStdDev() {
        return this._sessionTimeStats.getStdDev();
    }

    public boolean isCheckingRemoteSessionIdEncoding() {
        return this._checkingRemoteSessionIdEncoding;
    }

    public void setCheckingRemoteSessionIdEncoding(boolean remote) {
        this._checkingRemoteSessionIdEncoding = remote;
    }

    public abstract class Session
    implements SessionIf,
    Serializable {
        protected final String _clusterId;
        protected final String _nodeId;
        protected final Map<String, Object> _attributes = new HashMap<String, Object>();
        protected boolean _idChanged;
        protected final long _created;
        protected long _cookieSet;
        protected long _accessed;
        protected long _lastAccessed;
        protected boolean _invalid;
        protected boolean _doInvalidate;
        protected long _maxIdleMs;
        protected boolean _newSession;
        protected int _requests;

        protected Session(HttpServletRequest request) {
            this._maxIdleMs = AbstractSessionManager.this._dftMaxIdleSecs > 0 ? (long)(AbstractSessionManager.this._dftMaxIdleSecs * 1000) : -1L;
            this._newSession = true;
            this._created = System.currentTimeMillis();
            this._clusterId = AbstractSessionManager.this._sessionIdManager.newSessionId(request, this._created);
            this._nodeId = AbstractSessionManager.this._sessionIdManager.getNodeId(this._clusterId, request);
            this._accessed = this._created;
            this._lastAccessed = this._created;
            this._requests = 1;
            Log.debug((String)("new session & id " + this._nodeId + " " + this._clusterId));
        }

        protected Session(long created, long accessed, String clusterId) {
            this._maxIdleMs = AbstractSessionManager.this._dftMaxIdleSecs > 0 ? (long)(AbstractSessionManager.this._dftMaxIdleSecs * 1000) : -1L;
            this._created = created;
            this._clusterId = clusterId;
            this._nodeId = AbstractSessionManager.this._sessionIdManager.getNodeId(this._clusterId, null);
            this._accessed = accessed;
            this._lastAccessed = accessed;
            this._requests = 1;
            Log.debug((String)("new session " + this._nodeId + " " + this._clusterId));
        }

        protected boolean isNotAvailable() {
            return this._invalid;
        }

        public Session getSession() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getAttribute(String name) {
            Session session = this;
            synchronized (session) {
                if (this.isNotAvailable()) {
                    throw new IllegalStateException();
                }
                return this._attributes.get(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enumeration getAttributeNames() {
            Session session = this;
            synchronized (session) {
                if (this.isNotAvailable()) {
                    throw new IllegalStateException();
                }
                List<Object> names = this._attributes == null ? Collections.EMPTY_LIST : new ArrayList<String>(this._attributes.keySet());
                return Collections.enumeration(names);
            }
        }

        public long getCookieSetTime() {
            return this._cookieSet;
        }

        public long getCreationTime() throws IllegalStateException {
            if (this.isNotAvailable()) {
                throw new IllegalStateException();
            }
            return this._created;
        }

        public String getId() throws IllegalStateException {
            return AbstractSessionManager.this._nodeIdInSessionId ? this._nodeId : this._clusterId;
        }

        protected String getNodeId() {
            return this._nodeId;
        }

        protected String getClusterId() {
            return this._clusterId;
        }

        public long getLastAccessedTime() throws IllegalStateException {
            if (this.isNotAvailable()) {
                throw new IllegalStateException();
            }
            return this._lastAccessed;
        }

        public int getMaxInactiveInterval() {
            if (this.isNotAvailable()) {
                throw new IllegalStateException();
            }
            return (int)(this._maxIdleMs / 1000L);
        }

        public ServletContext getServletContext() {
            return AbstractSessionManager.this._context;
        }

        @Deprecated
        public HttpSessionContext getSessionContext() throws IllegalStateException {
            if (this.isNotAvailable()) {
                throw new IllegalStateException();
            }
            return __nullSessionContext;
        }

        @Deprecated
        public Object getValue(String name) throws IllegalStateException {
            return this.getAttribute(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        public String[] getValueNames() throws IllegalStateException {
            Session session = this;
            synchronized (session) {
                if (this.isNotAvailable()) {
                    throw new IllegalStateException();
                }
                if (this._attributes == null) {
                    return new String[0];
                }
                String[] a = new String[this._attributes.size()];
                return this._attributes.keySet().toArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void access(long time) {
            Session session = this;
            synchronized (session) {
                if (!this._invalid) {
                    this._newSession = false;
                    this._lastAccessed = this._accessed;
                    this._accessed = time;
                    if (this._maxIdleMs > 0L && this._lastAccessed > 0L && this._lastAccessed + this._maxIdleMs < time) {
                        this.invalidate();
                    } else {
                        ++this._requests;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void complete() {
            Session session = this;
            synchronized (session) {
                --this._requests;
                if (this._doInvalidate && this._requests <= 0) {
                    this.doInvalidate();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void timeout() throws IllegalStateException {
            AbstractSessionManager.this.removeSession(this, true);
            Session session = this;
            synchronized (session) {
                if (!this._invalid) {
                    if (this._requests <= 0) {
                        this.doInvalidate();
                    } else {
                        this._doInvalidate = true;
                    }
                }
            }
        }

        public void invalidate() throws IllegalStateException {
            AbstractSessionManager.this.removeSession(this, true);
            this.doInvalidate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doInvalidate() throws IllegalStateException {
            try {
                Log.debug((String)"invalidate ", (Object)this._clusterId);
                if (this.isNotAvailable()) {
                    throw new IllegalStateException();
                }
                while (this._attributes != null && this._attributes.size() > 0) {
                    ArrayList<String> keys;
                    Session session = this;
                    synchronized (session) {
                        keys = new ArrayList<String>(this._attributes.keySet());
                    }
                    for (String key : keys) {
                        Object value;
                        Session session2 = this;
                        synchronized (session2) {
                            value = this._attributes.remove(key);
                        }
                        this.unbindValue(key, value);
                        if (AbstractSessionManager.this._sessionAttributeListeners == null) continue;
                        HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, key, value);
                        for (int i = 0; i < LazyList.size((Object)AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                            ((HttpSessionAttributeListener)LazyList.get((Object)AbstractSessionManager.this._sessionAttributeListeners, (int)i)).attributeRemoved(event);
                        }
                    }
                }
            }
            finally {
                this._invalid = true;
            }
        }

        public boolean isIdChanged() {
            return this._idChanged;
        }

        public boolean isNew() throws IllegalStateException {
            if (this.isNotAvailable()) {
                throw new IllegalStateException();
            }
            return this._newSession;
        }

        @Deprecated
        public void putValue(String name, Object value) throws IllegalStateException {
            this.setAttribute(name, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAttribute(String name) {
            Object old;
            Session session = this;
            synchronized (session) {
                if (this.isNotAvailable()) {
                    throw new IllegalStateException();
                }
                if (this._attributes == null) {
                    return;
                }
                old = this._attributes.remove(name);
            }
            if (old != null) {
                this.unbindValue(name, old);
                if (AbstractSessionManager.this._sessionAttributeListeners != null) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, old);
                    for (int i = 0; i < LazyList.size((Object)AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                        ((HttpSessionAttributeListener)LazyList.get((Object)AbstractSessionManager.this._sessionAttributeListeners, (int)i)).attributeRemoved(event);
                    }
                }
            }
        }

        @Deprecated
        public void removeValue(String name) throws IllegalStateException {
            this.removeAttribute(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAttribute(String name, Object value) {
            Object old_value = null;
            Session session = this;
            synchronized (session) {
                if (value == null) {
                    this.removeAttribute(name);
                    return;
                }
                if (this.isNotAvailable()) {
                    throw new IllegalStateException();
                }
                old_value = this._attributes.put(name, value);
            }
            if (old_value == null || !value.equals(old_value)) {
                this.unbindValue(name, old_value);
                this.bindValue(name, value);
                if (AbstractSessionManager.this._sessionAttributeListeners != null) {
                    HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)this, name, old_value == null ? value : old_value);
                    for (int i = 0; i < LazyList.size((Object)AbstractSessionManager.this._sessionAttributeListeners); ++i) {
                        HttpSessionAttributeListener l = (HttpSessionAttributeListener)LazyList.get((Object)AbstractSessionManager.this._sessionAttributeListeners, (int)i);
                        if (old_value == null) {
                            l.attributeAdded(event);
                            continue;
                        }
                        l.attributeReplaced(event);
                    }
                }
            }
        }

        public void setIdChanged(boolean changed) {
            this._idChanged = changed;
        }

        public void setMaxInactiveInterval(int secs) {
            this._maxIdleMs = (long)secs * 1000L;
        }

        public String toString() {
            return this.getClass().getName() + ":" + this.getId() + "@" + this.hashCode();
        }

        protected void bindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }

        protected boolean isValid() {
            return !this._invalid;
        }

        protected void cookieSet() {
            this._cookieSet = this._accessed;
        }

        protected void unbindValue(String name, Object value) {
            if (value != null && value instanceof HttpSessionBindingListener) {
                ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)this, name));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void willPassivate() {
            Session session = this;
            synchronized (session) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
                for (Object value : this._attributes.values()) {
                    if (!(value instanceof HttpSessionActivationListener)) continue;
                    HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                    listener.sessionWillPassivate(event);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void didActivate() {
            Session session = this;
            synchronized (session) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)this);
                for (Object value : this._attributes.values()) {
                    if (!(value instanceof HttpSessionActivationListener)) continue;
                    HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                    listener.sessionDidActivate(event);
                }
            }
        }
    }

    public static interface SessionIf
    extends HttpSession {
        public Session getSession();
    }

    public static class NullSessionContext
    implements HttpSessionContext {
        private NullSessionContext() {
        }

        @Deprecated
        public Enumeration getIds() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        @Deprecated
        public HttpSession getSession(String id) {
            return null;
        }
    }
}

