/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.viewstate;

import java.util.Map;
import java.util.Random;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.application.viewstate.KeyFactory;
import org.apache.myfaces.config.MyfacesConfig;
import org.apache.myfaces.util.lang.Hex;

class KeyFactoryRandom
extends KeyFactory<byte[]> {
    private final Random random;
    private final int length;

    public KeyFactoryRandom(FacesContext facesContext) {
        this.length = MyfacesConfig.getCurrentInstance(facesContext).getRandomKeyInViewStateSessionTokenLength();
        this.random = new Random((int)System.nanoTime() + this.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer generateCounterKey(FacesContext facesContext) {
        Integer sequence;
        Object sessionObj;
        ExternalContext externalContext = facesContext.getExternalContext();
        Object object = sessionObj = externalContext.getSession(true);
        synchronized (object) {
            Map<String, Object> map = externalContext.getSessionMap();
            sequence = (Integer)map.get("jsf_sequence");
            sequence = sequence == null || sequence == Integer.MAX_VALUE ? Integer.valueOf(1) : Integer.valueOf(sequence + 1);
            map.put("jsf_sequence", sequence);
        }
        return sequence;
    }

    @Override
    public byte[] generateKey(FacesContext facesContext) {
        byte[] array = new byte[this.length];
        byte[] key = new byte[this.length + 4];
        this.random.nextBytes(array);
        System.arraycopy(array, 0, key, 0, array.length);
        int value = this.generateCounterKey(facesContext);
        key[array.length] = (byte)(value >>> 24);
        key[array.length + 1] = (byte)(value >>> 16);
        key[array.length + 2] = (byte)(value >>> 8);
        key[array.length + 3] = (byte)value;
        return key;
    }

    @Override
    public String encode(byte[] key) {
        return new String(Hex.encodeHex(key));
    }

    @Override
    public byte[] decode(String value) {
        try {
            return Hex.decodeHex(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

