/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UISeparator;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SeparatorTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(SeparatorTag.class);
    private ValueExpression markup;
    private ValueExpression label;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.Separator";
    }

    public String getRendererType() {
        return "Separator";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UISeparator component = (UISeparator)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.label != null) {
            component.setValueExpression("label", this.label);
        }
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getLabel() {
        return this.label;
    }

    public void setLabel(ValueExpression label) {
        this.label = label;
    }

    public void release() {
        super.release();
        this.markup = null;
        this.label = null;
    }
}

