/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.resource;

public class ResourceValidationUtils {
    public static boolean isValidResourceName(String resourceName) {
        return ResourceValidationUtils.validateResourceName(resourceName, true);
    }

    public static boolean isValidLibraryName(String libraryName) {
        return ResourceValidationUtils.validate(libraryName, false);
    }

    public static boolean isValidLibraryName(String libraryName, boolean allowSlash) {
        return ResourceValidationUtils.validate(libraryName, allowSlash);
    }

    public static boolean isValidLocalePrefix(String localePrefix) {
        for (int i = 0; i < localePrefix.length(); ++i) {
            char c = localePrefix.charAt(i);
            if (c >= 'A' && c <= 'Z' || c == '_' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean validate(String expression, boolean allowSlash) {
        int length;
        if (expression.length() == 2 && expression.charAt(0) == '.' && expression.charAt(1) == '.') {
            return false;
        }
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c >= 'A' && c <= 'Z' || c == '_' || c >= 'a' && c <= 'z' || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u02ff' || c >= '\u0370' && c <= '\u037d' || c >= '\u037f' && c <= '\u1fff' || c >= '\u200c' && c <= '\u200d' || c >= '\u2070' && c <= '\u218f' || c >= '\u2c00' && c <= '\u2fef' || c >= '\u3001' && c <= '\ud7ff' || c >= '\uf900' && c <= '\ufdcf' || c >= '\ufdf0' && c <= '\ufffd' || c >= '\u10000' && c <= '\ueffff' || c == '-' || c >= '0' && c <= '9' || c == '\u00b7' || c >= '\u0300' && c <= '\u036f' || c >= '\u203f' && c <= '\u2040' || allowSlash && c == '/') continue;
            if (c == '.') {
                if (i + 2 >= expression.length()) continue;
                char c1 = expression.charAt(i + 1);
                char c2 = expression.charAt(i + 2);
                if (c != c1 || c2 != '/' && c2 != '\\') continue;
                return false;
            }
            return false;
        }
        return expression.length() < 3 || expression.charAt((length = expression.length()) - 3) != '/' && expression.charAt(length - 3) != '\\' || expression.charAt(length - 2) != '.' || expression.charAt(length - 1) != '.';
    }

    private static boolean validateResourceName(String expression, boolean allowSlash) {
        int length;
        if (expression.length() == 2 && expression.charAt(0) == '.' && expression.charAt(1) == '.') {
            return false;
        }
        for (int i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (c >= 'A' && c <= 'Z' || c == '_' || c >= 'a' && c <= 'z' || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u02ff' || c >= '\u0370' && c <= '\u037d' || c >= '\u037f' && c <= '\u1fff' || c >= '\u200c' && c <= '\u200d' || c >= '\u2070' && c <= '\u218f' || c >= '\u2c00' && c <= '\u2fef' || c >= '\u3001' && c <= '\ud7ff' || c >= '\uf900' && c <= '\ufdcf' || c >= '\ufdf0' && c <= '\ufffd' || c >= '\u10000' && c <= '\ueffff' || c == '-' || c >= '0' && c <= '9' || c == '\u00b7' || c >= '\u0300' && c <= '\u036f' || c >= '\u203f' && c <= '\u2040' || allowSlash && c == '/' || c == '!' || c == '#' || c == '\'' || c == '(' || c == ')' || c == '+' || c == ',' || c == ';' || c == '=' || c == '@' || c == '[' || c == ']' || c == '{' || c == '}') continue;
            if (c == '.') {
                if (i + 2 >= expression.length()) continue;
                char c1 = expression.charAt(i + 1);
                char c2 = expression.charAt(i + 2);
                if (c != c1 || c2 != '/' && c2 != '\\') continue;
                return false;
            }
            return false;
        }
        return expression.length() < 3 || expression.charAt((length = expression.length()) - 3) != '/' && expression.charAt(length - 3) != '\\' || expression.charAt(length - 2) != '.' || expression.charAt(length - 1) != '.';
    }
}

