/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.renderkit.ClassRendererInstantiator;
import org.apache.myfaces.trinidadinternal.renderkit.RendererInstantiator;

public abstract class RenderKitBase
extends RenderKit {
    private RenderKit _aggregated;
    private Map<String, Map<String, Object>> _renderers = new ConcurrentHashMap<String, Map<String, Object>>(64, 0.75f, 1);
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(RenderKitBase.class);

    public RenderKitBase() {
        String renderKitMap = this.getRenderKitMap();
        if (renderKitMap != null) {
            this._loadRenderKitMap(renderKitMap);
        }
    }

    public void addRenderer(String family, String rendererType, Renderer renderer) {
        this._put(family, rendererType, renderer);
    }

    public void addRenderer(String family, String rendererType, String rendererClassName) {
        this._put(family, rendererType, new ClassRendererInstantiator(rendererClassName));
    }

    protected String getRenderKitMap() {
        return null;
    }

    public Renderer getRenderer(String family, String rendererType) {
        Renderer renderer = this.findRenderer(family, rendererType);
        if (renderer == null && _LOG.isWarning()) {
            _LOG.warning("RENDERER_NOT_FOUND", (Object[])new String[]{rendererType, family});
        }
        return renderer;
    }

    public Renderer findRenderer(String family, String rendererType) {
        Object o = this._get(family, rendererType);
        Renderer renderer = null;
        if (o == null) {
            if (this._aggregated != null) {
                renderer = this._aggregated instanceof RenderKitBase ? ((RenderKitBase)this._aggregated).findRenderer(family, rendererType) : this._aggregated.getRenderer(family, rendererType);
            }
        } else if (o instanceof Renderer) {
            renderer = (Renderer)o;
        } else if (o instanceof RendererInstantiator) {
            renderer = ((RendererInstantiator)o).instantiate();
            this._put(family, rendererType, renderer);
        }
        return renderer;
    }

    protected void attachAggregatedRenderKit(RenderKit aggregated) {
        this._aggregated = aggregated;
    }

    private synchronized void _put(String family, String rendererType, Object o) {
        Map<String, Object> subMap = this._renderers.get(family);
        if (subMap == null) {
            subMap = new ConcurrentHashMap<String, Object>(8, 0.75f, 1);
            this._renderers.put(family, subMap);
        }
        subMap.put(rendererType, o);
    }

    private Object _get(String family, String rendererType) {
        Map<String, Object> subMap = this._renderers.get(family);
        if (subMap == null) {
            return null;
        }
        return subMap.get(rendererType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _loadRenderKitMap(String fileName) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        try {
            Enumeration<URL> e = loader.getResources(fileName);
            while (e.hasMoreElements()) {
                URL resource = e.nextElement();
                if (resource != null) {
                    try {
                        Properties properties = new Properties();
                        _LOG.fine("Loading renderkit map from {0}", (Object)resource);
                        try (InputStream is = resource.openStream();){
                            properties.load(is);
                        }
                        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                            String key = (String)entry.getKey();
                            int barIndex = key.indexOf(124);
                            if (barIndex < 0) {
                                _LOG.warning("Invalid renderkit map entry: {0}", (Object)key);
                                continue;
                            }
                            String componentFamily = key.substring(0, barIndex);
                            String rendererType = key.substring(barIndex + 1);
                            String className = (String)entry.getValue();
                            this.addRenderer(componentFamily, rendererType, className);
                        }
                        continue;
                    }
                    catch (IOException ioe) {
                        _LOG.severe("CANNOT_LOAD_URL", (Object)resource);
                        _LOG.severe((Throwable)ioe);
                        continue;
                    }
                }
                _LOG.severe("CANNOT_LOAD_URL", (Object)resource);
            }
        }
        catch (IOException ioe) {
            _LOG.severe("CANNOT_LOAD_RESOURCES", (Object)fileName);
            _LOG.severe((Throwable)ioe);
        }
    }
}

