/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinMetadata;
import org.apache.myfaces.trinidad.skin.SkinProvider;
import org.apache.myfaces.trinidad.skin.SkinVersion;

abstract class BaseSkinProvider
extends SkinProvider {
    private Map<SkinMetadata, Skin> _skins;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(BaseSkinProvider.class);

    public BaseSkinProvider() {
        this.initSkins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Skin getSkin(ExternalContext context, SkinMetadata skinMetadata) {
        BaseSkinProvider baseSkinProvider = this;
        synchronized (baseSkinProvider) {
            return this._getMatchingSkin(context, skinMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SkinMetadata> getSkinMetadata(ExternalContext context) {
        BaseSkinProvider baseSkinProvider = this;
        synchronized (baseSkinProvider) {
            return Collections.unmodifiableCollection(this._skins.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Skin addSkin(SkinMetadata metadata, Skin skin) {
        if (metadata == null || skin == null) {
            _LOG.warning("CANNOT_ADD_SKIN");
            return null;
        }
        if (_LOG.isFine()) {
            _LOG.fine("Adding skin to cache [metadata: {0}, skin: {1}]", new Object[]{metadata, skin});
        }
        BaseSkinProvider baseSkinProvider = this;
        synchronized (baseSkinProvider) {
            return this._skins.put(metadata, skin);
        }
    }

    protected abstract Skin loadAvailableSkin(ExternalContext var1, SkinMetadata var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<SkinMetadata, Skin> getSkins() {
        BaseSkinProvider baseSkinProvider = this;
        synchronized (baseSkinProvider) {
            return this._skins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSkins(Map<SkinMetadata, Skin> skins) {
        BaseSkinProvider baseSkinProvider = this;
        synchronized (baseSkinProvider) {
            if (skins == null) {
                skins = new HashMap<SkinMetadata, Skin>();
            }
            this._skins = skins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSkins() {
        BaseSkinProvider baseSkinProvider = this;
        synchronized (baseSkinProvider) {
            this._skins = new HashMap<SkinMetadata, Skin>();
        }
    }

    protected void initialize(ExternalContext context) {
    }

    private final Skin _getMatchingSkin(ExternalContext context, SkinMetadata searchMetadata) {
        SkinMetadata availableMetadata;
        if (searchMetadata == null) {
            throw new NullPointerException("SkinMetadata passed for search is null");
        }
        Skin availableSkin = this._skins.get(searchMetadata);
        if (availableSkin != null) {
            return availableSkin;
        }
        if (null == searchMetadata.getId() && null == searchMetadata.getFamily()) {
            if (_LOG.isWarning()) {
                _LOG.warning("SP_CANNOT_FIND_SKIN_WITHOUT_FAMILY_OR_ID");
            }
            throw new NullPointerException(_LOG.getMessage("SP_CANNOT_FIND_SKIN_WITHOUT_FAMILY_OR_ID"));
        }
        this.initialize(context);
        if (_LOG.isFine()) {
            _LOG.fine("SP_FINDING_SKIN_FOR", new Object[]{searchMetadata.toString()});
        }
        if ((availableMetadata = this._findSkinMetadata(context, searchMetadata)) == null) {
            if (_LOG.isFine()) {
                _LOG.fine((Object)((Object)this) + " Cannot find skin in this provider: " + searchMetadata);
            }
            return null;
        }
        availableSkin = this._skins.get(availableMetadata);
        if (availableSkin != null) {
            return availableSkin;
        }
        availableSkin = this.loadAvailableSkin(context, availableMetadata);
        assert (availableSkin != null);
        this._skins.put(availableMetadata, availableSkin);
        return availableSkin;
    }

    private SkinMetadata _findSkinMetadata(ExternalContext context, SkinMetadata search) {
        SkinMetadata matchingSkinMetadata = null;
        String skinId = search.getId();
        Collection<SkinMetadata> skinMetadata = this.getSkinMetadata(context);
        if (skinMetadata == null || skinMetadata.isEmpty()) {
            return null;
        }
        if (skinId != null) {
            for (SkinMetadata m : skinMetadata) {
                if (!skinId.equals(m.getId())) continue;
                matchingSkinMetadata = m;
            }
            if (matchingSkinMetadata == null && _LOG.isFine()) {
                _LOG.fine("SP_CANNOT_FIND_MATCHING_SKIN_ID", new Object[]{skinId});
            }
        } else {
            String family = search.getFamily();
            if (family == null) {
                return null;
            }
            String renderKit = search.getRenderKitId();
            SkinVersion version = search.getVersion();
            ArrayList<SkinMetadata> familyRenderKitMatches = new ArrayList<SkinMetadata>(2);
            for (SkinMetadata m : skinMetadata) {
                if (!family.equalsIgnoreCase(m.getFamily()) || !renderKit.equalsIgnoreCase(m.getRenderKitId())) continue;
                familyRenderKitMatches.add(m);
            }
            if (familyRenderKitMatches.isEmpty()) {
                if (_LOG.isFine()) {
                    _LOG.fine("SP_CANNOT_FIND_MATCHING_SKIN", new Object[]{family, renderKit});
                }
                return null;
            }
            String versionName = version.getName();
            boolean versionIsDefault = version.isDefault();
            boolean foundMatchingSkin = false;
            if (!versionIsDefault) {
                matchingSkinMetadata = this._findSkinMetadataForVersionName(familyRenderKitMatches, version);
            }
            if (matchingSkinMetadata == null || versionIsDefault) {
                matchingSkinMetadata = this._findSkinMetadataWithDefaultVersion(familyRenderKitMatches);
                if (matchingSkinMetadata == null) {
                    if (_LOG.isFine()) {
                        _LOG.fine((Object)((Object)this) + " did not find default / version skinMetadata. so getting leaf skin");
                    }
                    matchingSkinMetadata = this._findLeafSkinMetadata(familyRenderKitMatches);
                } else if (matchingSkinMetadata != null && versionIsDefault) {
                    if (_LOG.isFine()) {
                        _LOG.fine((Object)((Object)this) + " found default skinMetadata");
                    }
                    foundMatchingSkin = true;
                }
            }
            if (foundMatchingSkin) {
                if (_LOG.isFine()) {
                    _LOG.fine("GET_SKIN_FOUND_SKIN_VERSION", new Object[]{family, version, matchingSkinMetadata.getId()});
                }
            } else if (matchingSkinMetadata != null && _LOG.isFine()) {
                if ("".equals(versionName)) {
                    _LOG.fine("GET_SKIN_CANNOT_FIND_NO_VERSION", new Object[]{family, matchingSkinMetadata.getId()});
                } else {
                    _LOG.fine("GET_SKIN_CANNOT_FIND_SKIN_VERSION", new Object[]{family, version, matchingSkinMetadata.getId()});
                }
            }
            if (matchingSkinMetadata == null) {
                matchingSkinMetadata = (SkinMetadata)familyRenderKitMatches.get(familyRenderKitMatches.size() - 1);
            }
        }
        if (matchingSkinMetadata != null && _LOG.isFine()) {
            _LOG.fine((Object)((Object)this) + " found matching metadata: " + matchingSkinMetadata);
        }
        return matchingSkinMetadata;
    }

    private SkinMetadata _findSkinMetadataForVersionName(Collection<SkinMetadata> skins, SkinVersion version) {
        if (version == null) {
            throw new IllegalArgumentException("skin version cannot be null");
        }
        if (version.getName() == null || version.getName().isEmpty()) {
            return null;
        }
        for (SkinMetadata metadata : skins) {
            if (!version.getName().equals(metadata.getVersion().getName())) continue;
            if (_LOG.isFine()) {
                _LOG.fine("Found version match skinMetadata: " + metadata);
            }
            return metadata;
        }
        return null;
    }

    private SkinMetadata _findLeafSkinMetadata(Collection<SkinMetadata> skins) {
        ArrayList<SkinMetadata> leafSkinMetadata = new ArrayList<SkinMetadata>();
        ArrayList<String> parentIds = new ArrayList<String>();
        for (SkinMetadata metadata : skins) {
            String parentId = metadata.getBaseSkinId();
            if (parentId == null) continue;
            parentIds.add(metadata.getBaseSkinId());
        }
        for (SkinMetadata metadata : skins) {
            String skinId = metadata.getId();
            if (skinId == null || parentIds.contains(skinId)) continue;
            leafSkinMetadata.add(metadata);
        }
        if (leafSkinMetadata.isEmpty()) {
            return null;
        }
        return (SkinMetadata)leafSkinMetadata.get(leafSkinMetadata.size() - 1);
    }

    private SkinMetadata _findSkinMetadataWithDefaultVersion(Collection<SkinMetadata> matchingSkinList) {
        for (SkinMetadata metadata : matchingSkinList) {
            SkinVersion skinVersion = metadata.getVersion();
            if (skinVersion == null || !skinVersion.isDefault()) continue;
            if (_LOG.isFine()) {
                _LOG.fine("Found default skinMetadata: " + metadata);
            }
            return metadata;
        }
        return null;
    }
}

