/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractIntHashSet;
import io.questdb.std.Numbers;
import java.util.Arrays;

public class CompactIntHashSet
extends AbstractIntHashSet {
    private static final int MIN_INITIAL_CAPACITY = 16;

    public CompactIntHashSet() {
        this(16);
    }

    public CompactIntHashSet(int initialCapacity) {
        this(initialCapacity, 0.6, -1);
    }

    public CompactIntHashSet(int initialCapacity, double loadFactor, int noKeyValue) {
        super(initialCapacity, loadFactor, noKeyValue);
        this.clear();
    }

    public boolean add(int key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            return false;
        }
        this.addAt(index, key);
        return true;
    }

    public void addAt(int index, int key) {
        this.keys[index] = key;
        if (--this.free < 1) {
            this.rehash();
        }
    }

    public boolean contains(int key) {
        return this.keyIndex(key) < 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompactIntHashSet that = (CompactIntHashSet)o;
        if (this.size() != that.size()) {
            return false;
        }
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            if (this.keys[i] == this.noEntryKeyValue || !that.excludes(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean excludes(int key) {
        return this.keyIndex(key) > -1;
    }

    public int hashCode() {
        int hashCode = 0;
        int n = this.keys.length;
        for (int i = 0; i < n; ++i) {
            if (this.keys[i] == this.noEntryKeyValue) continue;
            hashCode += this.keys[i];
        }
        return hashCode;
    }

    @Override
    public int remove(int key) {
        int keyIndex = this.keyIndex(key);
        if (keyIndex < 0) {
            this.removeAt(keyIndex);
            return -keyIndex - 1;
        }
        return -1;
    }

    public String toString() {
        return Arrays.toString(this.keys);
    }

    private void rehash() {
        int newCapacity;
        this.free = this.capacity = (newCapacity = this.capacity * 2);
        int len = Numbers.ceilPow2((int)((double)newCapacity / this.loadFactor));
        int[] oldKeys = this.keys;
        this.keys = new int[len];
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.mask = len - 1;
        for (int key : oldKeys) {
            if (key == this.noEntryKeyValue) continue;
            this.keys[this.keyIndex((int)key)] = key;
            --this.free;
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = this.noEntryKeyValue;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.erase(from);
    }
}

