/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization;

import java.util.StringJoiner;

public enum RequestAction {
    READ("read"),
    WRITE("write"),
    DELETE("delete");

    private String value;

    private RequestAction(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value.toLowerCase();
    }

    public static RequestAction valueOfValue(String action) {
        if (READ.toString().equalsIgnoreCase(action)) {
            return READ;
        }
        if (WRITE.toString().equalsIgnoreCase(action)) {
            return WRITE;
        }
        if (DELETE.toString().equalsIgnoreCase(action)) {
            return DELETE;
        }
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (RequestAction ra : RequestAction.values()) {
            stringJoiner.add(ra.toString());
        }
        String allowableValues = stringJoiner.toString();
        throw new IllegalArgumentException("Action '" + action + "' is invalid. Must be one of [" + allowableValues + "]");
    }
}

