/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.portals.applications.rss.RssInfo;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RomeRSSPortlet
extends GenericVelocityPortlet {
    protected Logger log = LoggerFactory.getLogger(RomeRSSPortlet.class);

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        Context velocityContext = this.getContext(request);
        PortletPreferences prefs = request.getPreferences();
        String url = prefs.getValue("url", "http://www.npr.org/rss/rss.php?topicId=4");
        try {
            URL feedUrl = new URL(url);
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed feed = input.build((Reader)new XmlReader(feedUrl));
            RssInfo rssInfo = new RssInfo(feed, new Integer(prefs.getValue("itemdisplayed", "15")), new Boolean(prefs.getValue("openinpopup", "true")), new Boolean(prefs.getValue("showdescription", "true")), new Boolean(prefs.getValue("showtitle", "true")), new Boolean(prefs.getValue("showtextinput", "true")));
            if (feed.getTitle() != null) {
                response.setTitle(feed.getTitle());
            }
            velocityContext.put("rssInfo", (Object)rssInfo);
            super.doView(request, response);
        }
        catch (Exception e) {
            throw new PortletException(new String("Failed to process RSS Feed: " + url + ", " + e));
        }
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        this.doPreferencesEdit(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        String add = request.getParameter("Save");
        if (add != null) {
            this.processPreferencesAction(request, actionResponse);
        }
    }
}

