/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.transform.impl;

import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.TreeMap;
import org.apache.portals.applications.transform.Transform;
import org.apache.portals.applications.transform.TransformCache;
import org.apache.portals.applications.transform.TransformCacheEntry;

public class MemoryTransformCache
implements TransformCache {
    private boolean debug = false;
    private int maxSize = 100;
    private int evictionPercentage = 10;
    private boolean enable = true;
    private TreeMap cache = null;
    private Object lock = new Object();

    public MemoryTransformCache(Transform transform, int maxSize, int evictionPercentage, boolean enable, boolean debug) {
        this.cache = new TreeMap();
        this.maxSize = maxSize;
        this.evictionPercentage = evictionPercentage;
        transform.getPublisher().addObserver(this);
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public int getEvictionPercentage() {
        return this.evictionPercentage;
    }

    @Override
    public boolean isEnabled() {
        return this.enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Object document, long timeToLive) {
        TransformCacheEntry entry = new TransformCacheEntry(key, document, timeToLive);
        if (this.cache.size() > this.getMaxSize()) {
            this.evict();
        }
        Object object = this.lock;
        synchronized (object) {
            this.cache.put(key, entry);
        }
        if (this.debug) {
            System.out.println("Transformed content put in cache! Transform: " + key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void evict() {
        if (this.debug) {
            System.out.println("Calling evict... cacheSize: " + this.cache.size() + " maxSize: " + this.getMaxSize());
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.getMaxSize() >= this.cache.size()) {
                return;
            }
            LinkedList list = new LinkedList(this.cache.values());
            Collections.sort(list, this);
            int count = 0;
            int limit = this.getMaxSize() * this.getEvictionPercentage() / 100;
            if (limit <= 0) {
                limit = 1;
            }
            Iterator it = list.iterator();
            while (it.hasNext() && count < limit) {
                TransformCacheEntry entry = (TransformCacheEntry)it.next();
                if (this.debug) {
                    System.out.println("Evicting: " + entry.getKey());
                }
                this.cache.remove(entry.getKey());
                ++count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(String key) {
        TransformCacheEntry entry = (TransformCacheEntry)this.cache.get(key);
        if (entry == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            entry = (TransformCacheEntry)this.cache.remove(key);
        }
        return entry;
    }

    @Override
    public TransformCacheEntry get(String key) {
        TransformCacheEntry entry = (TransformCacheEntry)this.cache.get(key);
        if (entry == null) {
            return null;
        }
        long now = new Date().getTime();
        long lifeTime = entry.getTimeToLive() * 1000L;
        if (entry.getLastAccessed() + lifeTime < now) {
            return null;
        }
        if (this.debug) {
            System.out.println("Transformed content found in cache! Transform: " + key);
        }
        return entry;
    }

    @Override
    public Object getDocument(String key) {
        TransformCacheEntry entry = this.get(key);
        if (entry != null) {
            return entry.getDocument();
        }
        return null;
    }

    public int compare(Object o1, Object o2) {
        TransformCacheEntry e1 = (TransformCacheEntry)o1;
        TransformCacheEntry e2 = (TransformCacheEntry)o2;
        if (e1.getLastAccessed() < e2.getLastAccessed()) {
            return -1;
        }
        if (e1.getLastAccessed() == e2.getLastAccessed()) {
            return 0;
        }
        return 1;
    }

    @Override
    public String constructKey(String url, String stylesheet) {
        return url + ":" + stylesheet;
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public void update(Observable o, Object arg) {
    }
}

