/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.vertx;

import com.google.common.annotations.VisibleForTesting;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.impl.FileUploadImpl;
import io.vertx.ext.web.impl.RoutingContextInternal;
import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.ExceptionFactory;

public class RestBodyHandler
implements BodyHandler {
    private long bodyLimit = 0xA00000L;
    private boolean handleFileUploads;
    private String uploadsDir;
    private boolean mergeFormAttributes = true;
    private boolean deleteUploadedFilesOnEnd = false;
    private boolean isPreallocateBodyBuffer = false;
    private static final int DEFAULT_INITIAL_BODY_BUFFER_SIZE = 1024;
    public static final String BYPASS_BODY_HANDLER = "__bypass_body_handler";

    public RestBodyHandler() {
        this(true, "file-uploads");
    }

    public RestBodyHandler(boolean handleFileUploads) {
        this(handleFileUploads, "file-uploads");
    }

    public RestBodyHandler(String uploadDirectory) {
        this(true, uploadDirectory);
    }

    private RestBodyHandler(boolean handleFileUploads, String uploadDirectory) {
        this.handleFileUploads = handleFileUploads;
        this.setUploadsDirectory(uploadDirectory);
    }

    @VisibleForTesting
    boolean isDeleteUploadedFilesOnEnd() {
        return this.deleteUploadedFilesOnEnd;
    }

    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        HttpServerResponse response = context.response();
        if (request.headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true)) {
            context.next();
            return;
        }
        Boolean bypass = (Boolean)context.get(BYPASS_BODY_HANDLER);
        if (Boolean.TRUE.equals(bypass)) {
            context.next();
            return;
        }
        if (!((RoutingContextInternal)context).seenHandler(2)) {
            boolean hasTransferEncoding;
            ((RoutingContextInternal)context).visitHandler(2);
            long parsedContentLength = this.parseContentLengthHeader(request);
            boolean bl = hasTransferEncoding = request.version() == HttpVersion.HTTP_2 || request.headers().contains(HttpHeaders.TRANSFER_ENCODING);
            if (!hasTransferEncoding && parsedContentLength == -1L) {
                context.next();
                return;
            }
            if (this.bodyLimit != -1L && parsedContentLength != -1L && parsedContentLength > this.bodyLimit) {
                context.fail(413);
                return;
            }
            String expect = request.getHeader(HttpHeaders.EXPECT);
            if (expect != null) {
                if (expect.equalsIgnoreCase("100-continue")) {
                    if (request.version() != HttpVersion.HTTP_1_0) {
                        response.writeContinue();
                    }
                } else {
                    context.fail(417);
                    return;
                }
            }
            BHandler handler = new BHandler(context, this.isPreallocateBodyBuffer ? parsedContentLength : -1L);
            boolean ended = request.isEnded();
            if (!ended) {
                request.handler((Handler)handler).endHandler(handler::end).resume();
            }
        } else {
            if (this.mergeFormAttributes && request.isExpectMultipart()) {
                request.params().addAll(request.formAttributes());
            }
            context.next();
        }
    }

    public BodyHandler setHandleFileUploads(boolean handleFileUploads) {
        this.handleFileUploads = handleFileUploads;
        return this;
    }

    public BodyHandler setBodyLimit(long bodyLimit) {
        this.bodyLimit = bodyLimit;
        return this;
    }

    public BodyHandler setUploadsDirectory(String uploadsDirectory) {
        this.uploadsDir = uploadsDirectory;
        return this;
    }

    public BodyHandler setMergeFormAttributes(boolean mergeFormAttributes) {
        this.mergeFormAttributes = mergeFormAttributes;
        return this;
    }

    public BodyHandler setDeleteUploadedFilesOnEnd(boolean deleteUploadedFilesOnEnd) {
        this.deleteUploadedFilesOnEnd = deleteUploadedFilesOnEnd;
        return this;
    }

    public BodyHandler setPreallocateBodyBuffer(boolean isPreallocateBodyBuffer) {
        this.isPreallocateBodyBuffer = isPreallocateBodyBuffer;
        return this;
    }

    private long parseContentLengthHeader(HttpServerRequest request) {
        String contentLength = request.getHeader(HttpHeaders.CONTENT_LENGTH);
        if (contentLength == null || contentLength.isEmpty()) {
            return -1L;
        }
        try {
            long parsedContentLength = Long.parseLong(contentLength);
            return parsedContentLength < 0L ? -1L : parsedContentLength;
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    private class BHandler
    implements Handler<Buffer> {
        private static final int MAX_PREALLOCATED_BODY_BUFFER_BYTES = 65535;
        final RoutingContext context;
        final long contentLength;
        Buffer body;
        boolean failed;
        final AtomicInteger uploadCount = new AtomicInteger();
        boolean ended;
        long uploadSize = 0L;
        final boolean isMultipart;
        final boolean isUrlEncoded;

        public BHandler(RoutingContext context, long contentLength) {
            this.context = context;
            this.contentLength = contentLength;
            if (contentLength != -1L) {
                this.initBodyBuffer();
            }
            List fileUploads = context.fileUploads();
            String contentType = context.request().getHeader(HttpHeaders.CONTENT_TYPE);
            if (contentType == null) {
                this.isMultipart = false;
                this.isUrlEncoded = false;
            } else {
                String lowerCaseContentType = contentType.toLowerCase();
                this.isMultipart = lowerCaseContentType.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString());
                this.isUrlEncoded = lowerCaseContentType.startsWith(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString());
            }
            if (this.isMultipart || this.isUrlEncoded) {
                context.request().setExpectMultipart(true);
                if (RestBodyHandler.this.handleFileUploads) {
                    this.makeUploadDir(context.vertx().fileSystem());
                }
                context.request().uploadHandler(upload -> {
                    long size;
                    if (RestBodyHandler.this.uploadsDir == null) {
                        this.failed = true;
                        CommonExceptionData data = new CommonExceptionData("not support file upload.");
                        context.fail((Throwable)ExceptionFactory.createProducerException((Object)data));
                        return;
                    }
                    if (RestBodyHandler.this.bodyLimit != -1L && upload.isSizeAvailable() && (size = this.uploadSize + upload.size()) > RestBodyHandler.this.bodyLimit) {
                        this.failed = true;
                        context.cancelAndCleanupFileUploads();
                        context.fail(413);
                        return;
                    }
                    if (RestBodyHandler.this.handleFileUploads) {
                        this.uploadCount.incrementAndGet();
                        String uploadedFileName = new File(RestBodyHandler.this.uploadsDir, UUID.randomUUID().toString()).getPath();
                        FileUploadImpl fileUpload = new FileUploadImpl(context.vertx().fileSystem(), uploadedFileName, upload);
                        fileUploads.add(fileUpload);
                        Future fut = upload.streamToFileSystem(uploadedFileName);
                        fut.onComplete(ar -> {
                            if (fut.succeeded()) {
                                this.uploadEnded();
                            } else {
                                context.cancelAndCleanupFileUploads();
                                context.fail(ar.cause());
                            }
                        });
                    }
                });
            }
            context.request().exceptionHandler(t -> {
                context.cancelAndCleanupFileUploads();
                int sc = 200;
                if (t instanceof DecoderException) {
                    sc = 400;
                    if (t.getCause() != null) {
                        t = t.getCause();
                    }
                }
                context.fail(sc, t);
            });
        }

        private void initBodyBuffer() {
            int initialBodyBufferSize = this.contentLength < 0L ? 1024 : (this.contentLength > 65535L ? 65535 : (int)this.contentLength);
            if (RestBodyHandler.this.bodyLimit != -1L) {
                initialBodyBufferSize = (int)Math.min((long)initialBodyBufferSize, RestBodyHandler.this.bodyLimit);
            }
            this.body = Buffer.buffer((int)initialBodyBufferSize);
        }

        private void makeUploadDir(FileSystem fileSystem) {
            if (RestBodyHandler.this.uploadsDir == null) {
                return;
            }
            if (!fileSystem.existsBlocking(RestBodyHandler.this.uploadsDir)) {
                fileSystem.mkdirsBlocking(RestBodyHandler.this.uploadsDir);
            }
        }

        public void handle(Buffer buff) {
            if (this.failed) {
                return;
            }
            this.uploadSize += (long)buff.length();
            if (RestBodyHandler.this.bodyLimit != -1L && this.uploadSize > RestBodyHandler.this.bodyLimit) {
                this.failed = true;
                this.context.cancelAndCleanupFileUploads();
                this.context.fail(413);
            } else if (!this.isMultipart) {
                if (this.body == null) {
                    this.initBodyBuffer();
                }
                this.body.appendBuffer(buff);
            }
        }

        void uploadEnded() {
            int count = this.uploadCount.decrementAndGet();
            if (this.ended && count == 0) {
                this.doEnd();
            }
        }

        void end(Void v) {
            this.ended = true;
            if (this.uploadCount.get() == 0) {
                this.doEnd();
            }
        }

        void doEnd() {
            if (this.failed || this.context.failed()) {
                this.context.cancelAndCleanupFileUploads();
                return;
            }
            if (RestBodyHandler.this.deleteUploadedFilesOnEnd) {
                this.context.addBodyEndHandler(x -> this.context.cancelAndCleanupFileUploads());
            }
            HttpServerRequest req = this.context.request();
            if (RestBodyHandler.this.mergeFormAttributes && req.isExpectMultipart()) {
                req.params().addAll(req.formAttributes());
            }
            ((RoutingContextInternal)this.context).setBody(this.body);
            this.body = null;
            this.context.next();
        }
    }
}

