/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.codegen;

import io.swagger.codegen.mustache.CamelCaseLambda;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.servicecomb.toolkit.codegen.AbstractJavaCodegenExt;
import org.apache.servicecomb.toolkit.codegen.ConsumerDirectoryStrategy;
import org.apache.servicecomb.toolkit.codegen.DefaultDirectoryStrategy;
import org.apache.servicecomb.toolkit.codegen.GetGenericClassTypeLambda;
import org.apache.servicecomb.toolkit.codegen.GetRelativeBasePathLambda;
import org.apache.servicecomb.toolkit.codegen.ProviderDirectoryStrategy;
import org.apache.servicecomb.toolkit.codegen.ServiceType;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.languages.SpringCodegen;
import org.openapitools.codegen.utils.StringUtils;

public class ServiceCombCodegen
extends AbstractJavaCodegenExt {
    public static final String DEFAULT_LIBRARY = "SpringMVC";
    public static final String POJO_LIBRARY = "POJO";
    public static final String JAX_RS_LIBRARY = "JAX-RS";
    public static final String SPRING_BOOT_LIBRARY = "SpringBoot";
    private String applicationId = "defaultApp";
    private String serviceId = "defaultService";
    private String modelTemplateFolder = "model";

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return "ServiceComb";
    }

    public String getHelp() {
        return "Generates a ServiceComb server library.";
    }

    public ServiceCombCodegen() {
        this.outputFolder = "generated-code/ServiceComb";
        this.templateDir = "ServiceComb";
        this.embeddedTemplateDir = "ServiceComb";
        this.modelTemplateFiles.put(this.modelTemplateFolder + "/model.mustache", ".java");
        this.modelTemplateFiles.remove("model.mustache");
        this.supportedLibraries.put(DEFAULT_LIBRARY, "ServiceComb Server application using the SpringMVC programming model.");
        this.supportedLibraries.put(POJO_LIBRARY, "ServiceComb Server application using the POJO programming model.");
        this.supportedLibraries.put(JAX_RS_LIBRARY, "ServiceComb Server application using the JAX-RS programming model.");
        this.supportedLibraries.put(SPRING_BOOT_LIBRARY, "ServiceComb Server application using the SpringBoot programming model.");
        this.setLibrary(DEFAULT_LIBRARY);
        CliOption library = new CliOption("library", "library template (sub-template) to use");
        library.setEnum(this.supportedLibraries);
        library.setDefault(DEFAULT_LIBRARY);
        this.cliOptions.add(library);
        this.addDirectoryStrategy(new ProviderDirectoryStrategy(), ServiceType.PROVIDER.getValue());
        this.addDirectoryStrategy(new ConsumerDirectoryStrategy(), ServiceType.CONSUMER.getValue());
        this.addDirectoryStrategy(new DefaultDirectoryStrategy(), ServiceType.ALL.getValue());
    }

    public String modelFileFolder() {
        return this.outputFolder + "/" + this.currentDirectoryStrategy.modelDirectory() + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', '/');
    }

    public String apiFileFolder() {
        return this.outputFolder + "/" + this.currentDirectoryStrategy.providerDirectory() + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', '/');
    }

    public String apiFilename(String templateName, String tag) {
        if (ServiceType.CONSUMER.getValue().equals(this.additionalProperties.get("serviceType")) || ServiceType.CONSUMER.getValue().equals(this.additionalProperties.get(templateName))) {
            String suffix = (String)this.apiTemplateFiles().get(templateName);
            return this.apiConsumerFolder() + File.separator + this.toApiFilename(tag) + suffix;
        }
        return super.apiFilename(templateName, tag);
    }

    private String apiConsumerFolder() {
        return this.outputFolder + "/" + this.currentDirectoryStrategy.consumerDirectory() + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', '/');
    }

    @Override
    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        Map operations = (Map)objs.get("operations");
        String classnameImpl = operations.get("classname") + "Impl";
        operations.put("classnameImpl", classnameImpl);
        this.additionalProperties.put("classnameImpl", classnameImpl);
        return super.postProcessOperationsWithModels(objs, allModels);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
        this.additionalProperties.put("dateLibrary", "java8");
        this.additionalProperties.put("camelcase", new CamelCaseLambda());
        this.additionalProperties.put("getGenericClassType", new GetGenericClassTypeLambda());
        this.additionalProperties.put("getRelativeBasePath", new GetRelativeBasePathLambda());
        this.additionalProperties.put("applicationId", this.applicationId);
        this.additionalProperties.put("library", this.getLibrary());
        this.additionalProperties.put("outputFolder", this.outputFolder);
        this.additionalProperties.put("apiTemplateFiles", this.apiTemplateFiles);
        this.additionalProperties.put("apiTestTemplateFiles", this.apiTestTemplateFiles);
        this.additionalProperties.put("modelTemplateFiles", this.modelTemplateFiles);
        this.additionalProperties.put("apiDocTemplateFiles", this.apiDocTemplateFiles);
        if (this.additionalProperties.get("serviceId") != null) {
            this.serviceId = (String)this.additionalProperties.get("serviceId");
        }
        this.additionalProperties.put("serviceId", this.serviceId);
        this.currentDirectoryStrategy = this.getStrategyMap().get(Optional.ofNullable(this.additionalProperties.get("serviceType")).orElse(ServiceType.ALL.getValue()));
        this.currentDirectoryStrategy.addCustomProperties(this.additionalProperties);
        this.currentDirectoryStrategy.processSupportingFile(this.supportingFiles);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        model.imports.remove("ApiModelProperty");
        model.imports.remove("ApiModel");
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        objs = super.postProcessModelsEnum(objs);
        SpringCodegen springCodegen = new SpringCodegen();
        return springCodegen.postProcessModelsEnum(objs);
    }

    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultApi";
        }
        String apiName = (String)this.additionalProperties.get("apiName");
        if (apiName != null) {
            return apiName;
        }
        return StringUtils.camelize((String)name) + "Api";
    }
}

