/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.dynamic;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.internal.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.assertj.core.internal.bytebuddy.description.method.MethodDescription;
import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.dynamic.ClassFileLocator;
import org.assertj.core.internal.bytebuddy.dynamic.Nexus;
import org.assertj.core.internal.bytebuddy.dynamic.loading.ClassInjector;
import org.assertj.core.internal.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.assertj.core.internal.bytebuddy.implementation.Implementation;
import org.assertj.core.internal.bytebuddy.implementation.LoadedTypeInitializer;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.Removal;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.StackManipulation;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.constant.ClassConstant;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.constant.NullConstant;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.constant.TextConstant;
import org.assertj.core.internal.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.assertj.core.internal.bytebuddy.jar.asm.MethodVisitor;

@HashCodeAndEqualsPlugin.Enhance
public class NexusAccessor {
    private static final Dispatcher DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);
    @HashCodeAndEqualsPlugin.ValueHandling(value=HashCodeAndEqualsPlugin.ValueHandling.Sort.REVERSE_NULLABILITY)
    private final ReferenceQueue<? super ClassLoader> referenceQueue;

    public NexusAccessor() {
        this(Nexus.NO_QUEUE);
    }

    public NexusAccessor(ReferenceQueue<? super ClassLoader> referenceQueue) {
        this.referenceQueue = referenceQueue;
    }

    public static boolean isAlive() {
        return DISPATCHER.isAlive();
    }

    public static void clean(Reference<? extends ClassLoader> reference) {
        DISPATCHER.clean(reference);
    }

    public void register(String name, ClassLoader classLoader, int identification, LoadedTypeInitializer loadedTypeInitializer) {
        if (loadedTypeInitializer.isAlive()) {
            DISPATCHER.register(name, classLoader, this.referenceQueue, identification, loadedTypeInitializer);
        }
    }

    public boolean equals(Object object) {
        block10: {
            block9: {
                ReferenceQueue<? super ClassLoader> referenceQueue;
                block8: {
                    ReferenceQueue<? super ClassLoader> referenceQueue2;
                    if (this == object) {
                        return true;
                    }
                    if (object == null) {
                        return false;
                    }
                    if (this.getClass() != object.getClass()) {
                        return false;
                    }
                    ReferenceQueue<? super ClassLoader> referenceQueue3 = ((NexusAccessor)object).referenceQueue;
                    referenceQueue = referenceQueue2 = this.referenceQueue;
                    if (referenceQueue3 == null) break block8;
                    if (referenceQueue == null) break block9;
                    if (!referenceQueue2.equals(referenceQueue3)) {
                        return false;
                    }
                    break block10;
                }
                if (referenceQueue == null) break block10;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 17 * 31;
        ReferenceQueue<? super ClassLoader> referenceQueue = this.referenceQueue;
        if (referenceQueue != null) {
            n = n + referenceQueue.hashCode();
        }
        return n;
    }

    protected static interface Dispatcher {
        public boolean isAlive();

        public void clean(Reference<? extends ClassLoader> var1);

        public void register(String var1, ClassLoader var2, ReferenceQueue<? super ClassLoader> var3, int var4, LoadedTypeInitializer var5);

        @HashCodeAndEqualsPlugin.Enhance
        public static class Unavailable
        implements Dispatcher {
            private final String message;

            protected Unavailable(String message) {
                this.message = message;
            }

            @Override
            public boolean isAlive() {
                return false;
            }

            @Override
            public void clean(Reference<? extends ClassLoader> reference) {
                throw new IllegalStateException("Could not initialize Nexus accessor: " + this.message);
            }

            @Override
            public void register(String name, ClassLoader classLoader, ReferenceQueue<? super ClassLoader> referenceQueue, int identification, LoadedTypeInitializer loadedTypeInitializer) {
                throw new IllegalStateException("Could not initialize Nexus accessor: " + this.message);
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.message.equals(((Unavailable)object).message);
            }

            public int hashCode() {
                return 17 * 31 + this.message.hashCode();
            }
        }

        @HashCodeAndEqualsPlugin.Enhance
        public static class Available
        implements Dispatcher {
            private static final Object STATIC_METHOD = null;
            private final Method register;
            private final Method clean;

            protected Available(Method register, Method clean) {
                this.register = register;
                this.clean = clean;
            }

            @Override
            public boolean isAlive() {
                return true;
            }

            @Override
            public void clean(Reference<? extends ClassLoader> reference) {
                try {
                    this.clean.invoke(STATIC_METHOD, reference);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access: " + this.clean, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke: " + this.clean, exception.getCause());
                }
            }

            @Override
            public void register(String name, ClassLoader classLoader, ReferenceQueue<? super ClassLoader> referenceQueue, int identification, LoadedTypeInitializer loadedTypeInitializer) {
                try {
                    this.register.invoke(STATIC_METHOD, name, classLoader, referenceQueue, identification, loadedTypeInitializer);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access: " + this.register, exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Cannot invoke: " + this.register, exception.getCause());
                }
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                if (!this.register.equals(((Available)object).register)) {
                    return false;
                }
                return this.clean.equals(((Available)object).clean);
            }

            public int hashCode() {
                return (17 * 31 + this.register.hashCode()) * 31 + this.clean.hashCode();
            }
        }

        public static enum CreationAction implements PrivilegedAction<Dispatcher>
        {
            INSTANCE;


            @Override
            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
            public Dispatcher run() {
                if (Boolean.getBoolean("org.assertj.core.internal.bytebuddy.nexus.disabled")) {
                    return new Unavailable("Nexus injection was explicitly disabled");
                }
                try {
                    Class<?> nexusType = new ClassInjector.UsingReflection(ClassLoader.getSystemClassLoader(), ClassLoadingStrategy.NO_PROTECTION_DOMAIN).inject(Collections.singletonMap(TypeDescription.ForLoadedType.of(Nexus.class), ClassFileLocator.ForClassLoader.read(Nexus.class).resolve())).get(TypeDescription.ForLoadedType.of(Nexus.class));
                    return new Available(nexusType.getMethod("register", String.class, ClassLoader.class, ReferenceQueue.class, Integer.TYPE, Object.class), nexusType.getMethod("clean", Reference.class));
                }
                catch (Exception exception) {
                    try {
                        Class<?> nexusType = ClassLoader.getSystemClassLoader().loadClass(Nexus.class.getName());
                        return new Available(nexusType.getMethod("register", String.class, ClassLoader.class, ReferenceQueue.class, Integer.TYPE, Object.class), nexusType.getMethod("clean", Reference.class));
                    }
                    catch (Exception ignored) {
                        return new Unavailable(exception.toString());
                    }
                }
            }
        }
    }

    @HashCodeAndEqualsPlugin.Enhance
    public static class InitializationAppender
    implements ByteCodeAppender {
        private final int identification;

        public InitializationAppender(int identification) {
            this.identification = identification;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            try {
                return new ByteCodeAppender.Simple(new StackManipulation.Compound(MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(ClassLoader.class.getMethod("getSystemClassLoader", new Class[0]))), new TextConstant(Nexus.class.getName()), MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(ClassLoader.class.getMethod("loadClass", String.class))), new TextConstant("initialize"), ArrayFactory.forType(TypeDescription.Generic.CLASS).withValues(Arrays.asList(ClassConstant.of(TypeDescription.CLASS), ClassConstant.of(TypeDescription.ForLoadedType.of(Integer.TYPE)))), MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(Class.class.getMethod("getMethod", String.class, Class[].class))), NullConstant.INSTANCE, ArrayFactory.forType(TypeDescription.Generic.OBJECT).withValues(Arrays.asList(ClassConstant.of(instrumentedMethod.getDeclaringType().asErasure()), new StackManipulation.Compound(IntegerConstant.forValue(this.identification), MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(Integer.class.getMethod("valueOf", Integer.TYPE)))))), MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(Method.class.getMethod("invoke", Object.class, Object[].class))), Removal.SINGLE)).apply(methodVisitor, implementationContext, instrumentedMethod);
            }
            catch (NoSuchMethodException exception) {
                throw new IllegalStateException("Cannot locate method", exception);
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.identification == ((InitializationAppender)object).identification;
        }

        public int hashCode() {
            return 17 * 31 + this.identification;
        }
    }
}

