/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.FactoryOptions;
import org.apache.servicecomb.toolkit.oasv.style.validator.tag.TagDescriptionRequiredValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.tag.TagMustBeReferencedValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.tag.TagNameCaseValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.TagValidator;
import org.apache.servicecomb.toolkit.oasv.validation.factory.TagValidatorFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultTagValidatorFactory
implements TagValidatorFactory {
    public List<TagValidator> create(FactoryOptions options) {
        ArrayList<TagValidator> validators = new ArrayList<TagValidator>();
        this.addTagDescriptionRequiredValidator(validators, options);
        this.addTagMustBeReferencedValidator(validators, options);
        this.addTagNameCaseValidator(validators, options);
        return Collections.unmodifiableList(validators);
    }

    private void addTagDescriptionRequiredValidator(List<TagValidator> validators, FactoryOptions options) {
        Boolean required = options.getBoolean("tag.description.required");
        if (Boolean.TRUE.equals(required)) {
            validators.add(new TagDescriptionRequiredValidator());
        }
    }

    private void addTagMustBeReferencedValidator(List<TagValidator> validators, FactoryOptions options) {
        Boolean required = options.getBoolean("tag.name.must_be_referenced");
        if (Boolean.TRUE.equals(required)) {
            validators.add(new TagMustBeReferencedValidator());
        }
    }

    private void addTagNameCaseValidator(List<TagValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("tag.name.case");
        if (expectedCase != null) {
            validators.add(new TagNameCaseValidator(expectedCase));
        }
    }
}

