/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.stream;

import java.util.DoubleSummaryStatistics;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.sis.util.stream.BaseStreamWrapper;

public abstract class DoubleStreamWrapper
extends BaseStreamWrapper<Double, DoubleStream>
implements DoubleStream {
    private DoubleStream source;

    protected DoubleStreamWrapper(DoubleStream source) {
        super(source);
        this.source = source;
    }

    @Override
    final DoubleStream source() {
        if (this.source != null) {
            return this.source;
        }
        throw this.inactive();
    }

    final DoubleStream delegate() {
        DoubleStream s = this.source();
        this.source = null;
        return s;
    }

    private DoubleStream update(DoubleStream result) {
        if (this.source == null) {
            return result;
        }
        this.source = result;
        return this;
    }

    @Override
    public DoubleStream parallel() {
        return this.update(this.source().parallel());
    }

    @Override
    public DoubleStream sequential() {
        return this.update(this.source().sequential());
    }

    @Override
    public DoubleStream unordered() {
        return this.update((DoubleStream)this.source().unordered());
    }

    @Override
    public DoubleStream filter(DoublePredicate predicate) {
        return this.update(this.source().filter(predicate));
    }

    @Override
    public DoubleStream map(DoubleUnaryOperator mapper) {
        return this.update(this.source().map(mapper));
    }

    @Override
    public <U> Stream<U> mapToObj(DoubleFunction<? extends U> mapper) {
        return this.delegate().mapToObj(mapper);
    }

    @Override
    public IntStream mapToInt(DoubleToIntFunction mapper) {
        return this.delegate().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(DoubleToLongFunction mapper) {
        return this.delegate().mapToLong(mapper);
    }

    @Override
    public DoubleStream flatMap(DoubleFunction<? extends DoubleStream> mapper) {
        return this.update(this.source().flatMap(mapper));
    }

    @Override
    public DoubleStream distinct() {
        return this.update(this.source().distinct());
    }

    @Override
    public DoubleStream sorted() {
        return this.update(this.source().sorted());
    }

    @Override
    public DoubleStream peek(DoubleConsumer action) {
        return this.update(this.source().peek(action));
    }

    @Override
    public DoubleStream limit(long maxSize) {
        return this.update(this.source().limit(maxSize));
    }

    @Override
    public DoubleStream skip(long n) {
        return this.update(this.source().skip(n));
    }

    @Override
    public void forEach(DoubleConsumer action) {
        this.source().forEach(action);
    }

    @Override
    public void forEachOrdered(DoubleConsumer action) {
        this.source().forEachOrdered(action);
    }

    @Override
    public double reduce(double identity, DoubleBinaryOperator op) {
        return this.source().reduce(identity, op);
    }

    @Override
    public OptionalDouble reduce(DoubleBinaryOperator op) {
        return this.source().reduce(op);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjDoubleConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        return this.source().collect(supplier, accumulator, combiner);
    }

    @Override
    public double sum() {
        return this.source().sum();
    }

    @Override
    public OptionalDouble min() {
        return this.source().min();
    }

    @Override
    public OptionalDouble max() {
        return this.source().max();
    }

    @Override
    public long count() {
        return this.source().count();
    }

    @Override
    public OptionalDouble average() {
        return this.source().average();
    }

    @Override
    public DoubleSummaryStatistics summaryStatistics() {
        return this.source().summaryStatistics();
    }

    @Override
    public boolean anyMatch(DoublePredicate predicate) {
        return this.source().anyMatch(predicate);
    }

    @Override
    public boolean allMatch(DoublePredicate predicate) {
        return this.source().allMatch(predicate);
    }

    @Override
    public boolean noneMatch(DoublePredicate predicate) {
        return this.source().noneMatch(predicate);
    }

    @Override
    public OptionalDouble findFirst() {
        return this.source().findFirst();
    }

    @Override
    public OptionalDouble findAny() {
        return this.source().findAny();
    }

    @Override
    public Stream<Double> boxed() {
        return this.delegate().boxed();
    }

    @Override
    public PrimitiveIterator.OfDouble iterator() {
        return this.source().iterator();
    }

    @Override
    public Spliterator.OfDouble spliterator() {
        return this.source().spliterator();
    }

    @Override
    public double[] toArray() {
        return this.source().toArray();
    }

    @Override
    public DoubleStream onClose(Runnable closeHandler) {
        return this.update((DoubleStream)this.source().onClose(closeHandler));
    }
}

